/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.model.objectgroup;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import fr.gouv.vitam.common.model.objectgroup.FileInfoModel;
import fr.gouv.vitam.common.model.objectgroup.QualifiersModel;
import fr.gouv.vitam.common.model.objectgroup.StorageRacineModel;
import fr.gouv.vitam.common.model.objectgroup.VersionsModel;
import fr.gouv.vitam.common.model.validations.ValidationError;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;

public class ObjectGroupResponse {
    public static final String QUALIFIERS = "#qualifiers";
    public static final String ID = "#id";
    public static final String TENANT = "#tenant";
    public static final String FILE_INFO = "FileInfo";
    public static final String UNIT_UPS = "#unitups";
    public static final String ALL_UNIT_UPS = "#allunitups";
    public static final String NB_OBJECTS = "#nbobjects";
    public static final String OPERATIONS = "#operations";
    public static final String OPI = "#opi";
    public static final String BATCH_ID = "#batchId";
    public static final String ORIGINATING_AGENCY = "#originating_agency";
    public static final String ORIGINATING_AGENCIES = "#originating_agencies";
    public static final String VERSION = "#version";
    public static final String TYPE = "#type";
    public static final String STORAGE = "#storage";
    public static final String ERRORS = "#errors";
    @JsonProperty(value="#qualifiers")
    private List<QualifiersModel> qualifiers;
    @JsonProperty(value="#id")
    private String id;
    @JsonProperty(value="#tenant")
    private int tenant;
    @JsonProperty(value="FileInfo")
    private FileInfoModel fileInfo;
    @JsonProperty(value="#unitups")
    private List<String> up;
    @JsonProperty(value="#allunitups")
    private List<String> us;
    @JsonProperty(value="#nbobjects")
    private int nbc;
    @JsonProperty(value="#operations")
    private List<String> ops;
    @JsonProperty(value="#opi")
    private String opi;
    @JsonProperty(value="#batchId")
    private String batchId;
    @JsonProperty(value="#originating_agency")
    private String originatingAgency;
    @JsonProperty(value="#originating_agencies")
    private List<String> originatingAgencies;
    @JsonProperty(value="#errors")
    private List<ValidationError> errors;
    @JsonProperty(value="#version")
    private String version;
    @JsonProperty(value="#type")
    private String type;
    @JsonProperty(value="#storage")
    private StorageRacineModel storage;

    public StorageRacineModel getStorage() {
        return this.storage;
    }

    public void setStorage(StorageRacineModel storage) {
        this.storage = storage;
    }

    public List<QualifiersModel> getQualifiers() {
        return this.qualifiers;
    }

    public void setQualifiers(List<QualifiersModel> qualifiers) {
        this.qualifiers = qualifiers;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public int getTenant() {
        return this.tenant;
    }

    public void setTenant(int tenant) {
        this.tenant = tenant;
    }

    public FileInfoModel getFileInfo() {
        return this.fileInfo;
    }

    public void setFileInfo(FileInfoModel fileInfo) {
        this.fileInfo = fileInfo;
    }

    public List<String> getUp() {
        return this.up;
    }

    public void setUp(List<String> up) {
        this.up = up;
    }

    public List<String> getUs() {
        return this.us;
    }

    public void setUs(List<String> us) {
        this.us = us;
    }

    public int getNbc() {
        return this.nbc;
    }

    public void setNbc(int nbc) {
        this.nbc = nbc;
    }

    public List<String> getOps() {
        return this.ops;
    }

    public void setOps(List<String> ops) {
        this.ops = ops;
    }

    public String getOriginatingAgency() {
        return this.originatingAgency;
    }

    public void setOriginatingAgency(String originatingAgency) {
        this.originatingAgency = originatingAgency;
    }

    public List<String> getOriginatingAgencies() {
        return this.originatingAgencies;
    }

    public void setOriginatingAgencies(List<String> originatingAgencies) {
        this.originatingAgencies = originatingAgencies;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getOpi() {
        return this.opi;
    }

    public void setOpi(String opi) {
        this.opi = opi;
    }

    public String getBatchId() {
        return this.batchId;
    }

    public void setBatchId(String batchId) {
        this.batchId = batchId;
    }

    @JsonIgnore
    public Optional<VersionsModel> getLastVersionsModel(String qualifier) {
        Optional<QualifiersModel> first = this.getQualifiersModel(qualifier);
        if (first.isPresent()) {
            return first.get().getVersions().stream().max(Comparator.comparing(VersionsModel::getVersion));
        }
        return Optional.empty();
    }

    @JsonIgnore
    public Optional<VersionsModel> getFirstVersionsModel(String qualifier) {
        Optional<QualifiersModel> modelOptional = this.getQualifiersModel(qualifier);
        if (modelOptional.isPresent()) {
            return modelOptional.get().getVersions().stream().min(Comparator.comparing(VersionsModel::getVersion));
        }
        return Optional.empty();
    }

    private Optional<QualifiersModel> getQualifiersModel(String qualifier) {
        return this.qualifiers.stream().filter(q -> q.getQualifier().equals(qualifier)).findFirst();
    }

    public List<ValidationError> getErrors() {
        return this.errors;
    }

    public ObjectGroupResponse setErrors(List<ValidationError> errors) {
        this.errors = errors;
        return this;
    }
}

