/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.model.dip;

import com.fasterxml.jackson.annotation.JsonIgnore;

public class BinarySizePlatformThreshold {
    private long limit;
    private SizeUnit sizeUnit;

    public BinarySizePlatformThreshold() {
    }

    public BinarySizePlatformThreshold(long limit, SizeUnit sizeUnit) {
        this.limit = limit;
        this.sizeUnit = sizeUnit;
    }

    public long getLimit() {
        return this.limit;
    }

    public void setLimit(long limit) {
        this.limit = limit;
    }

    public SizeUnit getSizeUnit() {
        return this.sizeUnit;
    }

    public void setSizeUnit(SizeUnit sizeUnit) {
        this.sizeUnit = sizeUnit;
    }

    @JsonIgnore
    public long getThreshold() {
        return this.getLimit() * this.getSizeUnit().getByteCount();
    }

    public static enum SizeUnit {
        BYTE(1L),
        KILOBYTE(1024L),
        MEGABYTE(0x100000L),
        GIGABYTE(0x40000000L);

        private final long bytes;

        private SizeUnit(long bytes) {
            this.bytes = bytes;
        }

        public long getByteCount() {
            return this.bytes;
        }
    }
}

