/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.model.administration.preservation;

import com.fasterxml.jackson.annotation.JsonProperty;
import fr.gouv.vitam.common.model.administration.preservation.ActionPreservation;
import fr.gouv.vitam.common.model.administration.preservation.DefaultGriffin;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Positive;
import java.util.List;
import java.util.Set;

public class GriffinByFormat {
    @NotEmpty(message="this field can not be empty")
    @JsonProperty(value="FormatList")
    private @NotEmpty(message="this field can not be empty") Set<String> formatList;
    @NotEmpty(message="this field can not be empty")
    @JsonProperty(value="GriffinIdentifier")
    private @NotEmpty(message="this field can not be empty") String griffinIdentifier;
    @Positive(message="this field must be strictly positive")
    @JsonProperty(value="Timeout")
    private @Positive(message="this field must be strictly positive") int timeOut;
    @Positive(message="this field must be strictly positive")
    @JsonProperty(value="MaxSize")
    private @Positive(message="this field must be strictly positive") long maxSize;
    @NotNull(message="this field can not be empty")
    @JsonProperty(value="Debug")
    private @NotNull(message="this field can not be empty") Boolean debug;
    @NotEmpty(message="this field can not be empty")
    @Valid
    @JsonProperty(value="ActionDetail")
    private @NotEmpty(message="this field can not be empty") @Valid List<ActionPreservation> actionDetail;

    public GriffinByFormat() {
    }

    public GriffinByFormat(DefaultGriffin defaultGriffin) {
        this.griffinIdentifier = defaultGriffin.getGriffinIdentifier();
        this.timeOut = defaultGriffin.getTimeOut();
        this.maxSize = defaultGriffin.getMaxSize();
        this.debug = defaultGriffin.isDebug();
        this.actionDetail = defaultGriffin.getActionDetail();
    }

    public GriffinByFormat(@NotEmpty Set<String> formatList, @NotEmpty String griffinIdentifier, @NotEmpty List<ActionPreservation> actionDetail) {
        this.formatList = formatList;
        this.griffinIdentifier = griffinIdentifier;
        this.actionDetail = actionDetail;
        this.debug = Boolean.FALSE;
    }

    public Set<String> getFormatList() {
        return this.formatList;
    }

    public void setFormatList(Set<String> formatList) {
        this.formatList = formatList;
    }

    public String getGriffinIdentifier() {
        return this.griffinIdentifier;
    }

    public void setGriffinIdentifier(String griffinIdentifier) {
        this.griffinIdentifier = griffinIdentifier;
    }

    public int getTimeOut() {
        return this.timeOut;
    }

    public void setTimeOut(int timeOut) {
        this.timeOut = timeOut;
    }

    public long getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(long maxSize) {
        this.maxSize = maxSize;
    }

    public Boolean isDebug() {
        return this.debug;
    }

    public void setDebug(Boolean debug) {
        this.debug = debug;
    }

    public List<ActionPreservation> getActionDetail() {
        return this.actionDetail;
    }

    public void setActionDetail(List<ActionPreservation> actionDetail) {
        this.actionDetail = actionDetail;
    }

    public String toString() {
        return "GriffinByFormat{formatList=" + String.valueOf(this.formatList) + ", griffinIdentifier='" + this.griffinIdentifier + "', timeOut=" + this.timeOut + ", maxSize=" + this.maxSize + ", debug=" + this.debug + ", actionDetail=" + String.valueOf(this.actionDetail) + "}";
    }
}

