/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.model.administration;

import fr.gouv.vitam.common.model.administration.OntologyType;
import java.util.Arrays;
import java.util.List;

public enum TypeDetail {
    STRING("STRING", List.of(OntologyType.TEXT, OntologyType.KEYWORD, OntologyType.GEO_POINT)),
    ENUM("ENUM", List.of(OntologyType.ENUM, OntologyType.TEXT, OntologyType.KEYWORD)),
    DATETIME("DATETIME", List.of(OntologyType.DATE)),
    DATE("DATE", List.of(OntologyType.DATE)),
    LONG("LONG", List.of(OntologyType.LONG)),
    DOUBLE("DOUBLE", List.of(OntologyType.DOUBLE)),
    BOOLEAN("BOOLEAN", List.of(OntologyType.BOOLEAN));

    private final String type;
    private final List<OntologyType> compatibleTypes;

    private TypeDetail(String type, List<OntologyType> compatibleTypes) {
        this.type = type;
        this.compatibleTypes = compatibleTypes;
    }

    public String getType() {
        return this.type;
    }

    public boolean isCompatibleWithType(OntologyType ontologyType) {
        return this.compatibleTypes.contains((Object)ontologyType);
    }

    public static TypeDetail fromOntologyType(OntologyType ontologyType) {
        return Arrays.stream(TypeDetail.values()).filter(typeDetail -> typeDetail.isCompatibleWithType(ontologyType)).findFirst().orElseThrow();
    }
}

