/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.model.administration;

import jakarta.annotation.Nonnull;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;

public enum RuleMeasurementEnum {
    MONTH("month", 2, ChronoUnit.MONTHS),
    DAY("day", 5, ChronoUnit.DAYS),
    YEAR("year", 1, ChronoUnit.YEARS),
    SECOND("second", 13, ChronoUnit.SECONDS);

    private final String type;
    private final int calendarUnitType;
    private final TemporalUnit temporalUnit;

    private RuleMeasurementEnum(String ruleMeasurement, int calendarUnitType, TemporalUnit temporalUnit) {
        this.type = ruleMeasurement;
        this.calendarUnitType = calendarUnitType;
        this.temporalUnit = temporalUnit;
    }

    public String getType() {
        return this.type;
    }

    public int getCalendarUnitType() {
        return this.calendarUnitType;
    }

    public static RuleMeasurementEnum getEnumFromType(String type) throws IllegalStateException {
        if (type == null) {
            return null;
        }
        for (RuleMeasurementEnum e : RuleMeasurementEnum.values()) {
            if (!e.getType().equalsIgnoreCase(type)) continue;
            return e;
        }
        throw new IllegalStateException("Cannot find RuleMeasurement " + type);
    }

    @Nonnull
    public TemporalUnit getTemporalUnit() {
        return this.temporalUnit;
    }
}

