/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.model;

import jakarta.ws.rs.core.Response;

public enum StatusCode {
    UNKNOWN,
    STARTED,
    ALREADY_EXECUTED,
    OK,
    WARNING,
    KO,
    FATAL;


    public int getStatusLevel() {
        return this.ordinal();
    }

    public boolean isGreaterOrEqualToWarn() {
        return this.compareTo(WARNING) >= 0;
    }

    public boolean isGreaterOrEqualToKo() {
        return this.compareTo(KO) >= 0;
    }

    public boolean isGreaterOrEqualToFatal() {
        return this.compareTo(FATAL) >= 0;
    }

    public boolean isGreaterOrEqualToStarted() {
        return this.compareTo(STARTED) >= 0;
    }

    public Response.Status getEquivalentHttpStatus() {
        switch (this.ordinal()) {
            case 3: {
                return Response.Status.OK;
            }
            case 2: {
                return Response.Status.NO_CONTENT;
            }
            case 4: {
                return Response.Status.PARTIAL_CONTENT;
            }
            case 5: {
                return Response.Status.BAD_REQUEST;
            }
        }
        return Response.Status.INTERNAL_SERVER_ERROR;
    }
}

