/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.model;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import fr.gouv.vitam.common.error.VitamError;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.RequestResponseOK;
import jakarta.ws.rs.core.Response;
import java.util.HashMap;
import java.util.Map;

public abstract class RequestResponse<T> {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(RequestResponse.class);
    @JsonProperty(value="httpCode")
    private int httpCode;
    @JsonIgnore
    private Map<String, String> vitamHeaders = new HashMap<String, String>();

    @JsonGetter(value="httpCode")
    public int getHttpCode() {
        return this.httpCode;
    }

    @JsonSetter(value="httpCode")
    public RequestResponse<T> setHttpCode(int httpCode) {
        this.httpCode = httpCode;
        return this;
    }

    @JsonIgnore
    public int getStatus() {
        return this.httpCode;
    }

    @JsonIgnore
    public boolean isOk() {
        return this instanceof RequestResponseOK;
    }

    @JsonIgnore
    public RequestResponse<T> addHeader(String key, String value) {
        this.vitamHeaders.put(key, value);
        return this;
    }

    @JsonIgnore
    public String getHeaderString(String key) {
        return this.vitamHeaders.get(key);
    }

    @JsonIgnore
    public Map<String, String> getVitamHeaders() {
        return this.vitamHeaders;
    }

    @JsonIgnore
    public void unSetVitamHeaders() {
        this.vitamHeaders = null;
    }

    public String toString() {
        return JsonHandler.unprettyPrint(this);
    }

    @JsonIgnore
    public JsonNode toJsonNode() {
        try {
            return JsonHandler.getFromString(this.toString());
        }
        catch (InvalidParseOperationException e) {
            LOGGER.error(e);
            throw new IllegalStateException(e);
        }
    }

    @JsonIgnore
    public RequestResponse<T> parseHeadersFromResponse(Response response) {
        if (response != null && response.getHeaders() != null) {
            for (String key : response.getHeaders().keySet()) {
                if (!key.startsWith("X-") && !key.startsWith("x-")) continue;
                this.vitamHeaders.put(key, response.getHeaderString(key));
            }
        }
        if (response != null) {
            this.setHttpCode(response.getStatus());
        }
        return this;
    }

    @JsonIgnore
    public static RequestResponse<JsonNode> parseFromResponse(Response response) throws IllegalStateException {
        return RequestResponse.parseFromResponse(response, JsonNode.class);
    }

    @JsonIgnore
    public static <T> RequestResponse<T> parseFromResponse(Response response, Class<T> clazz) throws IllegalStateException {
        String result = (String)response.readEntity(String.class);
        if (result != null && !result.isEmpty()) {
            if (result.contains("$hits")) {
                try {
                    RequestResponseOK<T> ret = RequestResponseOK.getFromJsonNode(JsonHandler.getFromString(result), clazz);
                    return ret.parseHeadersFromResponse(response);
                }
                catch (InvalidParseOperationException e) {
                    LOGGER.warn("Issue while decoding RequestResponseOk", e);
                }
            } else if (result.contains("httpCode")) {
                try {
                    VitamError error = (VitamError)JsonHandler.getFromStringAsTypeReference(result, new TypeReference<VitamError<T>>(){});
                    return error.parseHeadersFromResponse(response);
                }
                catch (InvalidFormatException | InvalidParseOperationException e) {
                    LOGGER.warn("Issue while decoding VitamError", e);
                }
            }
            throw new IllegalStateException("Cannot parse the response");
        }
        return VitamError.newVitamError(clazz).setCode("").setHttpCode(response.getStatus()).addHeader("X-Request-Id", response.getHeaderString("X-Request-Id"));
    }

    @JsonIgnore
    public static <T> RequestResponseOK<T> parseRequestResponseOk(Response response, Class<T> clasz) throws InvalidParseOperationException {
        RequestResponseOK<T> ret = RequestResponseOK.getFromJsonNode(JsonHandler.getFromString((String)response.readEntity(String.class)), clasz);
        ret.parseHeadersFromResponse(response);
        return ret;
    }

    @JsonIgnore
    public static RequestResponseOK<JsonNode> parseRequestResponseOk(Response response) throws InvalidParseOperationException {
        return RequestResponse.parseRequestResponseOk(response, JsonNode.class);
    }

    @JsonIgnore
    public static <T> VitamError<T> parseVitamError(Response response, Class<T> clasz) throws InvalidParseOperationException {
        VitamError<T> error = VitamError.getFromJsonNode(JsonHandler.getFromString((String)response.readEntity(String.class)), clasz);
        error.parseHeadersFromResponse(response);
        return error;
    }

    @JsonIgnore
    public static VitamError<JsonNode> parseVitamError(Response response) throws InvalidParseOperationException {
        return VitamError.parseVitamError(response, JsonNode.class);
    }

    @JsonIgnore
    public static boolean isRequestResponseOk(JsonNode requestResponseAsJsonNode) throws IllegalStateException {
        if (requestResponseAsJsonNode.has("httpCode") && requestResponseAsJsonNode.get("httpCode").isInt()) {
            int httpCode = requestResponseAsJsonNode.get("httpCode").asInt();
            Response.Status.Family family = Response.Status.Family.familyOf((int)httpCode);
            switch (family) {
                case SUCCESSFUL: 
                case REDIRECTION: {
                    return true;
                }
                case CLIENT_ERROR: 
                case SERVER_ERROR: {
                    return false;
                }
            }
        }
        throw new IllegalStateException("Response is not a valid instance of RequestResponse");
    }

    @JsonIgnore
    public static boolean isRequestResponseEmpty(JsonNode requestResponseAsJsonNode) {
        return requestResponseAsJsonNode != null && requestResponseAsJsonNode.has("$hits") && requestResponseAsJsonNode.get("$hits").has("total") && requestResponseAsJsonNode.get("$hits").get("total").toString().equals("0");
    }

    public abstract Response toResponse();
}

