/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.model;

import fr.gouv.vitam.common.exception.StateNotAllowedException;
import jakarta.ws.rs.core.Response;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum ProcessState {
    PAUSE{

        @Override
        public void eval(ProcessState targetState) throws StateNotAllowedException {
            if (null == targetState) {
                throw new StateNotAllowedException("ProcessState must not be null");
            }
            switch (targetState) {
                case RUNNING: 
                case PAUSE: 
                case COMPLETED: {
                    break;
                }
                default: {
                    super.eval(targetState);
                }
            }
        }
    }
    ,
    RUNNING{

        @Override
        public void eval(ProcessState targetState) throws StateNotAllowedException {
            if (null == targetState) {
                throw new StateNotAllowedException("ProcessState must not be null");
            }
            switch (targetState) {
                case PAUSE: 
                case COMPLETED: {
                    break;
                }
                default: {
                    super.eval(targetState);
                }
            }
        }
    }
    ,
    COMPLETED;


    public void eval(ProcessState targetState) throws StateNotAllowedException {
        throw new StateNotAllowedException("The processState " + targetState.name() + " is not allowed for the current state " + this.name());
    }

    public Response.Status getEquivalentHttpStatus() {
        switch (this.ordinal()) {
            case 2: {
                return Response.Status.OK;
            }
        }
        return Response.Status.ACCEPTED;
    }
}

