/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Strings;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.model.ProcessState;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.model.processing.StatusAggregationBehavior;
import fr.gouv.vitam.common.model.validations.ValidationError;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;

@JsonIgnoreProperties
public class ItemStatus {
    private static final String EVENT_DETAIL_DATA = "eventDetailData";
    private static final String MANDATORY_PARAMETER = "Mandatory parameter";
    private static final String MASTER_DATA = "masterData";
    @JsonProperty(value="itemsStatus")
    private LinkedHashMap<String, ItemStatus> itemsStatus = new LinkedHashMap();
    @JsonProperty(value="subTaskStatus")
    private LinkedHashMap<String, ItemStatus> subTaskStatus = new LinkedHashMap();
    @JsonProperty(value="itemId")
    private String itemId;
    @JsonProperty(value="message")
    protected String message;
    @JsonProperty(value="globalStatus")
    private StatusCode globalStatus;
    @JsonProperty(value="statusMeter")
    private List<Integer> statusMeter;
    @JsonProperty(value="validationErrors")
    private List<ValidationError> validationErrors;
    @JsonProperty(value="data")
    protected Map<String, Object> data;
    @JsonProperty(value="globalState")
    private ProcessState globalState;
    @JsonProperty(value="globalOutcomeDetailSubcode")
    private String globalOutcomeDetailSubcode;
    @JsonProperty(value="lifecycleEnable")
    private boolean lifecycleEnable = true;
    @JsonIgnore
    private String logbookTypeProcess;

    public ItemStatus() {
        this.statusMeter = new ArrayList<Integer>();
        for (int i = StatusCode.UNKNOWN.getStatusLevel(); i <= StatusCode.FATAL.getStatusLevel(); ++i) {
            this.statusMeter.add(0);
        }
        this.globalStatus = StatusCode.UNKNOWN;
        this.data = new HashMap<String, Object>();
        this.validationErrors = new ArrayList<ValidationError>();
    }

    public ItemStatus(@JsonProperty(value="itemId") String itemId, @JsonProperty(value="message") String message, @JsonProperty(value="globalStatus") StatusCode globalStatus, @JsonProperty(value="statusMeter") List<Integer> statusMeter, @JsonProperty(value="data") Map<String, Object> data, @JsonProperty(value="itemsStatus") LinkedHashMap<String, ItemStatus> itemsStatus, @JsonProperty(value="globalState") ProcessState globalState, @JsonProperty(value="validationErrors") List<ValidationError> validationErrors) {
        this.itemsStatus = itemsStatus;
        this.itemId = itemId;
        this.message = message;
        this.globalStatus = globalStatus;
        this.statusMeter = statusMeter;
        this.data = data;
        this.globalState = globalState;
        this.validationErrors = validationErrors == null ? new ArrayList() : validationErrors;
    }

    public ItemStatus(String itemId) {
        this();
        this.itemId = itemId;
    }

    public String getMessage() {
        if (Strings.isNullOrEmpty((String)this.message)) {
            return "";
        }
        return this.message;
    }

    public ItemStatus setMessage(String message) {
        ParametersChecker.checkParameter(MANDATORY_PARAMETER, message);
        this.message = message;
        return this;
    }

    public String getItemId() {
        if (Strings.isNullOrEmpty((String)this.itemId)) {
            return "";
        }
        return this.itemId;
    }

    public ItemStatus setItemId(String itemId) {
        ParametersChecker.checkParameter(MANDATORY_PARAMETER, itemId);
        this.itemId = itemId;
        return this;
    }

    public List<Integer> getStatusMeter() {
        return this.statusMeter;
    }

    public ItemStatus increment(StatusCode statusCode) {
        return this.increment(statusCode, 1);
    }

    public ItemStatus increment(StatusCode statusCode, int increment) {
        return this.increment(statusCode, increment, new ValidationError[0]);
    }

    public ItemStatus increment(StatusCode statusCode, ValidationError ... validationErrors) {
        return this.increment(statusCode, 1, validationErrors);
    }

    private ItemStatus increment(StatusCode statusCode, int increment, ValidationError ... validationErrors) {
        ParametersChecker.checkParameter(MANDATORY_PARAMETER, new Object[]{statusCode});
        this.statusMeter.set(statusCode.getStatusLevel(), increment + this.statusMeter.get(statusCode.getStatusLevel()));
        StatusCode statusCode2 = this.globalStatus = this.globalStatus.compareTo(statusCode) > 0 ? this.globalStatus : statusCode;
        if (ArrayUtils.isNotEmpty((Object[])validationErrors)) {
            ParametersChecker.checkParameter("Missing validation errors", validationErrors);
            if (statusCode != StatusCode.KO) {
                throw new IllegalArgumentException("Cannot add validation errors for status code " + String.valueOf((Object)statusCode));
            }
            this.validationErrors.addAll(Arrays.asList(validationErrors));
        }
        return this;
    }

    protected static ItemStatus increment(ItemStatus itemStatus1, ItemStatus itemStatus2) {
        ParametersChecker.checkParameter(MANDATORY_PARAMETER, itemStatus1, itemStatus2);
        for (int i = StatusCode.UNKNOWN.getStatusLevel(); i <= StatusCode.FATAL.getStatusLevel(); ++i) {
            itemStatus1.getStatusMeter().set(i, itemStatus1.getStatusMeter().get(i) + itemStatus2.getStatusMeter().get(i));
        }
        itemStatus1.setGlobalStatus(itemStatus1.getGlobalStatus().compareTo(itemStatus2.getGlobalStatus()) >= 1 ? itemStatus1.getGlobalStatus() : itemStatus2.getGlobalStatus());
        Set<String> keySet1 = itemStatus1.getItemsStatus().keySet();
        Set<String> keySet2 = itemStatus2.getItemsStatus().keySet();
        for (String key : keySet2) {
            if (!keySet1.contains(key) || key.equals(itemStatus1.getItemId())) continue;
            itemStatus1.getItemsStatus().put(key, ItemStatus.increment(itemStatus1.getItemsStatus().get(key), itemStatus2.getItemsStatus().get(key)));
        }
        if (itemStatus2.getGlobalOutcomeDetailSubcode() != null && itemStatus1.getGlobalOutcomeDetailSubcode() == null) {
            itemStatus1.setGlobalOutcomeDetailSubcode(itemStatus2.getGlobalOutcomeDetailSubcode());
        }
        return itemStatus1;
    }

    public StatusCode getGlobalStatus() {
        return this.globalStatus;
    }

    private ItemStatus setGlobalStatus(StatusCode globalStatus) {
        ParametersChecker.checkParameter(MANDATORY_PARAMETER, new Object[]{globalStatus});
        this.globalStatus = globalStatus;
        return this;
    }

    public Object getData(String key) {
        return this.data.get(key);
    }

    @Deprecated
    public Map<String, Object> getData() {
        return this.data;
    }

    public ItemStatus setData(String key, Object value) {
        if (EVENT_DETAIL_DATA.equals(key)) {
            throw new IllegalArgumentException("Invalid key, Use apropriate methode  setEvDetailData ");
        }
        this.data.put(key, value);
        return this;
    }

    @JsonIgnore
    public Map<String, Object> getMasterData() {
        return (Map)this.data.get(MASTER_DATA);
    }

    @JsonIgnore
    public ItemStatus setMasterData(String key, Object value) {
        this.data.computeIfAbsent(MASTER_DATA, k -> new HashMap());
        ((Map)this.data.get(MASTER_DATA)).put(key, value);
        return this;
    }

    public String computeStatusMeterMessage() {
        StringBuilder computeMessage = new StringBuilder();
        StatusCode[] statusCodes = StatusCode.values();
        for (int i = StatusCode.UNKNOWN.getStatusLevel(); i <= StatusCode.FATAL.getStatusLevel(); ++i) {
            if (this.statusMeter.get(i) <= 0) continue;
            computeMessage.append(" ").append((Object)statusCodes[i]).append(":").append(this.statusMeter.get(i));
        }
        return computeMessage.toString();
    }

    public Map<String, ItemStatus> getItemsStatus() {
        return this.itemsStatus;
    }

    public ItemStatus setItemsStatus(String itemId, ItemStatus statusDetails) {
        return this.setItemsStatus(itemId, statusDetails, StatusAggregationBehavior.DEFAULT);
    }

    public ItemStatus setItemsStatus(String itemId, ItemStatus statusDetails, StatusAggregationBehavior statusAggregationBehavior) {
        ParametersChecker.checkParameter(MANDATORY_PARAMETER, itemId, statusDetails);
        if (this.itemsStatus.containsKey(itemId)) {
            this.itemsStatus.put(itemId, ItemStatus.increment(this.itemsStatus.get(itemId), statusDetails));
        } else {
            this.itemsStatus.put(itemId, statusDetails);
        }
        this.globalStatus = StatusAggregationBehavior.KO_CAUSES_WARNING.equals((Object)statusAggregationBehavior) && StatusCode.KO.equals((Object)statusDetails.getGlobalStatus()) ? StatusCode.WARNING : (this.globalStatus.compareTo(statusDetails.getGlobalStatus()) > 0 ? this.globalStatus : statusDetails.getGlobalStatus());
        for (int i = StatusCode.UNKNOWN.getStatusLevel(); i <= StatusCode.FATAL.getStatusLevel(); ++i) {
            this.statusMeter.set(i, this.statusMeter.get(i) + statusDetails.getStatusMeter().get(i));
        }
        if (statusDetails.getData() != null) {
            this.computeEvDetData(statusDetails);
        }
        if (statusDetails.getMasterData() != null) {
            this.computeMasterData(statusDetails);
        }
        if (statusDetails.getGlobalOutcomeDetailSubcode() != null) {
            this.globalOutcomeDetailSubcode = statusDetails.getGlobalOutcomeDetailSubcode();
        }
        if (CollectionUtils.isNotEmpty(statusDetails.getValidationErrors())) {
            this.validationErrors.addAll(statusDetails.getValidationErrors());
        }
        return this;
    }

    public ItemStatus setItemsStatus(ItemStatus compositeItemStatus) {
        ParametersChecker.checkParameter(MANDATORY_PARAMETER, compositeItemStatus);
        this.increment(compositeItemStatus.getGlobalStatus(), compositeItemStatus.getStatusMeter().get(compositeItemStatus.getGlobalStatus().ordinal()));
        if (compositeItemStatus.getItemsStatus() != null && !compositeItemStatus.getItemsStatus().isEmpty()) {
            for (Map.Entry<String, ItemStatus> itemStatus : compositeItemStatus.getItemsStatus().entrySet()) {
                String key = itemStatus.getKey();
                ItemStatus value = itemStatus.getValue();
                ItemStatus is = this.itemsStatus.get(key);
                if (is != null) {
                    if (value.getGlobalStatus().isGreaterOrEqualToKo() && null != value.getData() && value.getData().size() > 0) {
                        is.getData().putAll(value.getData());
                    }
                    this.itemsStatus.put(key, ItemStatus.increment(is, value));
                    continue;
                }
                this.itemsStatus.put(itemStatus.getKey(), itemStatus.getValue());
            }
            if (compositeItemStatus.getData() != null) {
                this.computeEvDetData(compositeItemStatus);
            }
            if (compositeItemStatus.getMasterData() != null) {
                this.computeMasterData(compositeItemStatus);
            }
            if (compositeItemStatus.getGlobalOutcomeDetailSubcode() != null) {
                this.globalOutcomeDetailSubcode = compositeItemStatus.getGlobalOutcomeDetailSubcode();
            }
            if (CollectionUtils.isNotEmpty(compositeItemStatus.getValidationErrors())) {
                this.validationErrors.addAll(compositeItemStatus.getValidationErrors());
            }
        }
        return this;
    }

    public ProcessState getGlobalState() {
        return this.globalState;
    }

    public ItemStatus setGlobalState(ProcessState globalState) {
        ParametersChecker.checkParameter(MANDATORY_PARAMETER, new Object[]{globalState});
        this.globalState = globalState;
        return this;
    }

    @JsonIgnore
    public boolean shallStop(boolean blocking) {
        return this.getGlobalStatus().isGreaterOrEqualToFatal() || blocking && this.getGlobalStatus().isGreaterOrEqualToKo();
    }

    public LinkedHashMap<String, ItemStatus> getSubTaskStatus() {
        return this.subTaskStatus;
    }

    public ItemStatus setSubTaskStatus(String taskId, ItemStatus taskStatus) {
        ParametersChecker.checkParameterDefault("taskId", taskId);
        this.subTaskStatus.put(taskId, taskStatus);
        return this;
    }

    public ItemStatus setSubTasksStatus(Map<String, ItemStatus> tasks) {
        ParametersChecker.checkParameterDefault("taskId", "TaskId is required");
        this.subTaskStatus.putAll(tasks);
        return this;
    }

    @JsonIgnore
    public String getEvDetailData() {
        String evDetailData = (String)this.data.get(EVENT_DETAIL_DATA);
        if (Strings.isNullOrEmpty((String)evDetailData)) {
            return "{}";
        }
        return evDetailData;
    }

    @JsonIgnore
    public ItemStatus setEvDetailData(String evDetailData) {
        ParametersChecker.checkParameterDefault("evDetailData", evDetailData);
        try {
            JsonHandler.validate(evDetailData);
        }
        catch (InvalidParseOperationException e) {
            throw new IllegalArgumentException("Value of eventDetailData has to be a Valid Json", e);
        }
        this.data.put(EVENT_DETAIL_DATA, evDetailData);
        return this;
    }

    public String getLogbookTypeProcess() {
        return this.logbookTypeProcess;
    }

    public ItemStatus setLogbookTypeProcess(String logbookTypeProcess) {
        this.logbookTypeProcess = logbookTypeProcess;
        return this;
    }

    private void computeEvDetData(ItemStatus statusDetails) {
        String detailDataString = "";
        if (!Strings.isNullOrEmpty((String)statusDetails.getEvDetailData()) && this.data.containsKey(EVENT_DETAIL_DATA)) {
            try {
                ObjectNode subDetailData = (ObjectNode)JsonHandler.getFromString(statusDetails.getEvDetailData());
                ObjectNode detailData = (ObjectNode)JsonHandler.getFromString((String)this.data.get(EVENT_DETAIL_DATA));
                subDetailData.setAll(detailData);
                detailDataString = JsonHandler.unprettyPrint(subDetailData);
            }
            catch (InvalidParseOperationException e) {
                throw new IllegalArgumentException("value of eventDetailData has to be a Valid Json");
            }
        }
        this.data.putAll(statusDetails.getData());
        if (!detailDataString.isEmpty()) {
            this.data.put(EVENT_DETAIL_DATA, detailDataString);
        }
    }

    private void computeMasterData(ItemStatus statusDetails) {
        String detailDataString = "";
        if (statusDetails.getMasterData().containsKey(EVENT_DETAIL_DATA) && this.getMasterData().containsKey(EVENT_DETAIL_DATA)) {
            try {
                ObjectNode subDetailData = (ObjectNode)JsonHandler.getFromString((String)statusDetails.getMasterData().get(EVENT_DETAIL_DATA));
                ObjectNode detailData = (ObjectNode)JsonHandler.getFromString((String)this.getMasterData().get(EVENT_DETAIL_DATA));
                subDetailData.setAll(detailData);
                detailDataString = JsonHandler.unprettyPrint(subDetailData);
            }
            catch (InvalidParseOperationException e) {
                throw new IllegalArgumentException("value of eventDetailData has to be a Valid Json");
            }
        }
        this.getMasterData().putAll(statusDetails.getMasterData());
        if (!detailDataString.isEmpty()) {
            this.getMasterData().put(EVENT_DETAIL_DATA, detailDataString);
        }
    }

    public String getGlobalOutcomeDetailSubcode() {
        return this.globalOutcomeDetailSubcode;
    }

    public ItemStatus setGlobalOutcomeDetailSubcode(String globalOutcomeDetailSubcode) {
        this.globalOutcomeDetailSubcode = globalOutcomeDetailSubcode;
        return this;
    }

    public boolean isLifecycleEnable() {
        return this.lifecycleEnable;
    }

    public ItemStatus disableLfc() {
        this.lifecycleEnable = false;
        return this;
    }

    public void setStatusMeterValue(StatusCode statusCode, Integer value) {
        this.statusMeter.set(statusCode.getStatusLevel(), value);
    }

    public void reinitStatusMeter() {
        for (int i = 0; i < this.statusMeter.size(); ++i) {
            this.statusMeter.set(i, 0);
        }
    }

    public void clearStatusMeterFatal() {
        this.statusMeter.set(StatusCode.FATAL.ordinal(), 0);
        this.globalStatus = StatusCode.STARTED;
        for (StatusCode statusCode : StatusCode.values()) {
            Integer count = this.statusMeter.get(statusCode.ordinal());
            if (count <= 0) continue;
            this.globalStatus = this.globalStatus.compareTo(statusCode) > 0 ? this.globalStatus : statusCode;
        }
        for (ItemStatus is : this.itemsStatus.values()) {
            is.clearStatusMeterFatal();
            this.globalStatus = this.globalStatus.compareTo(is.globalStatus) > 0 ? this.globalStatus : is.globalStatus;
        }
        for (ItemStatus is : this.subTaskStatus.values()) {
            is.clearStatusMeterFatal();
            this.globalStatus = this.globalStatus.compareTo(is.globalStatus) > 0 ? this.globalStatus : is.globalStatus;
        }
    }

    public List<ValidationError> getValidationErrors() {
        return this.validationErrors;
    }

    public void clearValidationErrors() {
        this.validationErrors.clear();
        for (ItemStatus value : this.itemsStatus.values()) {
            value.clearValidationErrors();
        }
        for (ItemStatus value : this.subTaskStatus.values()) {
            value.clearValidationErrors();
        }
    }
}

