/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import org.apache.commons.lang3.StringUtils;

@JsonIgnoreProperties(ignoreUnknown=true)
public class AuditOptions {
    @JsonProperty(value="auditType")
    private String auditType;
    @JsonProperty(value="objectId")
    private String objectId;
    @JsonProperty(value="query")
    private JsonNode query;
    @JsonProperty(value="auditActions")
    private String auditActions;

    public AuditOptions() {
    }

    public AuditOptions(String auditType, String objectId, JsonNode query, String auditActions) {
        this.auditType = auditType;
        this.objectId = objectId;
        this.query = query;
        this.auditActions = auditActions;
    }

    public String getAuditType() {
        return this.auditType;
    }

    public void setAuditType(String auditType) {
        this.auditType = auditType;
    }

    public String getObjectId() {
        return this.objectId;
    }

    public void setObjectId(String objectId) {
        this.objectId = objectId;
    }

    public JsonNode getQuery() {
        return this.query;
    }

    public void setQuery(JsonNode query) {
        this.query = query;
    }

    public String getAuditActions() {
        return this.auditActions;
    }

    public void setAuditActions(String auditActions) {
        this.auditActions = auditActions;
    }

    @JsonIgnore
    public void checkValid() {
        Object errorMessage = null;
        if (this.auditType == null) {
            errorMessage = "The field auditType is mandatory";
        } else if (this.auditActions == null) {
            errorMessage = "The field auditActions is mandatory";
        } else {
            switch (this.auditType) {
                case "tenant": 
                case "originatingagency": {
                    if (!StringUtils.isBlank((CharSequence)this.objectId)) break;
                    errorMessage = "The field objectId is mandatory with auditType " + this.auditType;
                    break;
                }
                case "dsl": {
                    if (this.query != null) break;
                    errorMessage = "The field query is mandatory with auditType " + this.auditType;
                    break;
                }
                default: {
                    errorMessage = "The field auditType is invalid";
                }
            }
        }
        if (errorMessage != null) {
            throw new IllegalArgumentException((String)errorMessage);
        }
    }
}

