/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.logging;

import fr.gouv.vitam.common.logging.JdkLoggerFactory;
import fr.gouv.vitam.common.logging.LogbackLoggerFactory;
import fr.gouv.vitam.common.logging.SysErrLogger;
import fr.gouv.vitam.common.logging.VitamLogLevel;
import fr.gouv.vitam.common.logging.VitamLogger;

public abstract class VitamLoggerFactory {
    private static volatile VitamLoggerFactory defaultFactory;
    protected static VitamLogLevel currentLevel;
    private static boolean initialized;
    static Object serverIdentity;

    private static void initIdentity() {
        if (initialized) {
            return;
        }
        try {
            Class<?> clasz = Class.forName("fr.gouv.vitam.common.ServerIdentity", true, VitamLoggerFactory.class.getClassLoader());
            serverIdentity = clasz.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            SysErrLogger.FAKE_LOGGER.ignoreLog(e);
        }
        catch (Throwable e) {
            System.err.println("Issue while initializing Identiy :" + e.getMessage());
            e.printStackTrace(System.err);
            throw new RuntimeException("Issue while initializing Identiy", e);
        }
        initialized = true;
    }

    public VitamLoggerFactory(VitamLogLevel level) {
        VitamLoggerFactory.setInternalLogLevel(level);
        if (currentLevel == null) {
            VitamLoggerFactory.setInternalLogLevel(this.getLevelSpecific());
        }
    }

    public static VitamLoggerFactory getDefaultFactory() {
        return defaultFactory;
    }

    public static void setDefaultFactory(VitamLoggerFactory defaultFactory) {
        if (defaultFactory == null) {
            throw new IllegalArgumentException("defaultFactory must not be null");
        }
        VitamLoggerFactory.defaultFactory = defaultFactory;
    }

    public static VitamLogger getInstance(Class<?> clazz) {
        return VitamLoggerFactory.getInstance(clazz.getName());
    }

    public static VitamLogger getInstance(String name) {
        return VitamLoggerFactory.getDefaultFactory().newInstance(name);
    }

    public static VitamLogLevel getLogLevel() {
        return VitamLoggerFactory.getDefaultFactory().getLevelSpecific();
    }

    public static void setLogLevel(VitamLogLevel level) {
        VitamLoggerFactory.setInternalLogLevel(level);
        if (currentLevel != null) {
            VitamLoggerFactory.getDefaultFactory().seLevelSpecific(currentLevel);
        }
    }

    protected static synchronized void setInternalLogLevel(VitamLogLevel level) {
        if (level != null) {
            currentLevel = level;
        }
    }

    protected abstract VitamLogLevel getLevelSpecific();

    protected abstract void seLevelSpecific(VitamLogLevel var1);

    protected abstract VitamLogger newInstance(String var1);

    static {
        VitamLoggerFactory f;
        currentLevel = null;
        initialized = false;
        serverIdentity = null;
        String name = VitamLoggerFactory.class.getName();
        try {
            f = new LogbackLoggerFactory(true);
            f.newInstance(name).debug("Using Logback (SLF4J) as the default logging framework");
            defaultFactory = f;
        }
        catch (Exception t1) {
            SysErrLogger.FAKE_LOGGER.ignoreLog(t1);
            f = new JdkLoggerFactory(null);
            f.newInstance(name).debug("Using java.util.logging as the default logging framework", t1);
        }
        defaultFactory = f;
        VitamLoggerFactory.initIdentity();
    }
}

