/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.i18n;

import fr.gouv.vitam.common.CharsetUtils;
import fr.gouv.vitam.common.PropertiesUtils;
import fr.gouv.vitam.common.i18n.PluginPropertiesLoader;
import fr.gouv.vitam.common.i18n.VitamResourceBundle;
import fr.gouv.vitam.common.logging.SysErrLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

public class Messages {
    private static final String LFC_PREFIX = "LFC.";
    private final String bundleName;
    public static final Locale DEFAULT_LOCALE = Locale.FRENCH;
    private final ResourceBundle resourceBundle;
    private Locale locale;

    public Messages(String bundleName) {
        this(bundleName, DEFAULT_LOCALE);
    }

    public Messages(String bundleName, Locale locale) {
        this.bundleName = bundleName;
        this.locale = locale;
        this.resourceBundle = this.init();
    }

    private final ResourceBundle init() {
        if (this.locale == null) {
            this.locale = Locale.FRENCH;
        }
        VitamResourceBundle vitamResourceBundle = null;
        File bundleFile = PropertiesUtils.fileFromConfigFolder(this.bundleName + "_" + this.locale.toLanguageTag() + ".properties");
        if (bundleFile.canRead()) {
            try (FileInputStream inputStream = new FileInputStream(bundleFile);){
                vitamResourceBundle = new VitamResourceBundle(new InputStreamReader((InputStream)inputStream, CharsetUtils.UTF8));
            }
            catch (IOException e) {
                SysErrLogger.FAKE_LOGGER.ignoreLog(e);
            }
        }
        if (null == vitamResourceBundle) {
            return ResourceBundle.getBundle(this.bundleName, this.locale, new UTF8Control());
        }
        vitamResourceBundle.setParent(ResourceBundle.getBundle(this.bundleName, this.locale, new UTF8Control()));
        return vitamResourceBundle;
    }

    public Map<String, String> getAllMessages() {
        HashMap<String, String> bundleMap = new HashMap<String, String>();
        for (String key : this.resourceBundle.keySet()) {
            String value = MessageFormat.format(this.resourceBundle.getString(key), "");
            bundleMap.put(key, value);
        }
        return bundleMap;
    }

    public final String getString(String key) {
        try {
            return this.resourceBundle.getString(key);
        }
        catch (MissingResourceException e) {
            SysErrLogger.FAKE_LOGGER.ignoreLog(e);
            return this.getFakeMessage(key, new Object[0]);
        }
    }

    public final String getString(String key, Object ... args) {
        try {
            String source = this.resourceBundle.getString(key);
            return MessageFormat.format(source, args);
        }
        catch (MissingResourceException e) {
            SysErrLogger.FAKE_LOGGER.ignoreLog(e);
            return this.getFakeMessage(key, args);
        }
    }

    private String getFakeMessage(String key, Object ... args) {
        StringBuilder builder = new StringBuilder("!").append(key).append('!');
        if (args != null) {
            for (Object object : args) {
                builder.append(" ").append(object);
            }
        }
        return builder.toString();
    }

    public final String getStringNotEmpty(String key, Object ... args) {
        try {
            String source = this.resourceBundle.getString(key);
            if (source == null || source.isEmpty()) {
                return this.getFakeMessage(key, args);
            }
            return MessageFormat.format(source, args);
        }
        catch (MissingResourceException e) {
            SysErrLogger.FAKE_LOGGER.ignoreLog(e);
            String pluginKey = "";
            pluginKey = key.contains(LFC_PREFIX) ? key.replace(LFC_PREFIX, "") : key;
            String source = PluginPropertiesLoader.getString(pluginKey);
            if (source == null || source.isEmpty()) {
                return this.getFakeMessage(key, args);
            }
            return MessageFormat.format(source, args);
        }
    }

    public Locale getLocale() {
        return this.locale;
    }

    public boolean containsKey(String key) {
        return this.resourceBundle.containsKey(key);
    }

    private static final class UTF8Control
    extends ResourceBundle.Control {
        private UTF8Control() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) throws IllegalAccessException, InstantiationException, IOException {
            String bundleName = this.toBundleName(baseName, locale);
            String resourceName = this.toResourceName(bundleName, "properties");
            PropertyResourceBundle bundle = null;
            InputStream stream = null;
            if (reload) {
                URLConnection connection;
                URL url = loader.getResource(resourceName);
                if (url != null && (connection = url.openConnection()) != null) {
                    connection.setUseCaches(false);
                    stream = connection.getInputStream();
                }
            } else {
                stream = loader.getResourceAsStream(resourceName);
            }
            if (stream != null) {
                try (InputStreamReader isr = new InputStreamReader(stream, CharsetUtils.UTF8);){
                    bundle = new PropertyResourceBundle(isr);
                }
                finally {
                    stream.close();
                }
            }
            return bundle;
        }
    }
}

