/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.guid;

public final class GUIDObjectType {
    public static final int UNASSIGNED_TYPE = 0;
    public static final int UNIT_TYPE = 1;
    public static final int OBJECTGROUP_TYPE = 2;
    public static final int OBJECT_TYPE = 3;
    public static final int OPERATION_LOGBOOK_TYPE = 4;
    public static final int WRITE_LOGBOOK_TYPE = 5;
    public static final int MANIFEST_TYPE = 6;
    public static final int EVENT_TYPE = 7;
    public static final int REQUESTID_TYPE = 8;
    public static final int STORAGE_OPERATION_TYPE = 9;
    public static final int ACCESSION_REGISTER_SUMMARY_TYPE = 10;
    public static final int CONTRACT_TYPE = 11;
    public static final int PROFILE_TYPE = 12;
    public static final int CONTEXT_TYPE = 13;
    public static final int ACCESSION_REGISTER_DETAIL_TYPE = 14;
    public static final int AGENCY_TYPE = 15;
    public static final int ONTOLOGY_TYPE = 16;

    private GUIDObjectType() {
    }

    public static GUIDObjectEnumType getEnumType(int id) {
        switch (id) {
            case 0: {
                return GUIDObjectEnumType.UNASSIGNED;
            }
            case 1: {
                return GUIDObjectEnumType.UNIT;
            }
            case 2: {
                return GUIDObjectEnumType.OBJECTGROUP;
            }
            case 3: {
                return GUIDObjectEnumType.OBJECT;
            }
            case 4: {
                return GUIDObjectEnumType.OPERATION_LOGBOOK;
            }
            case 5: {
                return GUIDObjectEnumType.WRITE_LOGBOOK;
            }
            case 6: {
                return GUIDObjectEnumType.MANIFEST;
            }
            case 7: {
                return GUIDObjectEnumType.EVENT;
            }
            case 8: {
                return GUIDObjectEnumType.REQUESTID;
            }
            case 9: {
                return GUIDObjectEnumType.STORAGE_OPERATION;
            }
            case 10: {
                return GUIDObjectEnumType.ACCESSION_REGISTER_SUMMARY;
            }
            case 11: {
                return GUIDObjectEnumType.CONTRACT;
            }
            case 15: {
                return GUIDObjectEnumType.AGENCIES;
            }
            case 16: {
                return GUIDObjectEnumType.ONTOLOGIES;
            }
        }
        return GUIDObjectEnumType.UNASSIGNED;
    }

    public static int getChildrenType(int type) {
        switch (type) {
            case 1: {
                return 2;
            }
            case 2: {
                return 3;
            }
        }
        return type;
    }

    public static boolean getDefaultWorm(int type) {
        switch (type) {
            case 11: {
                return false;
            }
            case 1: 
            case 2: 
            case 9: 
            case 10: {
                return false;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    public static enum GUIDObjectEnumType {
        UNASSIGNED(0),
        UNIT(1),
        OBJECTGROUP(2),
        OBJECT(3),
        OPERATION_LOGBOOK(4),
        WRITE_LOGBOOK(5),
        MANIFEST(6),
        EVENT(7),
        REQUESTID(8),
        STORAGE_OPERATION(9),
        ACCESSION_REGISTER_SUMMARY(10),
        ACCESSION_REGISTER_DETAIL(14),
        CONTRACT(11),
        AGENCIES(15),
        ONTOLOGIES(16);

        final int id;

        private GUIDObjectEnumType(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }
    }
}

