/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.error;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.model.RequestResponse;
import jakarta.ws.rs.core.Response;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class VitamError<T>
extends RequestResponse<T> {
    @JsonProperty(value="code")
    private String code;
    @JsonProperty(value="context")
    private String context;
    @JsonProperty(value="state")
    private String state;
    @JsonProperty(value="message")
    private String message;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private List<VitamError<T>> errors;

    protected VitamError() {
    }

    public VitamError(String code) {
        this.code = code;
        this.errors = new ArrayList<VitamError<T>>();
    }

    public static <T> VitamError<T> newVitamError(Class<T> clasz) {
        return new VitamError<T>();
    }

    @JsonSetter(value="code")
    public VitamError<T> setCode(String code) {
        this.code = code;
        return this;
    }

    @Override
    public VitamError<T> setHttpCode(int httpCode) {
        super.setHttpCode(httpCode);
        return this;
    }

    @JsonSetter(value="context")
    public VitamError<T> setContext(String context) {
        ParametersChecker.checkParameter("context is a mandatory parameter", context);
        this.context = context;
        return this;
    }

    @JsonSetter(value="state")
    public VitamError<T> setState(String state) {
        ParametersChecker.checkParameter("state is a mandatory parameter", state);
        this.state = state;
        return this;
    }

    @JsonSetter(value="message")
    public VitamError<T> setMessage(String message) {
        ParametersChecker.checkParameter("message is a mandatory parameter", message);
        this.message = message;
        return this;
    }

    @JsonSetter(value="description")
    public VitamError<T> setDescription(String description) {
        ParametersChecker.checkParameter("description is a mandatory parameter", description);
        this.description = description;
        return this;
    }

    @JsonSetter(value="errors")
    public VitamError<T> addAllErrors(List<VitamError<T>> errors) {
        ParametersChecker.checkParameter("errors list is a mandatory parameter", errors);
        if (this.errors == null) {
            this.errors = errors;
        } else {
            this.errors.addAll(errors);
        }
        return this;
    }

    @JsonIgnore
    public VitamError<T> addToErrors(VitamError<T> error) {
        ParametersChecker.checkParameter("error is a mandatory parameter", error);
        if (this.errors == null) {
            this.errors = new ArrayList<VitamError<T>>();
        }
        this.errors.add(error);
        return this;
    }

    public String getCode() {
        return this.code;
    }

    @JsonGetter(value="context")
    public String getContext() {
        return this.context;
    }

    @JsonGetter(value="state")
    public String getState() {
        return this.state;
    }

    @JsonGetter(value="message")
    public String getMessage() {
        return this.message;
    }

    @JsonGetter(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonGetter(value="errors")
    public List<VitamError<T>> getErrors() {
        return this.errors;
    }

    public static <T> VitamError<T> getFromJsonNode(JsonNode node, Class<T> clasz) throws InvalidParseOperationException {
        return (VitamError)JsonHandler.getFromJsonNode(node, new TypeReference<VitamError<T>>(){});
    }

    public static VitamError<JsonNode> getFromJsonNode(JsonNode node) throws InvalidParseOperationException {
        return JsonHandler.getFromJsonNode(node, new TypeReference<VitamError<JsonNode>>(){});
    }

    @Override
    public Response toResponse() {
        Response.ResponseBuilder resp = Response.status((int)this.getStatus()).entity((Object)JsonHandler.unprettyPrint(this));
        Map<String, String> vitamHeaders = this.getVitamHeaders();
        for (String key : vitamHeaders.keySet()) {
            resp.header(key, (Object)this.getHeaderString(key));
        }
        this.unSetVitamHeaders();
        return resp.build();
    }

    public Response toStreamResponse() {
        InputStream entity;
        try {
            entity = JsonHandler.writeToInpustream(this);
        }
        catch (InvalidParseOperationException e) {
            entity = new ByteArrayInputStream("{ 'message' : 'Invalid VitamError message' }".getBytes());
        }
        Response.ResponseBuilder resp = Response.status((int)this.getStatus()).entity((Object)entity);
        Map<String, String> vitamHeaders = this.getVitamHeaders();
        for (String key : vitamHeaders.keySet()) {
            resp.header(key, (Object)this.getHeaderString(key));
        }
        this.unSetVitamHeaders();
        return resp.build();
    }
}

