/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.error;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.error.DomainName;
import fr.gouv.vitam.common.error.ServiceName;
import fr.gouv.vitam.common.error.VitamCode;
import fr.gouv.vitam.common.error.VitamError;
import java.util.ArrayList;
import java.util.List;

public class VitamCodeHelper {
    private static final String INVALID_ARGUMENT_TO_RETRIEVE_ERROR_MESSAGE = "Invalid argument to retrieve error message";
    private static final int START_SERVICE_INDEX = 0;
    private static final int END_SERVICE_START_DOMAIN_INDEX = 2;
    private static final int END_DOMAIN_START_ITEM_INDEX = 4;
    private static final int END_ITEM_INDEX = 6;
    private static final int VITAM_CODE_SIZE = 6;

    private VitamCodeHelper() {
    }

    public static boolean isAlphanumericCode(String code) {
        for (int i = 0; i < code.length(); ++i) {
            char c = code.charAt(i);
            if (c >= '0' && c <= '9' || c >= 'A' && c <= 'Z') continue;
            return false;
        }
        return true;
    }

    public static VitamCode getFrom(String code) {
        ParametersChecker.checkParameter("Code cannot be null or empty", code);
        if (code.length() != 6 || !VitamCodeHelper.isAlphanumericCode(code)) {
            throw new IllegalArgumentException("Code must have six characters alphanumerics");
        }
        ServiceName service = ServiceName.getFromCode(code.substring(0, 2));
        DomainName domain = DomainName.getFromCode(code.substring(2, 4));
        String item = code.substring(4, 6);
        return VitamCodeHelper.getFrom(service, domain, item);
    }

    public static VitamCode getFrom(ServiceName service, DomainName domain, String item) {
        for (VitamCode vitamCode : VitamCode.values()) {
            if (!vitamCode.getService().equals((Object)service) || !vitamCode.getDomain().equals((Object)domain) || !vitamCode.getItem().equals(item)) continue;
            return vitamCode;
        }
        throw new IllegalArgumentException("Cannot find VitamCode from {" + service.getCode() + domain.getCode() + item + "} code");
    }

    public static String getMessage(ServiceName service, DomainName domain, String item) {
        ParametersChecker.checkParameter(INVALID_ARGUMENT_TO_RETRIEVE_ERROR_MESSAGE, new Object[]{service, domain, item});
        return VitamCodeHelper.getFrom(service, domain, item).getMessage();
    }

    public static String getMessageFromVitamCode(VitamCode vitamCode) {
        ParametersChecker.checkParameter(INVALID_ARGUMENT_TO_RETRIEVE_ERROR_MESSAGE, new Object[]{vitamCode});
        return VitamCodeHelper.getMessage(vitamCode.getService(), vitamCode.getDomain(), vitamCode.getItem());
    }

    public static String getMessage(String vitamCode) {
        ParametersChecker.checkParameter(INVALID_ARGUMENT_TO_RETRIEVE_ERROR_MESSAGE, vitamCode);
        return VitamCodeHelper.getFrom(vitamCode).getMessage();
    }

    public static String getParametrizedMessageFromVitamCode(VitamCode vitamCode, Object ... params) {
        ParametersChecker.checkParameter(INVALID_ARGUMENT_TO_RETRIEVE_ERROR_MESSAGE, new Object[]{vitamCode, params});
        return String.format(vitamCode.getMessage(), params);
    }

    public static String getParametrizedMessageFromCode(String vitamCode, Object ... params) {
        ParametersChecker.checkParameter(INVALID_ARGUMENT_TO_RETRIEVE_ERROR_MESSAGE, vitamCode, params);
        return String.format(VitamCodeHelper.getMessage(vitamCode), params);
    }

    public static String getParametrizedMessage(ServiceName service, DomainName domain, String item, Object ... params) {
        ParametersChecker.checkParameter(INVALID_ARGUMENT_TO_RETRIEVE_ERROR_MESSAGE, new Object[]{service, domain, item});
        return String.format(VitamCodeHelper.getFrom(service, domain, item).getMessage(), params);
    }

    public static List<VitamCode> getFromDomain(DomainName domain) {
        ParametersChecker.checkParameter("Invalid argument to retrieve Vitam code", new Object[]{domain});
        ArrayList<VitamCode> codes = new ArrayList<VitamCode>();
        for (VitamCode vitamCode : VitamCode.values()) {
            if (!vitamCode.getDomain().equals((Object)domain)) continue;
            codes.add(vitamCode);
        }
        return codes;
    }

    public static List<VitamCode> getFromService(ServiceName service) {
        ParametersChecker.checkParameter("Invalid argument to retrieve Vitam code", new Object[]{service});
        ArrayList<VitamCode> codes = new ArrayList<VitamCode>();
        for (VitamCode vitamCode : VitamCode.values()) {
            if (!vitamCode.getService().equals((Object)service)) continue;
            codes.add(vitamCode);
        }
        return codes;
    }

    public static String getCode(VitamCode vitamCode) {
        return vitamCode.getService().getCode() + vitamCode.getDomain().getCode() + vitamCode.getItem();
    }

    public static String getLogMessage(VitamCode vitamCode, Object ... params) {
        ParametersChecker.checkParameter(INVALID_ARGUMENT_TO_RETRIEVE_ERROR_MESSAGE, new Object[]{vitamCode});
        return String.format("[%s] %s", VitamCodeHelper.getCode(vitamCode), VitamCodeHelper.getParametrizedMessageFromVitamCode(vitamCode, params));
    }

    public static VitamError<JsonNode> toVitamError(VitamCode vitamCode, String description) {
        return VitamCodeHelper.toVitamError(vitamCode, description, JsonNode.class);
    }

    public static <T> VitamError<T> toVitamError(VitamCode vitamCode, String description, Class<T> clasz) {
        return ((VitamError)new VitamError(VitamCodeHelper.getCode(vitamCode)).setContext(vitamCode.getService().getName()).setState(vitamCode.getDomain().getName()).setHttpCode(vitamCode.getStatus().getStatusCode())).setMessage(vitamCode.getMessage()).setDescription(description != null && !description.isEmpty() ? description : vitamCode.getMessage());
    }
}

