/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.error;

import fr.gouv.vitam.common.ParametersChecker;

public enum ServiceName {
    VITAM("00", "Vitam"),
    INTERNAL_ACCESS("01", "Internal Access"),
    EXTERNAL_ACCESS("02", "External Access"),
    INTERNAL_INGEST("03", "Internal Ingest"),
    EXTERNAL_INGEST("04", "External Ingest"),
    LOGBOOK("05", "Logbook"),
    METADATA("06", "Metadata"),
    PROCESSING("07", "Processing"),
    DISTRIBUTOR("08", "Distributor"),
    WORKER("09", "Worker"),
    STORAGE("10", "Storage"),
    WORKSPACE("11", "Workspace"),
    FUNCTIONAL_ADMINISTRATION("12", "Functional_Administration"),
    COLLECT_EXTERNAL_ACCESS("13", "Collect External Access");

    private final String code;
    private final String name;

    private ServiceName(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public String getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public static ServiceName getFromCode(String code) {
        ParametersChecker.checkParameter("code is required", code);
        for (ServiceName service : ServiceName.values()) {
            if (!service.getCode().equals(code)) continue;
            return service;
        }
        throw new IllegalArgumentException("Code {" + code + "} does not exist");
    }
}

