/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.digest;

import fr.gouv.vitam.common.digest.DigestTypeException;

public enum DigestType {
    MD5("MD5"),
    SHA1("SHA-1"),
    SHA256("SHA-256"),
    SHA384("SHA-384"),
    SHA512("SHA-512");

    private String name;

    private DigestType(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static DigestType fromValue(String v) {
        for (DigestType c : DigestType.values()) {
            if (!c.name.equals(v)) continue;
            return c;
        }
        throw new DigestTypeException("Unknown DigestType : " + v);
    }
}

