/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.digest;

import fr.gouv.vitam.common.BaseXx;
import fr.gouv.vitam.common.CharsetUtils;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.digest.DigestType;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.security.DigestInputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class Digest {
    private static final String IGNORE = "Ignore";
    private static final String ARGUMENT_MUST_NOT_BE_NULL = "Argument must not be null";
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(Digest.class);
    private static final int BUFFER_SIZE = 8192;
    MessageDigest messageDigest;
    DigestType type;
    volatile byte[] finalized = null;
    private byte[] reusableBytes = null;

    public Digest(DigestType algo) {
        ParametersChecker.checkParameter(ARGUMENT_MUST_NOT_BE_NULL, new Object[]{algo});
        try {
            this.messageDigest = MessageDigest.getInstance(algo.getName());
            this.type = algo;
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("Algo unknown", e);
        }
    }

    public Digest(String digest, DigestType algo) {
        this(algo);
        ParametersChecker.checkParameter(ARGUMENT_MUST_NOT_BE_NULL, digest);
        this.finalized = BaseXx.getFromBase16(digest);
    }

    public final DigestType type() {
        return this.type;
    }

    public final Digest update(byte[] bytes) {
        ParametersChecker.checkParameter(ARGUMENT_MUST_NOT_BE_NULL, new Object[]{bytes});
        return this.update(bytes, 0, bytes.length);
    }

    public final Digest update(byte[] bytes, int offset, int length) {
        ParametersChecker.checkParameter(ARGUMENT_MUST_NOT_BE_NULL, new Object[]{bytes});
        ParametersChecker.checkValue("offset", offset, 0L);
        ParametersChecker.checkValue("length", length, 0L);
        if (offset + length > bytes.length) {
            throw new IllegalArgumentException("Range is incorrect: " + offset + ":" + length + " while length is " + bytes.length);
        }
        if (length == 0) {
            return this;
        }
        this.finalized = null;
        this.messageDigest.update(bytes, offset, length);
        return this;
    }

    public final Digest update(ByteBuffer buffer) {
        byte[] newbuf;
        ParametersChecker.checkParameter(ARGUMENT_MUST_NOT_BE_NULL, buffer);
        int length = buffer.remaining();
        if (length == 0) {
            return this;
        }
        int start = 0;
        if (buffer.hasArray()) {
            start = buffer.arrayOffset();
            newbuf = buffer.array();
        } else {
            newbuf = new byte[length];
            buffer.get(newbuf);
        }
        return this.update(newbuf, start, length);
    }

    public final Digest update(String value) {
        ParametersChecker.checkParameter(ARGUMENT_MUST_NOT_BE_NULL, value);
        return this.update(value.getBytes(CharsetUtils.UTF8));
    }

    public final Digest update(File in) throws IOException {
        return this.update(in, 0L, -1L);
    }

    public final Digest update(File in, long start, long limit) throws IOException {
        ParametersChecker.checkParameter(ARGUMENT_MUST_NOT_BE_NULL, in);
        if (!in.isFile()) {
            throw new IllegalArgumentException("File not found");
        }
        ParametersChecker.checkValue("start", start, 0L);
        if (limit == 0L) {
            return this;
        }
        try (FileInputStream inputStream = new FileInputStream(in);){
            Digest digest;
            block13: {
                FileChannel fcin = inputStream.getChannel();
                try {
                    digest = this.update(fcin, start, 8192, limit);
                    if (fcin == null) break block13;
                }
                catch (Throwable throwable) {
                    if (fcin != null) {
                        try {
                            fcin.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                fcin.close();
            }
            return digest;
        }
    }

    public final Digest update(InputStream inputStream) throws IOException {
        return this.update(inputStream, 8192, -1L);
    }

    public final Digest update(InputStream inputStream, int chunkSize) throws IOException {
        return this.update(inputStream, chunkSize, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Digest update(InputStream inputStream, int chunkSize, long limit) throws IOException {
        ParametersChecker.checkParameter(ARGUMENT_MUST_NOT_BE_NULL, inputStream);
        ParametersChecker.checkValue("chunkSize", chunkSize, 1L);
        if (limit == 0L) {
            return this;
        }
        this.finalized = null;
        byte[] buf = this.setReusableByte(chunkSize);
        try {
            int size;
            while ((size = inputStream.read(buf)) >= 0) {
                this.messageDigest.update(buf, 0, size);
            }
            Digest digest = this;
            return digest;
        }
        finally {
            try {
                inputStream.close();
            }
            catch (Exception e) {
                LOGGER.debug(IGNORE, e);
            }
        }
    }

    public final Digest update(FileChannel fileChannelInputStream) throws IOException {
        return this.update(fileChannelInputStream, 0L, 8192, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Digest update(FileChannel fileChannelInputStream, long start, int chunkSize, long limit) throws IOException {
        ParametersChecker.checkParameter(ARGUMENT_MUST_NOT_BE_NULL, fileChannelInputStream);
        ParametersChecker.checkValue("chunkSize", chunkSize, 1L);
        ParametersChecker.checkValue("start", start, 0L);
        if (limit == 0L) {
            return this;
        }
        this.finalized = null;
        byte[] buf = this.setReusableByte(chunkSize);
        try {
            int size;
            ByteBuffer bb = ByteBuffer.wrap(buf);
            if (start > 0L) {
                fileChannelInputStream.position(start);
            }
            while ((size = fileChannelInputStream.read(bb)) >= 0) {
                this.messageDigest.update(buf, 0, size);
                bb.clear();
            }
            Digest digest = this;
            return digest;
        }
        finally {
            try {
                fileChannelInputStream.close();
            }
            catch (Exception e) {
                LOGGER.debug(IGNORE, e);
            }
        }
    }

    public InputStream getDigestInputStream(InputStream inputStream) {
        return new DigestInputStream(inputStream, this.messageDigest);
    }

    public OutputStream getDigestOutputStream(OutputStream outputStream) {
        return new DigestOutputStream(outputStream, this.messageDigest);
    }

    public final Digest reset() {
        this.messageDigest.reset();
        this.finalized = null;
        return this;
    }

    public final byte[] digest() {
        if (this.finalized == null) {
            try {
                MessageDigest dclone = (MessageDigest)this.messageDigest.clone();
                this.finalized = dclone.digest();
            }
            catch (CloneNotSupportedException e) {
                LOGGER.debug(IGNORE, e);
                this.finalized = this.messageDigest.digest();
            }
        }
        return this.finalized;
    }

    public final String digestHex() {
        if (this.finalized == null) {
            try {
                MessageDigest dclone = (MessageDigest)this.messageDigest.clone();
                this.finalized = dclone.digest();
            }
            catch (CloneNotSupportedException e) {
                LOGGER.debug(IGNORE, e);
                this.finalized = this.messageDigest.digest();
            }
        }
        return BaseXx.getBase16(this.finalized);
    }

    public final String digest64() {
        return BaseXx.getBase64(this.digest());
    }

    public final String toString() {
        return this.digestHex();
    }

    public final boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof Digest) {
            Digest digest = (Digest)obj;
            return digest.type == this.type && MessageDigest.isEqual(this.digest(), digest.digest());
        }
        if (obj instanceof String) {
            return ((String)obj).equalsIgnoreCase(this.digestHex());
        }
        if (obj instanceof byte[]) {
            return MessageDigest.isEqual(this.digest(), (byte[])obj);
        }
        return false;
    }

    public final int hashCode() {
        return this.digestHex().hashCode();
    }

    public final boolean equalsWithType(String digest, DigestType algo) {
        if (digest == null || algo == null) {
            return false;
        }
        return algo == this.type && digest.equalsIgnoreCase(this.digestHex());
    }

    public final boolean equalsWithType(byte[] digest, DigestType algo) {
        if (digest == null || algo == null) {
            return false;
        }
        return algo == this.type && MessageDigest.isEqual(this.digest(), digest);
    }

    private byte[] setReusableByte(int length) {
        if (this.reusableBytes == null || this.reusableBytes.length != length) {
            this.reusableBytes = new byte[length];
        }
        return this.reusableBytes;
    }

    public static Digest digest(InputStream in, DigestType algo) throws IOException {
        return new Digest(algo).update(in);
    }

    public static Digest digest(File in, DigestType algo) throws IOException {
        return new Digest(algo).update(in);
    }
}

