/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.client;

import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import jakarta.annotation.Nullable;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class VitamRequestBuilder {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(VitamRequestBuilder.class);
    private static final Runnable NOOP = () -> {};
    private final String httpMethod;
    private String path;
    private String baseUrl;
    private MediaType contentType;
    private MediaType accept;
    private Object body;
    private MultivaluedMap<String, Object> headers;
    private Map<String, String> queryParams;
    private Runnable beforeExecRequest = NOOP;
    private boolean chunckedMode = false;

    private VitamRequestBuilder(String httpMethod) {
        this.httpMethod = httpMethod;
    }

    public static VitamRequestBuilder get() {
        return new VitamRequestBuilder("GET");
    }

    public static VitamRequestBuilder post() {
        return new VitamRequestBuilder("POST");
    }

    public static VitamRequestBuilder put() {
        return new VitamRequestBuilder("PUT");
    }

    public static VitamRequestBuilder delete() {
        return new VitamRequestBuilder("DELETE");
    }

    public static VitamRequestBuilder head() {
        return new VitamRequestBuilder("HEAD");
    }

    public static VitamRequestBuilder options() {
        return new VitamRequestBuilder("OPTIONS");
    }

    public void runBeforeExecRequest() {
        this.beforeExecRequest.run();
    }

    public VitamRequestBuilder withBaseUrl(String url) {
        this.baseUrl = Objects.requireNonNull(url);
        return this;
    }

    public VitamRequestBuilder withNoBaseUrl() {
        this.baseUrl = null;
        return this;
    }

    public VitamRequestBuilder withJson() {
        this.contentType = MediaType.APPLICATION_JSON_TYPE;
        this.accept = MediaType.APPLICATION_JSON_TYPE;
        return this;
    }

    public VitamRequestBuilder withOctet() {
        this.contentType = MediaType.APPLICATION_OCTET_STREAM_TYPE;
        this.accept = MediaType.APPLICATION_OCTET_STREAM_TYPE;
        return this;
    }

    public VitamRequestBuilder withJsonOctet() {
        this.contentType = MediaType.APPLICATION_JSON_TYPE;
        this.accept = MediaType.APPLICATION_OCTET_STREAM_TYPE;
        return this;
    }

    public VitamRequestBuilder withJsonContentType() {
        this.contentType = MediaType.APPLICATION_JSON_TYPE;
        return this;
    }

    public VitamRequestBuilder withXMLContentType() {
        this.contentType = MediaType.APPLICATION_XML_TYPE;
        return this;
    }

    public VitamRequestBuilder withContentType(MediaType contentType) {
        this.contentType = Objects.requireNonNull(contentType, "cannot set a null ContentType");
        return this;
    }

    public VitamRequestBuilder withOctetContentType() {
        this.contentType = MediaType.APPLICATION_OCTET_STREAM_TYPE;
        return this;
    }

    public VitamRequestBuilder withNoContentType() {
        this.contentType = null;
        return this;
    }

    public VitamRequestBuilder withJsonAccept() {
        this.accept = MediaType.APPLICATION_JSON_TYPE;
        return this;
    }

    public VitamRequestBuilder withOctetAccept() {
        this.accept = MediaType.APPLICATION_OCTET_STREAM_TYPE;
        return this;
    }

    public VitamRequestBuilder withXMLAccept() {
        this.accept = MediaType.APPLICATION_XML_TYPE;
        return this;
    }

    public VitamRequestBuilder withAccept(MediaType accept) {
        this.accept = Objects.requireNonNull(accept);
        return this;
    }

    public VitamRequestBuilder withBody(Object body, String failCheckBodyMessage) {
        if (Objects.isNull(body)) {
            throw new IllegalArgumentException(failCheckBodyMessage);
        }
        this.body = body;
        return this;
    }

    public VitamRequestBuilder withBody(Object body) {
        this.body = Objects.requireNonNull(body, "Body cannot be null.");
        return this;
    }

    public VitamRequestBuilder withBefore(Runnable beforeExecRequest) {
        this.beforeExecRequest = Objects.requireNonNull(beforeExecRequest);
        return this;
    }

    public VitamRequestBuilder withHeaders(MultivaluedMap<String, Object> headers) {
        this.headers = Objects.requireNonNull(headers);
        return this;
    }

    public VitamRequestBuilder withOptionalHeader(String key, @Nullable Object value) {
        if (Objects.isNull(value)) {
            return this;
        }
        return this.withHeader(key, value);
    }

    public VitamRequestBuilder withHeader(String key, Object value) {
        if (this.headers == null) {
            this.headers = new MultivaluedHashMap();
        }
        this.headers.add((Object)Objects.requireNonNull(key), Objects.requireNonNull(value));
        return this;
    }

    public VitamRequestBuilder withHeaderReplaceExisting(String key, Object value) {
        if (value == null) {
            return this;
        }
        if (this.headers == null) {
            this.headers = new MultivaluedHashMap();
        }
        this.headers.putSingle((Object)Objects.requireNonNull(key), value);
        return this;
    }

    public VitamRequestBuilder withHeaderIgnoreNull(String key, Object value) {
        if (value == null) {
            return this;
        }
        if (this.headers == null) {
            this.headers = new MultivaluedHashMap();
        }
        this.headers.add((Object)Objects.requireNonNull(key), value);
        return this;
    }

    public VitamRequestBuilder withPath(String path) {
        this.path = Objects.requireNonNull(path);
        return this;
    }

    public VitamRequestBuilder withQueryParams(Map<String, String> queryParams) {
        if (!"GET".equals(this.httpMethod)) {
            throw new IllegalArgumentException(String.format("Cannot use query params with something different that 'GET', here '%s'.", this.httpMethod));
        }
        this.queryParams = Objects.requireNonNull(queryParams);
        return this;
    }

    public VitamRequestBuilder withQueryParam(String key, String value) {
        if (!"GET".equals(this.httpMethod)) {
            throw new IllegalArgumentException(String.format("Cannot use query params with something different that 'GET', here '%s'.", this.httpMethod));
        }
        if (this.queryParams == null) {
            this.queryParams = new HashMap<String, String>();
        }
        this.queryParams.put(Objects.requireNonNull(key), Objects.requireNonNull(value));
        return this;
    }

    public VitamRequestBuilder withChunckedMode(boolean chunckedMode) {
        this.chunckedMode = chunckedMode;
        return this;
    }

    public Map<String, String> getQueryParams() {
        if (Objects.isNull(this.queryParams)) {
            return Collections.emptyMap();
        }
        return this.queryParams;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public MediaType getContentType() {
        return this.contentType;
    }

    public MediaType getAccept() {
        return this.accept;
    }

    public Object getBody() {
        return this.body;
    }

    public MultivaluedMap<String, Object> getHeaders() {
        if (Objects.isNull(this.headers)) {
            return new MultivaluedHashMap(Collections.emptyMap());
        }
        return this.headers;
    }

    public String getPath() {
        return this.path;
    }

    public boolean isChunckedMode() {
        return this.chunckedMode;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }
}

