/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common;

import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.StringUtils;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.logging.SysErrLogger;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Properties;

public final class SystemPropertyUtil {
    private static final String USING_THE_DEFAULT_VALUE = "using the default value: ";
    public static final String FILE_ENCODING = "file.encoding";
    private static final Properties PROPS = new Properties();
    private static final String INVALID_PROPERTY = "Invalid property ";
    private static Platform m_os = null;

    private SystemPropertyUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refresh() {
        Properties newProps = new Properties();
        try {
            newProps = System.getProperties();
        }
        catch (SecurityException e) {
            SysErrLogger.FAKE_LOGGER.ignoreLog(e);
            SysErrLogger.FAKE_LOGGER.syserr("Unable to retrieve the system properties; default values will be used: " + e.getMessage());
        }
        Properties e = PROPS;
        synchronized (e) {
            PROPS.clear();
            PROPS.putAll((Map<?, ?>)newProps);
        }
        if (!SystemPropertyUtil.contains(FILE_ENCODING) || !"UTF-8".equalsIgnoreCase(SystemPropertyUtil.get(FILE_ENCODING))) {
            try {
                System.setProperty(FILE_ENCODING, "UTF-8");
                Field charset = Charset.class.getDeclaredField("defaultCharset");
                charset.setAccessible(true);
                charset.set(null, null);
                Properties properties = PROPS;
                synchronized (properties) {
                    PROPS.clear();
                    PROPS.putAll((Map<?, ?>)newProps);
                }
            }
            catch (Exception e1) {
                SysErrLogger.FAKE_LOGGER.ignoreLog(e1);
                SysErrLogger.FAKE_LOGGER.syserr("Issue while trying to set UTF-8 as default file encoding: use -Dfile.encoding=UTF-8 as java command argument: " + e1.getMessage());
                SysErrLogger.FAKE_LOGGER.syserr("Currently file.encoding is: " + SystemPropertyUtil.get(FILE_ENCODING));
            }
        }
    }

    public static boolean contains(String key) {
        ParametersChecker.checkParameter("Key", key);
        return PROPS.containsKey(key);
    }

    public static String get(String key) {
        return SystemPropertyUtil.get(key, null);
    }

    public static String getNoCheck(String key) {
        ParametersChecker.checkParameter("Key", key);
        return PROPS.getProperty(key);
    }

    public static String get(String key, String def) {
        ParametersChecker.checkParameter("Key", key);
        String value = PROPS.getProperty(key);
        if (value == null) {
            return def;
        }
        try {
            value = StringUtils.checkSanityString(value);
        }
        catch (InvalidParseOperationException e) {
            SysErrLogger.FAKE_LOGGER.syserr(INVALID_PROPERTY + key, e);
            return def;
        }
        return value;
    }

    public static boolean get(String key, boolean def) {
        ParametersChecker.checkParameter("Key", key);
        String value = PROPS.getProperty(key);
        if (value == null) {
            return def;
        }
        if ((value = value.trim().toLowerCase()).isEmpty()) {
            return true;
        }
        if ("true".equals(value) || "yes".equals(value) || "1".equals(value)) {
            return true;
        }
        if ("false".equals(value) || "no".equals(value) || "0".equals(value)) {
            return false;
        }
        try {
            StringUtils.checkSanityString(value);
        }
        catch (InvalidParseOperationException e) {
            SysErrLogger.FAKE_LOGGER.syserr(INVALID_PROPERTY + key, e);
            return def;
        }
        SysErrLogger.FAKE_LOGGER.syserr("Unable to parse the boolean system property '" + key + "':" + value + " - using the default value: " + def);
        return def;
    }

    public static int get(String key, int def) {
        ParametersChecker.checkParameter("Key", key);
        String value = PROPS.getProperty(key);
        if (value == null) {
            return def;
        }
        if ((value = value.trim().toLowerCase()).matches("-?[0-9]+")) {
            try {
                return Integer.parseInt(value);
            }
            catch (Exception e) {
                SysErrLogger.FAKE_LOGGER.ignoreLog(e);
            }
        }
        try {
            StringUtils.checkSanityString(value);
        }
        catch (InvalidParseOperationException e) {
            SysErrLogger.FAKE_LOGGER.syserr(INVALID_PROPERTY + key, e);
            return def;
        }
        SysErrLogger.FAKE_LOGGER.syserr("Unable to parse the integer system property '" + key + "':" + value + " - using the default value: " + def);
        return def;
    }

    public static long get(String key, long def) {
        ParametersChecker.checkParameter("Key", key);
        String value = PROPS.getProperty(key);
        if (value == null) {
            return def;
        }
        if ((value = value.trim().toLowerCase()).matches("-?[0-9]+")) {
            try {
                return Long.parseLong(value);
            }
            catch (Exception e) {
                SysErrLogger.FAKE_LOGGER.ignoreLog(e);
            }
        }
        try {
            StringUtils.checkSanityString(value);
        }
        catch (InvalidParseOperationException e) {
            SysErrLogger.FAKE_LOGGER.syserr(INVALID_PROPERTY + key, e);
            return def;
        }
        SysErrLogger.FAKE_LOGGER.syserr("Unable to parse the long integer system property '" + key + "':" + value + " - using the default value: " + def);
        return def;
    }

    public static String getAndSet(String key, String def) {
        ParametersChecker.checkParameter("Key", key);
        if (def == null) {
            throw new IllegalArgumentException("Def cannot be null");
        }
        if (!PROPS.containsKey(key)) {
            System.setProperty(key, def);
            SystemPropertyUtil.refresh();
            return def;
        }
        return PROPS.getProperty(key);
    }

    public static boolean getAndSet(String key, boolean def) {
        ParametersChecker.checkParameter("Key", key);
        if (!PROPS.containsKey(key)) {
            System.setProperty(key, Boolean.toString(def));
            SystemPropertyUtil.refresh();
            return def;
        }
        return SystemPropertyUtil.get(key, def);
    }

    public static int getAndSet(String key, int def) {
        ParametersChecker.checkParameter("Key", key);
        if (!PROPS.containsKey(key)) {
            System.setProperty(key, Integer.toString(def));
            SystemPropertyUtil.refresh();
            return def;
        }
        return SystemPropertyUtil.get(key, def);
    }

    public static long getAndSet(String key, long def) {
        ParametersChecker.checkParameter("Key", key);
        if (!PROPS.containsKey(key)) {
            System.setProperty(key, Long.toString(def));
            SystemPropertyUtil.refresh();
            return def;
        }
        return SystemPropertyUtil.get(key, def);
    }

    public static String set(String key, String def) {
        ParametersChecker.checkParameter("Key", key);
        if (def == null) {
            throw new IllegalArgumentException("Def cannot be null");
        }
        String old = null;
        if (PROPS.containsKey(key)) {
            old = PROPS.getProperty(key);
        }
        System.setProperty(key, def);
        SystemPropertyUtil.refresh();
        return old;
    }

    public static boolean set(String key, boolean def) {
        ParametersChecker.checkParameter("Key", key);
        boolean old = false;
        if (PROPS.containsKey(key)) {
            old = SystemPropertyUtil.get(key, def);
        }
        System.setProperty(key, Boolean.toString(def));
        SystemPropertyUtil.refresh();
        return old;
    }

    public static int set(String key, int def) {
        ParametersChecker.checkParameter("Key", key);
        int old = 0;
        if (PROPS.containsKey(key)) {
            old = SystemPropertyUtil.get(key, def);
        }
        System.setProperty(key, Integer.toString(def));
        SystemPropertyUtil.refresh();
        return old;
    }

    public static long set(String key, long def) {
        ParametersChecker.checkParameter("Key", key);
        long old = 0L;
        if (PROPS.containsKey(key)) {
            old = SystemPropertyUtil.get(key, def);
        }
        System.setProperty(key, Long.toString(def));
        SystemPropertyUtil.refresh();
        return old;
    }

    public static void clear(String key) {
        ParametersChecker.checkParameter("Key", key);
        PROPS.remove(key);
        System.clearProperty(key);
        SystemPropertyUtil.refresh();
    }

    public static void debug(PrintStream out) {
        ParametersChecker.checkParameter("Out", out);
        PROPS.list(out);
    }

    public static Platform getOS() {
        if (m_os == null) {
            m_os = Platform.UNSUPPORTED;
            String os = "";
            try {
                os = System.getProperty("os.name").toLowerCase();
            }
            catch (Exception e) {
                SysErrLogger.FAKE_LOGGER.ignoreLog(e);
            }
            if (os.contains("win")) {
                m_os = Platform.WINDOWS;
            } else if (os.contains("mac")) {
                m_os = Platform.MAC;
            } else if (os.contains("nux")) {
                m_os = Platform.UNIX;
            } else if (os.contains("nix")) {
                m_os = Platform.UNIX;
            } else if (os.contains("sunos")) {
                m_os = Platform.SOLARIS;
            }
        }
        return m_os;
    }

    public static boolean isWindows() {
        return SystemPropertyUtil.getOS() == Platform.WINDOWS;
    }

    public static boolean isMac() {
        return SystemPropertyUtil.getOS() == Platform.MAC;
    }

    public static boolean isUnix() {
        return SystemPropertyUtil.getOS() == Platform.UNIX;
    }

    public static boolean isSolaris() {
        return SystemPropertyUtil.getOS() == Platform.SOLARIS;
    }

    static {
        SystemPropertyUtil.refresh();
        VitamConfiguration.checkVitamConfiguration();
    }

    public static enum Platform {
        WINDOWS,
        MAC,
        UNIX,
        SOLARIS,
        UNSUPPORTED;

    }
}

