/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common;

import com.fasterxml.jackson.annotation.JsonIgnore;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.PropertiesUtils;
import fr.gouv.vitam.common.ServerIdentityConfiguration;
import fr.gouv.vitam.common.ServerIdentityInterface;
import fr.gouv.vitam.common.StringUtils;
import fr.gouv.vitam.common.SystemPropertyUtil;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.SysErrLogger;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Scanner;
import java.util.regex.Pattern;

public final class ServerIdentity
implements ServerIdentityInterface {
    private static final int MAC_ADDRESS_SUBSTRACT_LENGTH = 4;
    private static final String SERVER_IDENTITY_CONF_FILE_NAME = "server-identity.conf";
    private static final int OTHER_ADDRESS = 4;
    private static final int SITE_LOCAL_ADDRESS = 3;
    private static final int LINKLOCAL_ADDRESS = 2;
    private static final int MULTICAST_ADDRESS = 1;
    private static final int LOCAL_ADDRESS = 0;
    private static final String UNKNOWN_ROLE = "UnknownRole";
    private static final String UNKNOWN_HOSTNAME = "UnknownHostname";
    private static final String HOSTNAME_CMD = "hostname";
    private static final String HOSTNAME = "HOSTNAME";
    private static final String COMPUTERNAME = "COMPUTERNAME";
    private static final String WIN = "win";
    private static final String OS_NAME = "os.name";
    private static final Pattern MACHINE_ID_PATTERN = Pattern.compile("^(?:[0-9a-fA-F][:-]?){4,8}$");
    private static final int MACHINE_ID_LEN = 4;
    private static final int BYTE_LENGTH = 8;
    private static final int MAC_SIZE = 3;
    private static final int MACHINE_VALUE_PAIR = 2;
    private static final int HEXA_BASE = 16;
    private static final int MINIMAL_ADDRESS_LENGTH = 6;
    private static final int MULTICAST_VALUE = 1;
    private static final int GLOBAL_ADDRESS_VALUE = 1;
    private static final ServerIdentity SERVER_IDENTITY = new ServerIdentity();
    private String name;
    private String role;
    private int serverId;
    private int siteId;
    private final StringBuilder preMessage = new StringBuilder();
    private String preMessageString;
    private int globalPlatformId;

    private ServerIdentity() {
        this.defaultServerIdentity();
        try {
            File file = PropertiesUtils.findFile(SERVER_IDENTITY_CONF_FILE_NAME);
            ServerIdentityConfigurationImpl serverIdentityConf = PropertiesUtils.readYaml(file, ServerIdentityConfigurationImpl.class);
            this.setYamlConfiguration(serverIdentityConf);
            this.initializeCommentFormat();
        }
        catch (IOException e) {
            SysErrLogger.FAKE_LOGGER.syserr("Issue while getting configuration File: " + e.getMessage());
            SysErrLogger.FAKE_LOGGER.ignoreLog(e);
        }
    }

    void defaultServerIdentity() {
        boolean found = false;
        try {
            if (SystemPropertyUtil.get(OS_NAME).toLowerCase().startsWith(WIN)) {
                this.name = System.getenv(COMPUTERNAME);
                found = true;
            }
        }
        catch (Exception e) {
            SysErrLogger.FAKE_LOGGER.ignoreLog(e);
        }
        if (!found) {
            try {
                this.name = System.getenv(HOSTNAME);
                found = true;
            }
            catch (SecurityException e) {
                SysErrLogger.FAKE_LOGGER.ignoreLog(e);
            }
            if (!found || this.name == null) {
                this.executeHostnameCommand();
                if (this.name == null) {
                    this.getHostnameThroughInetAddress();
                }
            }
        }
        this.name = this.name.replaceAll("[\n\r]", "");
        this.role = UNKNOWN_ROLE;
        this.setServerId(ServerIdentity.macAddress(ServerIdentity.macAddress()));
        this.setSiteId(0);
        this.initializeCommentFormat();
    }

    private void getHostnameThroughInetAddress() {
        try {
            this.name = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            this.name = UNKNOWN_HOSTNAME;
            SysErrLogger.FAKE_LOGGER.ignoreLog(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeHostnameCommand() {
        Process proc = null;
        try {
            proc = Runtime.getRuntime().exec(HOSTNAME_CMD);
            try (InputStream stream = proc.getInputStream();
                 Scanner scanner = new Scanner(stream);){
                this.name = scanner.useDelimiter("\\A").hasNext() ? scanner.next() : "";
            }
        }
        catch (IOException e) {
            SysErrLogger.FAKE_LOGGER.ignoreLog(e);
        }
        finally {
            if (proc != null) {
                proc.destroy();
            }
        }
    }

    private void initializeCommentFormat() {
        this.preMessage.setLength(0);
        this.preMessage.append('[').append(this.getName()).append(':').append(this.getRole()).append(':').append(this.getGlobalPlatformId()).append("] ");
        this.preMessageString = this.preMessage.toString();
    }

    @Override
    @JsonIgnore
    public final String getLoggerMessagePrepend() {
        return this.preMessageString;
    }

    @JsonIgnore
    public final String getJsonIdentity() {
        return JsonHandler.unprettyPrint(this);
    }

    public static final ServerIdentity getInstance() {
        return SERVER_IDENTITY;
    }

    @JsonIgnore
    public final ServerIdentity setFromPropertyFile(File propertiesFile) throws FileNotFoundException {
        try {
            Properties properties = PropertiesUtils.readProperties(propertiesFile);
            String svalue = properties.getProperty(MAP_KEYNAME.NAME.name());
            if (svalue != null) {
                this.name = svalue;
            }
            if ((svalue = properties.getProperty(MAP_KEYNAME.ROLE.name())) != null) {
                this.role = svalue;
            }
            if ((svalue = properties.getProperty(MAP_KEYNAME.SERVERID.name())) != null) {
                this.setServerId(Integer.parseInt(svalue));
            }
            if ((svalue = properties.getProperty(MAP_KEYNAME.SITEID.name())) != null) {
                this.setSiteId(Integer.parseInt(svalue));
            }
        }
        catch (IOException | NumberFormatException e) {
            SysErrLogger.FAKE_LOGGER.ignoreLog(e);
        }
        this.initializeCommentFormat();
        return this;
    }

    @JsonIgnore
    public final ServerIdentity setFromYamlFile(File yamlFile) throws FileNotFoundException {
        try {
            ServerIdentityConfigurationImpl serverIdentityConf = PropertiesUtils.readYaml(yamlFile, ServerIdentityConfigurationImpl.class);
            this.setYamlConfiguration(serverIdentityConf);
        }
        catch (IOException e) {
            SysErrLogger.FAKE_LOGGER.ignoreLog(e);
        }
        this.initializeCommentFormat();
        return this;
    }

    private final void setYamlConfiguration(ServerIdentityConfigurationImpl serverIdentityConf) {
        this.name = serverIdentityConf.getIdentityName();
        this.role = serverIdentityConf.getIdentityRole();
        if (serverIdentityConf.getIdentityServerId() > 0) {
            this.setServerId(serverIdentityConf.getIdentityServerId());
        }
        if (serverIdentityConf.getIdentitySiteId() > 0) {
            this.setSiteId(serverIdentityConf.getIdentitySiteId());
        }
    }

    private final String getStringFromMap(Map<String, Object> map, String key) {
        String svalue;
        Object value = map.get(key);
        if (value != null && value instanceof String && !(svalue = ((String)value).trim()).isEmpty()) {
            return svalue;
        }
        return null;
    }

    private final Integer getIntegerFromMap(Map<String, Object> map, String key) {
        Object value = map.get(key);
        if (value != null) {
            if (value instanceof String) {
                String svalue = ((String)value).trim();
                if (!svalue.isEmpty()) {
                    try {
                        return Integer.parseInt(svalue);
                    }
                    catch (NumberFormatException e) {
                        return null;
                    }
                }
            } else if (value instanceof Number) {
                return ((Number)value).intValue();
            }
        }
        return null;
    }

    @JsonIgnore
    public final ServerIdentity setFromMap(Map<String, Object> map) {
        Integer sId;
        Integer pid;
        ParametersChecker.checkParameter("map", map);
        String svalue = this.getStringFromMap(map, MAP_KEYNAME.NAME.name());
        if (svalue != null) {
            this.name = svalue;
        }
        if ((svalue = this.getStringFromMap(map, MAP_KEYNAME.ROLE.name())) != null) {
            this.role = svalue;
        }
        if ((pid = this.getIntegerFromMap(map, MAP_KEYNAME.SERVERID.name())) != null) {
            this.setServerId(pid);
        }
        if ((sId = this.getIntegerFromMap(map, MAP_KEYNAME.SITEID.name())) != null) {
            this.setSiteId(sId);
        }
        this.initializeCommentFormat();
        return this;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    public final ServerIdentity setName(String name) {
        ParametersChecker.checkParameter("Name", name);
        this.name = name;
        this.initializeCommentFormat();
        return this;
    }

    @Override
    public final String getRole() {
        return this.role;
    }

    public final ServerIdentity setRole(String role) {
        ParametersChecker.checkParameter("Role", role);
        this.role = role;
        this.initializeCommentFormat();
        return this;
    }

    private final void calculateGlobalPlatformId() {
        this.globalPlatformId = ((this.siteId & 0xF) << 27) + (this.serverId & 0x7FFFFFF);
    }

    @Override
    public final int getGlobalPlatformId() {
        return this.globalPlatformId;
    }

    public final ServerIdentity setServerId(int serverId) {
        ParametersChecker.checkValue("server", serverId, 0L);
        this.serverId = serverId;
        this.calculateGlobalPlatformId();
        this.initializeCommentFormat();
        return this;
    }

    @Override
    public final int getServerId() {
        return this.serverId;
    }

    @Override
    public final int getSiteId() {
        return this.siteId;
    }

    public final ServerIdentity setSiteId(int siteId) {
        ParametersChecker.checkValue("siteID", siteId, 0L);
        this.siteId = siteId;
        this.calculateGlobalPlatformId();
        this.initializeCommentFormat();
        return this;
    }

    private static final byte[] macAddress() {
        try {
            byte[] machineId = null;
            String customMachineId = SystemPropertyUtil.get("fr.gouv.vitam.machineId");
            if (customMachineId != null && MACHINE_ID_PATTERN.matcher(customMachineId).matches()) {
                machineId = ServerIdentity.parseMachineId(customMachineId);
            }
            if (machineId == null) {
                machineId = ServerIdentity.defaultMachineId();
            }
            machineId[0] = (byte)(machineId[0] & 0x7F);
            return machineId;
        }
        catch (Exception e) {
            byte[] machineId = StringUtils.getRandom(4);
            machineId[0] = (byte)(machineId[0] & 0x7F);
            SysErrLogger.FAKE_LOGGER.ignoreLog(e);
            return machineId;
        }
    }

    private static final int macAddress(byte[] mac) {
        int macl = 0;
        if (mac == null) {
            return macl;
        }
        int i = mac.length - 4;
        if (i < 0) {
            i = 0;
        }
        macl |= (mac[i++] & 0x7F) << 24;
        int j = 1;
        while (i < mac.length) {
            macl |= (mac[i] & 0xFF) << (3 - j) * 8;
            ++i;
            ++j;
        }
        return macl;
    }

    private static final byte[] parseMachineId(String valueSource) {
        String value = valueSource.replaceAll("[:-]", "");
        byte[] machineId = new byte[4];
        int i = value.length() / 2;
        for (int j = 0; i < value.length() && j < 4; i += 2, ++j) {
            machineId[j] = (byte)Integer.parseInt(value.substring(i, i + 2), 16);
        }
        return machineId;
    }

    private static final byte[] defaultMachineId() {
        byte[] notFound = new byte[]{-1};
        byte[] localhost4Bytes = new byte[]{127, 0, 0, 1};
        byte[] bestMacAddr = notFound;
        InetAddress bestInetAddr = null;
        try {
            bestInetAddr = InetAddress.getByAddress(localhost4Bytes);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        LinkedHashMap<NetworkInterface, InetAddress> ifaces = new LinkedHashMap<NetworkInterface, InetAddress>();
        try {
            Enumeration<NetworkInterface> i = NetworkInterface.getNetworkInterfaces();
            while (i.hasMoreElements()) {
                InetAddress a;
                NetworkInterface iface = i.nextElement();
                Enumeration<InetAddress> addrs = iface.getInetAddresses();
                if (!addrs.hasMoreElements() || (a = addrs.nextElement()).isLoopbackAddress()) continue;
                ifaces.put(iface, a);
            }
        }
        catch (SocketException e) {
            throw new IllegalArgumentException(e);
        }
        for (Map.Entry entry : ifaces.entrySet()) {
            byte[] macAddr;
            NetworkInterface iface = (NetworkInterface)entry.getKey();
            InetAddress inetAddr = (InetAddress)entry.getValue();
            if (iface.isVirtual()) continue;
            try {
                macAddr = iface.getHardwareAddress();
            }
            catch (SocketException e) {
                SysErrLogger.FAKE_LOGGER.ignoreLog(e);
                continue;
            }
            boolean replace = false;
            int res = ServerIdentity.compareAddresses(bestMacAddr, macAddr);
            if (res < 0) {
                replace = true;
            } else if (res == 0) {
                res = ServerIdentity.compareAddresses(bestInetAddr, inetAddr);
                if (bestMacAddr != null && macAddr != null && (res < 0 || res == 0 && bestMacAddr.length < macAddr.length)) {
                    replace = true;
                }
            }
            if (!replace) continue;
            bestMacAddr = macAddr;
            bestInetAddr = inetAddr;
        }
        if (bestMacAddr == notFound) {
            bestMacAddr = StringUtils.getRandom(4);
        }
        return bestMacAddr;
    }

    private static final int compareAddresses(byte[] current, byte[] candidate) {
        if (candidate == null) {
            return 1;
        }
        if (candidate.length < 6) {
            return 1;
        }
        boolean onlyZeroAndOne = true;
        for (byte b : candidate) {
            if (b == 0 || b == 1) continue;
            onlyZeroAndOne = false;
            break;
        }
        if (onlyZeroAndOne) {
            return 1;
        }
        if ((candidate[0] & 1) != 0) {
            return 1;
        }
        if ((current[0] & 1) == 0) {
            if ((candidate[0] & 1) == 0) {
                return 0;
            }
            return 1;
        }
        if ((candidate[0] & 1) == 0) {
            return -1;
        }
        return 0;
    }

    private static final int compareAddresses(InetAddress current, InetAddress candidate) {
        return ServerIdentity.scoreAddress(current) - ServerIdentity.scoreAddress(candidate);
    }

    private static final int scoreAddress(InetAddress addr) {
        if (addr.isAnyLocalAddress() || addr.isLoopbackAddress()) {
            return 0;
        }
        if (addr.isMulticastAddress()) {
            return 1;
        }
        if (addr.isLinkLocalAddress()) {
            return 2;
        }
        if (addr.isSiteLocalAddress()) {
            return 3;
        }
        return 4;
    }

    public static class ServerIdentityConfigurationImpl
    implements ServerIdentityConfiguration {
        private static final String CONFIGURATION_PARAMETERS = "ServerIdentityConfiguration parameters";
        private String identityName;
        private int identityServerId;
        private int identitySiteId;
        private String identityRole;

        public ServerIdentityConfigurationImpl() {
        }

        public ServerIdentityConfigurationImpl(String identityName, int identityServerId, int identitySiteId, String identityRole) {
            ParametersChecker.checkParameter(CONFIGURATION_PARAMETERS, identityName, identityRole);
            if (identitySiteId < 0) {
                throw new IllegalArgumentException("Site id must be positive");
            }
            if (identityServerId < 0) {
                throw new IllegalArgumentException("Server id must be positive");
            }
            this.identityName = identityName;
            this.identityServerId = identityServerId;
            this.identitySiteId = identitySiteId;
            this.identityRole = identityRole;
        }

        @Override
        public String getIdentityName() {
            return this.identityName;
        }

        @Override
        public int getIdentityServerId() {
            return this.identityServerId;
        }

        @Override
        public int getIdentitySiteId() {
            return this.identitySiteId;
        }

        @Override
        public String getIdentityRole() {
            return this.identityRole;
        }

        public ServerIdentityConfigurationImpl setIdentityName(String identityName) {
            ParametersChecker.checkParameter(CONFIGURATION_PARAMETERS, identityName);
            this.identityName = identityName;
            return this;
        }

        public ServerIdentityConfigurationImpl setIdentityServerId(int identityServerId) {
            if (identityServerId < 0) {
                throw new IllegalArgumentException("identityServerId id must be positive");
            }
            this.identityServerId = identityServerId;
            return this;
        }

        public ServerIdentityConfigurationImpl setIdentitySiteId(int identitySiteId) {
            if (identitySiteId < 0) {
                throw new IllegalArgumentException("identitySiteId id must be positive");
            }
            this.identitySiteId = identitySiteId;
            return this;
        }

        public ServerIdentityConfigurationImpl setIdentityRole(String identityRole) {
            ParametersChecker.checkParameter(CONFIGURATION_PARAMETERS, identityRole);
            this.identityRole = identityRole;
            return this;
        }
    }

    public static enum MAP_KEYNAME {
        NAME,
        ROLE,
        SITEID,
        SERVERID;

    }
}

