/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common;

import jakarta.ws.rs.core.MediaType;

public class CommonMediaType
extends MediaType {
    private static final String APPLICATION = "application";
    public static final String ZIP = "application/zip";
    public static final MediaType ZIP_TYPE = new MediaType("application", "zip");
    public static final String TAR = "application/x-tar";
    public static final MediaType TAR_TYPE = new MediaType("application", "x-tar");
    public static final String XGZIP = "application/x-gzip";
    public static final MediaType XGZIP_TYPE = new MediaType("application", "x-gzip");
    public static final String GZIP = "application/gzip";
    public static final MediaType GZIP_TYPE = new MediaType("application", "gzip");
    public static final String BZIP2 = "application/x-bzip2";
    public static final MediaType BZIP2_TYPE = new MediaType("application", "x-bzip2");
    public static final String TEXT_CSV = "text/csv";
    public static final MediaType TEXT_CSV_MEDIATYPE = MediaType.valueOf((String)"text/csv");

    public static MediaType valueOf(String archivetype) {
        if (archivetype == null) {
            throw new IllegalArgumentException("MimeType not filled");
        }
        String[] tab = archivetype.split(";");
        String newMimeType = archivetype;
        if (tab != null && tab.length > 1) {
            newMimeType = tab[0];
        }
        switch (newMimeType) {
            case "application/zip": {
                return ZIP_TYPE;
            }
            case "application/x-gzip": {
                return XGZIP_TYPE;
            }
            case "application/gzip": {
                return GZIP_TYPE;
            }
            case "application/x-tar": {
                return TAR_TYPE;
            }
            case "application/x-bzip2": {
                return BZIP2_TYPE;
            }
        }
        throw new IllegalArgumentException("Unsupported media type:" + archivetype);
    }

    public static String mimeTypeOf(MediaType mediaType) {
        if (mediaType == null) {
            throw new IllegalArgumentException("mediaType must not be null.");
        }
        return mediaType.getType() + "/" + mediaType.getSubtype();
    }

    public static boolean isSupportedFormat(String mimeType) {
        switch (mimeType) {
            case "application/zip": 
            case "application/x-gzip": 
            case "application/gzip": 
            case "application/x-tar": 
            case "application/x-bzip2": {
                return true;
            }
        }
        return false;
    }
}

