/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.storage.driver;

import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.client.VitamClientFactoryInterface;
import fr.gouv.vitam.common.exception.VitamApplicationServerException;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.storage.driver.AbstractConnection;
import fr.gouv.vitam.storage.driver.Driver;
import fr.gouv.vitam.storage.driver.exception.StorageDriverException;
import fr.gouv.vitam.storage.engine.common.referential.model.StorageOffer;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;

public abstract class AbstractDriver
implements Driver {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(AbstractDriver.class);
    protected final Map<String, VitamClientFactoryInterface<? extends AbstractConnection>> connectionFactories = new ConcurrentHashMap<String, VitamClientFactoryInterface<? extends AbstractConnection>>();

    @Override
    public boolean isStorageOfferAvailable(String offerId) throws StorageDriverException {
        try {
            ParametersChecker.checkParameter((String)"StorageId Cannot be null", (String[])new String[]{offerId});
        }
        catch (IllegalArgumentException e) {
            LOGGER.info((Throwable)e);
            return false;
        }
        if (this.connectionFactories.containsKey(offerId)) {
            try {
                VitamClientFactoryInterface<? extends AbstractConnection> factory = this.connectionFactories.get(offerId);
                try (AbstractConnection connection = (AbstractConnection)factory.getClient();){
                    connection.checkStatus();
                }
                LOGGER.debug("Check status ok");
                return true;
            }
            catch (VitamApplicationServerException exception) {
                LOGGER.error("Service unavailable for Driver {} with Offer {}", new Object[]{this.getName(), offerId, exception});
                return false;
            }
        }
        LOGGER.error("Driver {} has no Offer named {}", (Object)this.getName(), (Object)offerId);
        return false;
    }

    @Override
    public final boolean addOffer(StorageOffer offer, Properties parameters) {
        if (!this.connectionFactories.containsKey(offer.getId())) {
            this.connectionFactories.put(offer.getId(), this.addInternalOfferAsFactory(offer, parameters));
        }
        return false;
    }

    protected abstract VitamClientFactoryInterface<? extends AbstractConnection> addInternalOfferAsFactory(StorageOffer var1, Properties var2);

    @Override
    public final boolean removeOffer(String offer) {
        if (this.connectionFactories.containsKey(offer)) {
            VitamClientFactoryInterface<? extends AbstractConnection> factory = this.connectionFactories.remove(offer);
            factory.shutdown();
            return true;
        }
        LOGGER.error("Driver {} has no Offer named {}", (Object)this.getName(), (Object)offer);
        return false;
    }

    @Override
    public final boolean hasOffer(String offerId) {
        return this.connectionFactories.containsKey(offerId);
    }

    public void close() {
        for (Map.Entry<String, VitamClientFactoryInterface<? extends AbstractConnection>> item : this.connectionFactories.entrySet()) {
            item.getValue().shutdown();
        }
        this.connectionFactories.clear();
    }
}

