/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.thread;

import fr.gouv.vitam.common.thread.RunWithCustomExecutor;
import java.lang.annotation.Annotation;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutorService;
import org.junit.ClassRule;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class RunWithCustomExecutorRule
implements TestRule,
ClassRule {
    private final ExecutorService executor;

    public RunWithCustomExecutorRule(ExecutorService executor) {
        this.executor = executor;
    }

    public Statement apply(Statement base, Description description) {
        if (description.getAnnotation(RunWithCustomExecutor.class) != null) {
            return new RunInVitamThreadStatement(base);
        }
        return base;
    }

    public Class<? extends Annotation> annotationType() {
        return RunWithCustomExecutor.class;
    }

    public int order() {
        return -1;
    }

    private class RunInVitamThreadStatement
    extends Statement {
        private final Statement baseStatement;

        public RunInVitamThreadStatement(Statement base) {
            this.baseStatement = base;
        }

        public void evaluate() throws Throwable {
            try {
                CompletableFuture<Void> run = CompletableFuture.runAsync(() -> {
                    try {
                        this.baseStatement.evaluate();
                    }
                    catch (Throwable e) {
                        throw new CompletionException(e);
                    }
                }, RunWithCustomExecutorRule.this.executor);
                run.join();
            }
            catch (CompletionException e) {
                throw e.getCause();
            }
        }
    }
}

