/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.shiro.junit;

import org.apache.shiro.SecurityUtils;
import org.apache.shiro.UnavailableSecurityManagerException;
import org.apache.shiro.lang.util.LifecycleUtils;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.subject.support.SubjectThreadState;
import org.apache.shiro.util.ThreadState;
import org.junit.AfterClass;

public abstract class AbstractShiroTest {
    private static ThreadState subjectThreadState;

    protected void setSubject(Subject subject) {
        this.clearSubject();
        AbstractShiroTest.setSubjectThreadState(this.createThreadState(subject));
        subjectThreadState.bind();
    }

    private ThreadState createThreadState(Subject subject) {
        return new SubjectThreadState(subject);
    }

    protected void clearSubject() {
        AbstractShiroTest.doClearSubject();
    }

    private static void doClearSubject() {
        if (subjectThreadState != null) {
            subjectThreadState.clear();
            subjectThreadState = null;
        }
    }

    private static void setSubjectThreadState(ThreadState subjectThreadState) {
        AbstractShiroTest.subjectThreadState = subjectThreadState;
    }

    protected static void setSecurityManager(SecurityManager securityManager) {
        SecurityUtils.setSecurityManager((SecurityManager)securityManager);
    }

    protected static SecurityManager getSecurityManager() {
        return SecurityUtils.getSecurityManager();
    }

    @AfterClass
    public static void tearDownShiro() {
        AbstractShiroTest.doClearSubject();
        try {
            SecurityManager securityManager = AbstractShiroTest.getSecurityManager();
            LifecycleUtils.destroy((Object)securityManager);
        }
        catch (UnavailableSecurityManagerException unavailableSecurityManagerException) {
            // empty catch block
        }
        AbstractShiroTest.setSecurityManager(null);
    }
}

