/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.access.internal.api;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.access.internal.common.exception.AccessInternalException;
import fr.gouv.vitam.access.internal.common.exception.AccessInternalExecutionException;
import fr.gouv.vitam.access.internal.common.exception.AccessInternalIllegalOperationException;
import fr.gouv.vitam.access.internal.common.exception.AccessInternalRuleExecutionException;
import fr.gouv.vitam.access.internal.common.exception.AccessInternalUnavailableDataFromAsyncOfferException;
import fr.gouv.vitam.common.exception.AccessUnauthorizedException;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.UpdatePermissionException;
import fr.gouv.vitam.common.exception.VitamDBException;
import fr.gouv.vitam.common.model.identifier.PurgedCollectionType;
import fr.gouv.vitam.common.model.objectgroup.ObjectGroupResponse;
import fr.gouv.vitam.common.model.storage.AccessRequestReference;
import fr.gouv.vitam.common.model.storage.StatusByAccessRequest;
import fr.gouv.vitam.metadata.api.exception.MetaDataNotFoundException;
import fr.gouv.vitam.metadata.api.exception.MetadataScrollLimitExceededException;
import fr.gouv.vitam.metadata.api.exception.MetadataScrollThresholdExceededException;
import fr.gouv.vitam.storage.engine.common.exception.StorageNotFoundException;
import jakarta.annotation.Nullable;
import jakarta.ws.rs.core.Response;
import java.text.ParseException;
import java.util.List;
import java.util.Optional;

public interface AccessInternalModule {
    public JsonNode selectUnit(JsonNode var1) throws InvalidParseOperationException, AccessInternalExecutionException, VitamDBException;

    public JsonNode selectPurgedPersistentIdentifier(String var1, @Nullable PurgedCollectionType var2) throws InvalidParseOperationException, AccessInternalException;

    public JsonNode selectUnitbyId(JsonNode var1, String var2) throws InvalidParseOperationException, AccessInternalExecutionException, MetaDataNotFoundException;

    public JsonNode updateUnitById(JsonNode var1, String var2, String var3) throws MetaDataNotFoundException, InvalidParseOperationException, AccessInternalExecutionException, IllegalArgumentException, UpdatePermissionException, AccessInternalRuleExecutionException;

    public JsonNode selectObjectGroupById(JsonNode var1, String var2) throws InvalidParseOperationException, AccessInternalExecutionException, MetaDataNotFoundException;

    public Response getOneObjectFromObjectGroup(String var1, String var2, int var3, String var4) throws StorageNotFoundException, InvalidParseOperationException, MetaDataNotFoundException, AccessInternalExecutionException, AccessInternalUnavailableDataFromAsyncOfferException;

    public Response getObjectByPersistentIdentifier(String var1) throws MetaDataNotFoundException, StorageNotFoundException, AccessInternalException, AccessUnauthorizedException;

    public Response getAccessLog(JsonNode var1) throws AccessInternalExecutionException, StorageNotFoundException, ParseException;

    public Response findDIPByOperationId(String var1) throws AccessInternalExecutionException;

    public Response findTransferSIPByOperationId(String var1) throws AccessInternalExecutionException;

    public JsonNode selectObjects(JsonNode var1) throws InvalidParseOperationException, AccessInternalExecutionException, VitamDBException;

    public JsonNode selectUnitsWithInheritedRules(JsonNode var1) throws IllegalArgumentException, InvalidParseOperationException, AccessInternalExecutionException;

    public void checkClassificationLevel(JsonNode var1) throws IllegalArgumentException, InvalidParseOperationException;

    public Optional<AccessRequestReference> createObjectAccessRequestIfRequired(String var1, String var2, int var3) throws MetaDataNotFoundException, InvalidParseOperationException, AccessInternalExecutionException;

    public List<StatusByAccessRequest> checkAccessRequestStatuses(List<AccessRequestReference> var1) throws AccessInternalExecutionException, AccessInternalIllegalOperationException;

    public void removeAccessRequest(String var1, String var2) throws AccessInternalExecutionException, AccessInternalIllegalOperationException;

    public Response streamUnits(JsonNode var1) throws AccessInternalExecutionException, MetadataScrollLimitExceededException, MetadataScrollThresholdExceededException;

    public Response streamObjects(JsonNode var1) throws AccessInternalExecutionException, MetadataScrollLimitExceededException, MetadataScrollThresholdExceededException;

    public Response getObjectByUnitPersistentIdentifier(String var1, String var2, Integer var3) throws InvalidParseOperationException, MetaDataNotFoundException, StorageNotFoundException, AccessInternalException;

    public ObjectGroupResponse findOneObjectGroupByPersistentId(String var1, @Nullable JsonNode var2) throws MetaDataNotFoundException, AccessUnauthorizedException;
}

