/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.database.builder.request.single;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.common.database.builder.request.configuration.BuilderToken;
import fr.gouv.vitam.common.database.builder.request.configuration.GlobalDatas;
import fr.gouv.vitam.common.database.builder.request.single.RequestSingle;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;

public class Insert
extends RequestSingle {
    protected ArrayNode data;

    public final Insert resetData() {
        if (this.data != null) {
            this.data.removeAll();
        }
        return this;
    }

    @Override
    public final Insert reset() {
        super.reset();
        this.resetData();
        return this;
    }

    public final Insert addData(ObjectNode ... data) {
        if (this.data == null) {
            this.data = JsonHandler.createArrayNode();
        }
        for (ObjectNode act : data) {
            if (act.isMissingNode()) continue;
            this.data.add((JsonNode)act);
        }
        return this;
    }

    public final Insert setData(JsonNode dataContent) throws InvalidParseOperationException {
        if (this.data == null) {
            this.data = JsonHandler.createArrayNode();
        }
        if (dataContent instanceof ArrayNode) {
            this.data.addAll((ArrayNode)dataContent);
        } else {
            this.data.add((JsonNode)JsonHandler.createArrayNode().add(dataContent));
        }
        return this;
    }

    public final Insert parseData(String data) throws InvalidParseOperationException {
        GlobalDatas.sanityValueCheck(data);
        JsonNode dataContent = JsonHandler.getFromString((String)data);
        return this.setData(dataContent);
    }

    public final ObjectNode getFinalInsert() {
        ObjectNode node = this.getFinal();
        if (this.data != null && this.data.size() > 0) {
            node.set(BuilderToken.GLOBAL.DATA.exactToken(), (JsonNode)this.data);
        } else {
            node.putObject(BuilderToken.GLOBAL.DATA.exactToken());
        }
        return node;
    }

    public final ObjectNode getData() {
        if (this.data == null) {
            return JsonHandler.createObjectNode();
        }
        return (ObjectNode)this.data.get(0);
    }

    @Override
    public final ArrayNode getDatas() {
        if (this.data == null) {
            return JsonHandler.createArrayNode();
        }
        return this.data;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("INSERT: ").append(super.toString()).append("\n\tData: ").append(this.data);
        return builder.toString();
    }
}

