/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.database.builder.request.multiple;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.database.builder.facet.Facet;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.query.action.Action;
import fr.gouv.vitam.common.database.builder.request.AbstractRequest;
import fr.gouv.vitam.common.database.builder.request.configuration.BuilderToken;
import fr.gouv.vitam.common.database.builder.request.configuration.GlobalDatas;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;

public abstract class RequestMultiple
extends AbstractRequest {
    protected Set<String> roots = new HashSet<String>();
    protected List<Query> queries = new ArrayList<Query>();
    protected List<Facet> facets = new ArrayList<Facet>();
    protected Long threshold;

    public final RequestMultiple resetQueries() {
        if (this.queries != null) {
            this.queries.forEach(new Consumer<Query>(){

                @Override
                public void accept(Query t) {
                    t.clean();
                }
            });
            this.queries.clear();
        }
        return this;
    }

    public final RequestMultiple resetRoots() {
        if (this.roots != null) {
            this.roots.clear();
        }
        return this;
    }

    @Override
    public RequestMultiple reset() {
        this.resetRoots();
        this.resetFilter();
        this.resetQueries();
        return this;
    }

    public final RequestMultiple addQueries(Query ... queries) throws InvalidCreateOperationException {
        for (Query query : queries) {
            ParametersChecker.checkParameter((String)"Query is a mandatory parameter", (Object[])new Object[]{query});
            if (!query.isReady()) {
                throw new InvalidCreateOperationException("Query is not ready to be added: " + String.valueOf(query.getCurrentQuery()));
            }
            this.queries.add(query);
        }
        return this;
    }

    @Override
    public RequestMultiple setQuery(Query query) throws InvalidCreateOperationException {
        ParametersChecker.checkParameter((String)"Query is a mandatory parameter", (Object[])new Object[]{query});
        if (!query.isReady()) {
            throw new InvalidCreateOperationException("Query is not ready to be added: " + String.valueOf(query.getCurrentQuery()));
        }
        this.queries = new ArrayList<Query>();
        this.queries.add(query);
        return this;
    }

    public final RequestMultiple addRoots(String ... roots) throws InvalidParseOperationException {
        for (String root : roots) {
            GlobalDatas.sanityParameterCheck(root);
            this.roots.add(root);
        }
        return this;
    }

    public final RequestMultiple addRoots(ArrayNode rootContent) {
        for (JsonNode jsonNode : rootContent) {
            this.roots.add(jsonNode.asText());
        }
        return this;
    }

    public final RequestMultiple parseRoots(String roots) throws InvalidParseOperationException {
        GlobalDatas.sanityParametersCheck(roots, 1000);
        try {
            ArrayNode rootNode = (ArrayNode)JsonHandler.getFromString((String)roots);
            return this.addRoots(rootNode);
        }
        catch (Exception e) {
            throw new InvalidParseOperationException("Error while parsing Array of Roots", (Throwable)e);
        }
    }

    @Override
    protected final ObjectNode getFinal() {
        ArrayNode array;
        ObjectNode node = JsonHandler.createObjectNode();
        if (this.roots != null && !this.roots.isEmpty()) {
            array = node.putArray(BuilderToken.GLOBAL.ROOTS.exactToken());
            for (String val : this.roots) {
                array.add(val);
            }
        } else {
            node.putArray(BuilderToken.GLOBAL.ROOTS.exactToken());
        }
        if (this.queries != null && !this.queries.isEmpty()) {
            array = JsonHandler.createArrayNode();
            for (Query query : this.queries) {
                array.add((JsonNode)query.getCurrentQuery());
            }
            node.set(BuilderToken.GLOBAL.QUERY.exactToken(), (JsonNode)array);
        } else {
            node.putArray(BuilderToken.GLOBAL.QUERY.exactToken());
        }
        if (this.filter != null && this.filter.size() > 0) {
            node.set(BuilderToken.GLOBAL.FILTER.exactToken(), (JsonNode)this.filter);
        } else {
            node.putObject(BuilderToken.GLOBAL.FILTER.exactToken());
        }
        return node;
    }

    @Override
    public final Set<String> getRoots() {
        return this.roots;
    }

    @Override
    public final int getNbQueries() {
        return this.queries.size();
    }

    @Override
    public final List<Query> getQueries() {
        return this.queries;
    }

    public final Query getNthQuery(int nth) {
        if (nth >= this.queries.size()) {
            return null;
        }
        return this.queries.get(nth);
    }

    public List<Facet> getFacets() {
        return this.facets;
    }

    public void setFacets(List<Facet> facets) {
        this.facets = facets;
    }

    @Override
    public JsonNode getData() {
        return JsonHandler.createObjectNode();
    }

    @Override
    public boolean getAllProjection() {
        return false;
    }

    @Override
    public ObjectNode getProjection() {
        return JsonHandler.createObjectNode();
    }

    public Long getThreshold() {
        return this.threshold;
    }

    public void setThreshold(Long threshold) {
        this.threshold = threshold;
    }

    @Override
    public List<Action> getActions() {
        return Collections.emptyList();
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Requests: ");
        for (Query subrequest : this.getQueries()) {
            builder.append("\n").append(subrequest);
        }
        builder.append(super.toString()).append("\n\tRoots: ").append(this.roots);
        return builder.toString();
    }
}

