/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.database.builder.request.multiple;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.common.database.builder.request.configuration.BuilderToken;
import fr.gouv.vitam.common.database.builder.request.configuration.GlobalDatas;
import fr.gouv.vitam.common.database.builder.request.multiple.RequestMultiple;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;

public class InsertMultiQuery
extends RequestMultiple {
    protected ObjectNode data;

    public final InsertMultiQuery resetData() {
        if (this.data != null) {
            this.data.removeAll();
        }
        return this;
    }

    @Override
    public final InsertMultiQuery reset() {
        super.reset();
        this.resetData();
        return this;
    }

    public final InsertMultiQuery setMult(boolean mult) {
        if (this.filter == null) {
            this.filter = JsonHandler.createObjectNode();
        }
        this.filter.put(BuilderToken.MULTIFILTER.MULT.exactToken(), mult);
        return this;
    }

    public final InsertMultiQuery setMult(JsonNode filterContent) {
        if (this.filter == null) {
            this.filter = JsonHandler.createObjectNode();
        }
        if (filterContent.has(BuilderToken.MULTIFILTER.MULT.exactToken())) {
            this.filter.setAll((ObjectNode)filterContent);
        }
        return this;
    }

    @Override
    public final InsertMultiQuery setFilter(JsonNode filterContent) throws InvalidParseOperationException {
        super.setFilter(filterContent);
        return this.setMult(filterContent);
    }

    public final InsertMultiQuery addData(ObjectNode ... data) {
        if (this.data == null) {
            this.data = JsonHandler.createObjectNode();
        }
        for (ObjectNode act : data) {
            if (act.isMissingNode()) continue;
            this.data.setAll(act);
        }
        return this;
    }

    public final InsertMultiQuery setData(JsonNode dataContent) throws InvalidParseOperationException {
        if (this.data == null) {
            this.data = JsonHandler.createObjectNode();
        }
        this.data.setAll((ObjectNode)dataContent);
        return this;
    }

    public final InsertMultiQuery parseData(String data) throws InvalidParseOperationException {
        GlobalDatas.sanityValueCheck(data);
        JsonNode dataContent = JsonHandler.getFromString((String)data);
        return this.setData(dataContent);
    }

    public final ObjectNode getFinalInsert() {
        ObjectNode node = this.getFinal();
        if (this.data != null && this.data.size() > 0) {
            node.set(BuilderToken.GLOBAL.DATA.exactToken(), (JsonNode)this.data);
        } else {
            node.putObject(BuilderToken.GLOBAL.DATA.exactToken());
        }
        return node;
    }

    public final ObjectNode getData() {
        if (this.data == null) {
            return JsonHandler.createObjectNode();
        }
        return this.data;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("INSERT: ").append(super.toString()).append("\n\tData: ").append(this.data);
        return builder.toString();
    }
}

