/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.database.builder.request.configuration;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;

public class GlobalDatas {
    public static final int LIMIT_LOAD = 10000;
    private static int limitValue = 10000000;
    private static int limitParameter = 1000;
    public static final int NB_ROOTS = 1000;
    public static final int NB_FILTERS = 10;
    public static final int NB_FACETS = 1000;
    public static final int NB_PROJECTIONS = 1000;
    public static final int MAXDEPTH = 100;

    protected GlobalDatas() {
    }

    protected static final void sanityCheck(String arg, int size) throws InvalidParseOperationException {
        if (arg == null) {
            throw new InvalidParseOperationException("String is null but must not");
        }
        if (arg.length() > size) {
            throw new InvalidParseOperationException("String exceeds sanity check of " + size);
        }
    }

    public static final void sanityValueCheck(String arg) throws InvalidParseOperationException {
        GlobalDatas.sanityCheck(arg, limitValue);
    }

    public static final void sanityValueCheck(List<?> arg) throws InvalidParseOperationException {
        for (Object value : arg) {
            GlobalDatas.sanityCheck(value.toString(), limitValue);
        }
    }

    public static final void sanityParameterCheck(String arg) throws InvalidParseOperationException {
        GlobalDatas.sanityCheck(arg, limitParameter);
        if (arg.charAt(0) == '_') {
            throw new InvalidParseOperationException("Variable name form is not allowed: " + arg);
        }
    }

    public static final void sanityParametersCheck(String arg, int multipleParams) throws InvalidParseOperationException {
        GlobalDatas.sanityCheck(arg, limitParameter * multipleParams);
    }

    public static final ObjectNode getDate(Date date) {
        ParametersChecker.checkParameter((String)"Date cannot be null", (Object[])new Object[]{date});
        return JsonHandler.createObjectNode().put("$date", LocalDateUtil.getFormattedDateTimeForMongo((LocalDateTime)LocalDateUtil.fromDate((Date)date)));
    }

    public static final JsonNode getValueJsonNode(Object value) throws InvalidCreateOperationException {
        ObjectNode node = JsonHandler.createObjectNode();
        if (value == null) {
            return node.nullNode();
        }
        if (value instanceof Integer) {
            return node.numberNode((Integer)value);
        }
        if (value instanceof Long) {
            return node.numberNode((Long)value);
        }
        if (value instanceof Float) {
            return node.numberNode((Float)value);
        }
        if (value instanceof Double) {
            return node.numberNode((Double)value);
        }
        if (value instanceof Boolean) {
            return node.booleanNode(((Boolean)value).booleanValue());
        }
        if (value instanceof Date) {
            return GlobalDatas.getDate((Date)value);
        }
        if (value instanceof JsonNode) {
            return (JsonNode)value;
        }
        String val = value.toString();
        try {
            GlobalDatas.sanityValueCheck(val);
        }
        catch (InvalidParseOperationException e) {
            throw new InvalidCreateOperationException(e);
        }
        return node.textNode(val);
    }

    public static final void sanityVariableNameCheck(String arg) throws InvalidParseOperationException {
        ParametersChecker.checkParameter((String)"Arg cannot be null", (String[])new String[]{arg});
        if (arg.charAt(0) == '#') {
            throw new InvalidParseOperationException("Variable name cannot be a protected one (starting with '#'");
        }
    }

    public static int getLimitValue() {
        return limitValue;
    }

    public static void setLimitValue(int limitValue) {
        GlobalDatas.limitValue = limitValue;
    }

    public static int getLimitParameter() {
        return limitParameter;
    }

    public static void setLimitParameter(int limitParameter) {
        GlobalDatas.limitParameter = limitParameter;
    }

    public static void setArrayValueFromList(ArrayNode array, List<?> list) {
        for (Object object : list) {
            if (object instanceof String) {
                array.add((String)object);
                continue;
            }
            if (object instanceof Long) {
                array.add((Long)object);
                continue;
            }
            if (object instanceof Float) {
                array.add((Float)object);
                continue;
            }
            if (object instanceof Double) {
                array.add((Double)object);
                continue;
            }
            if (object instanceof Boolean) {
                array.add((Boolean)object);
                continue;
            }
            if (object instanceof Integer) {
                array.add((Integer)object);
                continue;
            }
            if (object instanceof BigDecimal) {
                array.add((BigDecimal)object);
                continue;
            }
            if (object instanceof Date) {
                array.add((JsonNode)JsonHandler.createObjectNode().put("$date", ((Date)object).toInstant().toString()));
                continue;
            }
            array.add(object.toString());
        }
    }
}

