/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.database.builder.query;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.request.configuration.BuilderToken;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import java.util.ArrayList;
import java.util.List;

public class BooleanQuery
extends Query {
    protected List<Query> queries = new ArrayList<Query>();

    protected BooleanQuery() {
    }

    public BooleanQuery(BuilderToken.QUERY booleanQuery) throws InvalidCreateOperationException {
        switch (booleanQuery) {
            case AND: 
            case NOT: 
            case OR: {
                this.createQueryArray(booleanQuery);
                this.currentTokenQUERY = booleanQuery;
                break;
            }
            default: {
                throw new InvalidCreateOperationException("Query " + String.valueOf((Object)booleanQuery) + " is not a Boolean Query");
            }
        }
    }

    @Override
    public void clean() {
        super.clean();
        for (Query query : this.queries) {
            query.clean();
        }
        this.queries.clear();
    }

    public final BooleanQuery add(Query ... queries) throws InvalidCreateOperationException {
        if (this.currentTokenQUERY != null) {
            switch (this.currentTokenQUERY) {
                case AND: 
                case NOT: 
                case OR: {
                    break;
                }
                default: {
                    throw new InvalidCreateOperationException("Requests cannot be added since this is not a boolean request: " + String.valueOf((Object)this.currentTokenQUERY));
                }
            }
        }
        ArrayNode array = (ArrayNode)this.currentObject;
        for (Query elt : queries) {
            if (!elt.isReady()) {
                throw new InvalidCreateOperationException("Requests cannot be added since not ready: " + String.valueOf(elt.getCurrentQuery()));
            }
            elt.cleanDepth();
            if (this.currentTokenQUERY == BuilderToken.QUERY.AND && elt.currentTokenQUERY == BuilderToken.QUERY.AND || this.currentTokenQUERY == BuilderToken.QUERY.OR && elt.currentTokenQUERY == BuilderToken.QUERY.OR) {
                BooleanQuery subelts = (BooleanQuery)elt;
                for (Query sub : subelts.queries) {
                    this.queries.add(sub);
                    array.add((JsonNode)sub.getCurrentQuery());
                }
                continue;
            }
            this.queries.add(elt);
            array.add((JsonNode)elt.getCurrentQuery());
        }
        this.setReady(true);
        return this;
    }

    public List<Query> getQueries() {
        return this.queries;
    }
}

