/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.database.builder.facet;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.common.database.builder.request.configuration.BuilderToken;
import fr.gouv.vitam.common.database.builder.request.configuration.GlobalDatas;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;

public class Facet {
    private String name;
    protected ObjectNode currentFacet;
    protected BuilderToken.FACET currentTokenFACET;

    public Facet(String name) {
        this.name = name;
        this.currentFacet = JsonHandler.createObjectNode();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public BuilderToken.FACET getCurrentTokenFACET() {
        return this.currentTokenFACET;
    }

    public ObjectNode getCurrentFacet() {
        ObjectNode currentNode = JsonHandler.createObjectNode();
        currentNode.put(BuilderToken.FACETARGS.NAME.exactToken(), this.name);
        currentNode.set(this.currentTokenFACET.exactToken(), (JsonNode)this.currentFacet);
        return currentNode;
    }

    protected void checkStringParameterValue(String param, String value) throws InvalidCreateOperationException {
        if (value == null || value.trim().isEmpty()) {
            throw new InvalidCreateOperationException(param + " is mandatory in Facet");
        }
        try {
            GlobalDatas.sanityParameterCheck(value);
        }
        catch (InvalidParseOperationException e) {
            throw new InvalidCreateOperationException(e);
        }
    }

    public String toString() {
        return JsonHandler.unprettyPrint((Object)this.getCurrentFacet());
    }
}

