/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.ihmrecette.appserver.performance;

import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.thread.VitamThreadFactory;
import fr.gouv.vitam.ihmrecette.appserver.performance.PerformanceModel;
import fr.gouv.vitam.ihmrecette.appserver.performance.PerformanceService;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HEAD;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.InputStream;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.stream.Collectors;

@Path(value="/v1/api/performances")
public class PerformanceResource {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(PerformanceResource.class);
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyyMMdd_HHmmss");
    private ExecutorService performanceTestLauncher = Executors.newSingleThreadExecutor((ThreadFactory)VitamThreadFactory.getInstance());
    private PerformanceService performanceService;

    public PerformanceResource(PerformanceService performanceService) {
        this.performanceService = performanceService;
    }

    @POST
    @Consumes(value={"application/json"})
    public Response launchPerformanceTest(@HeaderParam(value="X-Tenant-Id") int tenantId, PerformanceModel model) {
        if (this.performanceService.inProgress()) {
            return Response.accepted().build();
        }
        ParametersChecker.checkParameter((String)"SIP path is a mandatory parameter", (String[])new String[]{model.getFileName()});
        if (!this.performanceService.sipExist(model.getFileName())) {
            LOGGER.error(String.format("SIP path invalid: %s", model.getFileName()));
            return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity((Object)"SIP path invalid").build();
        }
        if (model.getNumberOfIngest() == 0) {
            LOGGER.error("number of ingest must be greater than 0");
            return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity((Object)"number of ingest must be greater than 0").build();
        }
        if (model.getParallelIngest() != null && model.getDelay() != null) {
            LOGGER.error("unable to set parallel ingest and delay in same test");
            return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity((Object)"unable to set parallel ingest and delay in same test").build();
        }
        String fileName = String.format("report_%s.csv", LocalDateUtil.now().format(DATE_TIME_FORMATTER));
        this.performanceTestLauncher.submit(() -> {
            try {
                this.performanceService.launchPerformanceTest(model, fileName, tenantId);
            }
            catch (IOException e) {
                LOGGER.error("unable to launch performance test", (Throwable)e);
            }
        });
        return Response.accepted((Object)fileName).build();
    }

    @HEAD
    public Response status() {
        if (this.performanceService.inProgress()) {
            return Response.accepted().build();
        }
        return Response.ok().build();
    }

    @GET
    @Path(value="/reports")
    @Produces(value={"application/json"})
    public Response listReport() throws IOException {
        List<java.nio.file.Path> paths = this.performanceService.listReportDirectory();
        return Response.ok(paths.stream().map(java.nio.file.Path::getFileName).map(java.nio.file.Path::toString).collect(Collectors.toList())).build();
    }

    @GET
    @Path(value="/sips")
    @Produces(value={"application/json"})
    public Response listSip() throws IOException {
        List<java.nio.file.Path> paths = this.performanceService.listSipDirectory();
        return Response.ok(paths.stream().map(java.nio.file.Path::toString).collect(Collectors.toList())).build();
    }

    @GET
    @Path(value="/reports/{fileName}")
    @Produces(value={"text/plain"})
    public Response report(@PathParam(value="fileName") String fileName) {
        try {
            InputStream inputStream = this.performanceService.readReport(fileName);
            return Response.ok((Object)inputStream).build();
        }
        catch (Exception e) {
            LOGGER.error(String.format("unable to open file: %s", fileName), (Throwable)e);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
    }
}

