/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.ihmrecette.appserver.applicativetest;

import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.ihmrecette.appserver.applicativetest.ApplicativeTestService;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HEAD;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Paths;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.commons.lang3.exception.ExceptionUtils;

@Path(value="/v1/api/applicative-test")
public class ApplicativeTestResource {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(ApplicativeTestResource.class);
    private ApplicativeTestService applicativeTestService;
    private String testSystemSipDirectory;

    public ApplicativeTestResource(ApplicativeTestService applicativeTestService, String testSystemSipDirectory) {
        this.applicativeTestService = applicativeTestService;
        this.testSystemSipDirectory = testSystemSipDirectory;
        System.setProperty("tnrBaseDirectory", testSystemSipDirectory);
    }

    @POST
    @Produces(value={"application/json"})
    public Response launchCucumberTest() {
        if (this.applicativeTestService.inProgress()) {
            return Response.accepted().build();
        }
        try {
            if (this.applicativeTestService.getIsTnrMasterActived().get()) {
                this.applicativeTestService.setIsTnrMasterActived(new AtomicBoolean(false));
                this.applicativeTestService.setTnrBranch("master");
                this.applicativeTestService.checkout(Paths.get(this.testSystemSipDirectory, new String[0]), "master");
            }
            String fileName = this.applicativeTestService.launchCucumberTest(Paths.get(this.testSystemSipDirectory, new String[0]));
            return Response.status((Response.Status)Response.Status.ACCEPTED).entity((Object)fileName).build();
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @POST
    @Path(value="/testFeature")
    @Produces(value={"application/json"})
    public Response launchCucumberPiecesTest(String pieces) {
        String results;
        try {
            if (!this.applicativeTestService.getIsTnrMasterActived().get()) {
                this.applicativeTestService.checkout(Paths.get(this.testSystemSipDirectory, new String[0]), "tnr_master");
                this.applicativeTestService.setTnrBranch("tnr_master");
                this.applicativeTestService.setIsTnrMasterActived(new AtomicBoolean(true));
            }
            results = this.applicativeTestService.launchPiecesCucumberTest(pieces + "\n");
        }
        catch (Exception e) {
            String stackTrace = this.getStack(e);
            LOGGER.error((Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)stackTrace).build();
        }
        return Response.status((Response.Status)Response.Status.OK).entity((Object)results).build();
    }

    private String getStack(Throwable e) {
        String stackTrace = ExceptionUtils.getStackTrace((Throwable)e);
        return stackTrace.replace(System.lineSeparator(), "<br/>\n");
    }

    @HEAD
    public Response status() {
        if (this.applicativeTestService.inProgress()) {
            return Response.accepted().build();
        }
        return Response.ok().build();
    }

    @GET
    @Produces(value={"application/json"})
    public Response listReports() throws IOException {
        List<java.nio.file.Path> reports = this.applicativeTestService.reports();
        return Response.ok(reports.stream().map(java.nio.file.Path::getFileName).map(java.nio.file.Path::toString).collect(Collectors.toList())).build();
    }

    @GET
    @Path(value="/gitBranches")
    @Produces(value={"application/json"})
    public Response listGitBranches() throws IOException, InterruptedException {
        this.applicativeTestService.fetch(Paths.get(this.testSystemSipDirectory, new String[0]));
        List<String> branchList = this.applicativeTestService.getBranches(Paths.get(this.testSystemSipDirectory, new String[0]));
        return Response.ok(branchList).build();
    }

    @GET
    @Path(value="/{report}")
    @Produces(value={"application/octet-stream"})
    public Response reportByName(@PathParam(value="report") String fileName) {
        try {
            InputStream inputStream = this.applicativeTestService.readReport(fileName);
            return Response.ok((Object)inputStream).build();
        }
        catch (IOException e) {
            LOGGER.error(String.format("unable to open file: %s", fileName), (Throwable)e);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
    }

    @POST
    @Path(value="/syncTnrPiecesWithBranch")
    @Produces(value={"application/json"})
    public Response synchronizedPiecesTestDirectoryWithBranch(String branch) throws IOException, InterruptedException {
        LOGGER.debug("synchronise " + branch);
        this.applicativeTestService.fetch(Paths.get(this.testSystemSipDirectory, new String[0]));
        List<String> branchList = this.applicativeTestService.getBranches(Paths.get(this.testSystemSipDirectory, new String[0]));
        if (!branchList.contains(branch)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        int resetStatus = this.applicativeTestService.reset(Paths.get(this.testSystemSipDirectory, new String[0]), branch);
        int checkoutStatus = this.applicativeTestService.checkout(Paths.get(this.testSystemSipDirectory, new String[0]), branch);
        if (resetStatus == 0 && checkoutStatus == 0) {
            return Response.status((Response.Status)Response.Status.OK).entity((Object)0).build();
        }
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)1).build();
    }

    private Response synchronizeGit(String tnrMaster) throws IOException, InterruptedException {
        this.applicativeTestService.checkout(Paths.get(this.testSystemSipDirectory, new String[0]), tnrMaster);
        int status = this.applicativeTestService.synchronizedTestDirectory(Paths.get(this.testSystemSipDirectory, new String[0]));
        return Response.ok().entity((Object)status).build();
    }

    @POST
    @Path(value="/sync")
    public Response synchronizedTestDirectory() throws IOException, InterruptedException {
        return this.synchronizeGit(this.applicativeTestService.getTnrBranch());
    }
}

