/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.ihmrecette.appserver;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Strings;
import fr.gouv.vitam.access.external.api.AdminCollections;
import fr.gouv.vitam.access.external.client.AccessExternalClient;
import fr.gouv.vitam.access.external.client.AccessExternalClientFactory;
import fr.gouv.vitam.access.external.client.AdminExternalClient;
import fr.gouv.vitam.access.external.client.AdminExternalClientFactory;
import fr.gouv.vitam.access.external.common.exception.AccessExternalClientNotFoundException;
import fr.gouv.vitam.access.external.common.exception.AccessExternalClientServerException;
import fr.gouv.vitam.common.BaseXx;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.client.CustomVitamHttpStatusCode;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.error.VitamCode;
import fr.gouv.vitam.common.error.VitamCodeHelper;
import fr.gouv.vitam.common.error.VitamError;
import fr.gouv.vitam.common.exception.AccessUnauthorizedException;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.exception.VitamException;
import fr.gouv.vitam.common.guid.GUIDFactory;
import fr.gouv.vitam.common.i18n.VitamLogbookMessages;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ProcessQuery;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseError;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.model.logbook.LogbookOperation;
import fr.gouv.vitam.common.model.processing.WorkFlowExecutionContext;
import fr.gouv.vitam.common.model.storage.AccessRequestStatus;
import fr.gouv.vitam.common.security.SanityChecker;
import fr.gouv.vitam.common.server.application.AsyncInputStreamHelper;
import fr.gouv.vitam.common.server.application.configuration.FunctionalAdminAdmin;
import fr.gouv.vitam.common.server.application.resources.ApplicationStatusResource;
import fr.gouv.vitam.common.server.application.resources.BasicVitamStatusServiceImpl;
import fr.gouv.vitam.common.server.application.resources.VitamStatusService;
import fr.gouv.vitam.common.stream.StreamUtils;
import fr.gouv.vitam.common.thread.VitamThreadFactory;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.common.xsrf.filter.XSRFFilter;
import fr.gouv.vitam.common.xsrf.filter.XSRFHelper;
import fr.gouv.vitam.functional.administration.common.exception.BackupServiceException;
import fr.gouv.vitam.ihmdemo.common.api.IhmWebAppHeader;
import fr.gouv.vitam.ihmdemo.common.pagination.OffsetBasedPagination;
import fr.gouv.vitam.ihmdemo.common.pagination.PaginationHelper;
import fr.gouv.vitam.ihmdemo.core.DslQueryHelper;
import fr.gouv.vitam.ihmdemo.core.UserInterfaceTransactionManager;
import fr.gouv.vitam.ihmrecette.appserver.LoginModel;
import fr.gouv.vitam.ihmrecette.appserver.StorageCRUDUtils;
import fr.gouv.vitam.ihmrecette.appserver.StorageService;
import fr.gouv.vitam.ihmrecette.appserver.WebApplicationConfig;
import fr.gouv.vitam.logbook.common.exception.LogbookClientException;
import fr.gouv.vitam.logbook.common.exception.LogbookClientServerException;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClient;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClientFactory;
import fr.gouv.vitam.storage.driver.exception.StorageDriverException;
import fr.gouv.vitam.storage.driver.exception.StorageDriverUnavailableDataFromAsyncOfferException;
import fr.gouv.vitam.storage.engine.client.StorageClient;
import fr.gouv.vitam.storage.engine.client.StorageClientFactory;
import fr.gouv.vitam.storage.engine.client.exception.StorageServerClientException;
import fr.gouv.vitam.storage.engine.common.exception.StorageNotFoundException;
import fr.gouv.vitam.storage.engine.common.exception.StorageTechnicalException;
import fr.gouv.vitam.storage.engine.common.model.DataCategory;
import fr.gouv.vitam.workspace.client.WorkspaceClientFactory;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.CookieParam;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.container.AsyncResponse;
import jakarta.ws.rs.container.Suspended;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.util.ThreadContext;

@Path(value="/v1/api")
public class WebApplicationResource
extends ApplicationStatusResource {
    public static final String DEFAULT_CONTRACT_NAME = "default_contract";
    private static final String RESULTS_FIELD = "$results";
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(WebApplicationResource.class);
    private static final String IHM_RECETTE = "IHM_RECETTE";
    private static final String ACCESS_EXTERNAL_MODULE = "AccessExternalModule";
    private static final String MISSING_THE_TENANT_ID_X_TENANT_ID = "Missing the tenant ID (X-Tenant-Id) or wrong object Type";
    private static final String INTERNAL_SERVER_ERROR_MSG = "INTERNAL SERVER ERROR";
    private static final String BAD_REQUEST_EXCEPTION_MSG = "Bad request Exception";
    private static final String ACCESS_CLIENT_NOT_FOUND_EXCEPTION_MSG = "Access client unavailable";
    private static final String ACCESS_SERVER_EXCEPTION_MSG = "Access Server exception";
    private static final String REQUEST_METHOD_UNDEFINED = "Request method undefined for collection";
    private static final Integer TENANT_ID = 0;
    private static final String X_REQUESTED_COLLECTION = "X-Requested-Collection";
    private static final String X_OBJECT_ID = "X-Object-Id";
    private static final String X_REQUEST_ID = "X-Request-Id";
    private static final String UNIT_COLLECTION = "UNIT";
    private static final String LOGBOOK_COLLECTION = "LOGBOOK";
    private static final String OBJECT_GROUP_COLLECTION = "OBJECTGROUP";
    private static final String UNIT_LIFECYCLES = "UNITLIFECYCLES";
    private static final String OBJECT_GROUP_LIFECYCLES = "OBJECTGROUPLIFECYCLES";
    private static final String WORKFLOW_OPERATIONS = "OPERATIONS";
    private static final String WORKFLOWS = "WORKFLOWS";
    private static final String HTTP_GET = "GET";
    private static final String HTTP_PUT = "PUT";
    private static final String HTTP_DELETE = "DELETE";
    private static final String RULE_ACTIONS = "ruleActions";
    private final UserInterfaceTransactionManager userInterfaceTransactionManager;
    private final PaginationHelper paginationHelper;
    private final DslQueryHelper dslQueryHelper;
    private final StorageService storageService;
    private final ExecutorService threadPoolExecutor = Executors.newCachedThreadPool((ThreadFactory)VitamThreadFactory.getInstance());
    private final List<String> secureMode;
    private final FunctionalAdminAdmin functionalAdminAdmin;

    public WebApplicationResource(WebApplicationConfig webApplicationConfigonfig, UserInterfaceTransactionManager userInterfaceTransactionManager, PaginationHelper paginationHelper, DslQueryHelper dslQueryHelper, StorageService storageService) {
        super((VitamStatusService)new BasicVitamStatusServiceImpl());
        this.secureMode = webApplicationConfigonfig.getSecureMode();
        this.userInterfaceTransactionManager = userInterfaceTransactionManager;
        this.paginationHelper = paginationHelper;
        this.dslQueryHelper = dslQueryHelper;
        this.storageService = storageService;
        this.functionalAdminAdmin = webApplicationConfigonfig.getFunctionalAdminAdmin();
        LOGGER.debug("init Admin Management Resource server");
        WorkspaceClientFactory.changeMode((String)webApplicationConfigonfig.getWorkspaceUrl(), (WorkFlowExecutionContext)WorkFlowExecutionContext.VITAM);
    }

    private static String getAppSessionId() {
        return "MyApplicationId-ChangeIt";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="/replaceObject/{dataType}/{strategyId}/{offerId}/{uid}/{size}")
    @Consumes(value={"application/octet-stream"})
    @Produces(value={"application/json"})
    public Response uploadObject(@HeaderParam(value="X-Tenant-Id") String xTenantId, @PathParam(value="uid") String uid, @PathParam(value="dataType") String dataType, @PathParam(value="strategyId") String strategyId, @PathParam(value="offerId") String offerId, @PathParam(value="size") Long size, InputStream input) {
        try {
            VitamThreadUtils.getVitamSession().setTenantId(Integer.valueOf(Integer.parseInt(xTenantId)));
            StorageCRUDUtils storageCRUDUtils = new StorageCRUDUtils();
            DataCategory dataCategory = DataCategory.valueOf((String)dataType);
            storageCRUDUtils.storeInOffer(dataCategory, uid, strategyId, offerId, size, input);
            Response response = Response.status((Response.Status)Response.Status.OK).build();
            return response;
        }
        catch (BackupServiceException e) {
            LOGGER.error(INTERNAL_SERVER_ERROR_MSG, (Throwable)e);
            Response response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
            return response;
        }
        finally {
            StreamUtils.closeSilently((InputStream)input);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @GET
    @Path(value="/strategies")
    @Produces(value={"application/json"})
    public Response getStrategies(@HeaderParam(value="X-Tenant-Id") String xTenantId) {
        try (StorageClient storageClient = StorageClientFactory.getInstance().getClient();){
            VitamThreadUtils.getVitamSession().setTenantId(Integer.valueOf(Integer.parseInt(xTenantId)));
            RequestResponse requestResponse = storageClient.getStorageStrategies();
            if (requestResponse.isOk()) {
                Response response = Response.status((Response.Status)Response.Status.OK).entity((Object)((RequestResponseOK)requestResponse).getResults()).build();
                return response;
            }
            if (requestResponse instanceof VitamError) {
                LOGGER.error(requestResponse.toString());
                Response response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)requestResponse).build();
                return response;
            }
            Response response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
            return response;
        }
        catch (StorageServerClientException e) {
            LOGGER.error(INTERNAL_SERVER_ERROR_MSG, (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @DELETE
    @Path(value="/deleteObject/{dataType}/{strategyId}/{offerId}/{uid}")
    @Produces(value={"application/json"})
    public Response deleteObject(@HeaderParam(value="X-Tenant-Id") String xTenantId, @PathParam(value="uid") String uid, @PathParam(value="dataType") String dataType, @PathParam(value="strategyId") String strategyId, @PathParam(value="offerId") String offerId) {
        try {
            VitamThreadUtils.getVitamSession().setTenantId(Integer.valueOf(Integer.parseInt(xTenantId)));
            StorageCRUDUtils storageCRUDUtils = new StorageCRUDUtils();
            DataCategory dataCategory = DataCategory.valueOf((String)dataType);
            boolean deleted = storageCRUDUtils.deleteFile(dataCategory, uid, strategyId, offerId);
            if (deleted) {
                return Response.status((Response.Status)Response.Status.OK).build();
            }
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        catch (StorageServerClientException e) {
            LOGGER.error(INTERNAL_SERVER_ERROR_MSG, (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @POST
    @Path(value="/launchAudit/{operationId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Deprecated
    public Response launchAudit(@HeaderParam(value="X-Tenant-Id") String xTenantId, @HeaderParam(value="X-Access-Contract-Id") String xAccessContratId, @PathParam(value="operationId") String operationId) {
        try (AdminExternalClient client = AdminExternalClientFactory.getInstance().getClient();){
            VitamContext context = new VitamContext(Integer.valueOf(Integer.parseInt(xTenantId)));
            context.setAccessContract(xAccessContratId).setApplicationSessionId(WebApplicationResource.getAppSessionId());
            RequestResponse requestResponse = client.rectificationAudit(context, operationId);
            if (requestResponse instanceof RequestResponseOK) {
                Response response = Response.status((Response.Status)Response.Status.OK).entity((Object)requestResponse).build();
                return response;
            }
            if (requestResponse instanceof VitamError) {
                LOGGER.error(requestResponse.toString());
                Response response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)requestResponse).build();
                return response;
            }
            Response response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
            return response;
        }
        catch (VitamClientException e) {
            LOGGER.error(INTERNAL_SERVER_ERROR_MSG, (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @POST
    @Path(value="/ingestcleanup/{operationId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response launchIngestCleanup(@HeaderParam(value="X-Tenant-Id") String xTenantId, @HeaderParam(value="X-Access-Contract-Id") String xAccessContratId, @PathParam(value="operationId") String operationId) {
        VitamThreadUtils.getVitamSession().setTenantId(Integer.valueOf(Integer.parseInt(xTenantId)));
        Client client = ClientBuilder.newClient();
        WebTarget target = client.target(String.format("http://%s:%s/adminmanagement/v1/invalidIngestCleanup/%s", this.functionalAdminAdmin.getFunctionalAdminServerHost(), this.functionalAdminAdmin.getFunctionalAdminServerPort(), operationId));
        String basicAuth = "Basic " + BaseXx.getBase64((byte[])(this.functionalAdminAdmin.getAdminBasicAuth().getUserName() + ":" + this.functionalAdminAdmin.getAdminBasicAuth().getPassword()).getBytes());
        Invocation.Builder builder = target.request();
        Response response = builder.header("Content-Type", (Object)"application/json").header("Accept", (Object)"application/json").header("X-Tenant-Id", (Object)xTenantId).header("Authorization", (Object)basicAuth).post(null);
        if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            LOGGER.error("Ingest cleanup failed with status " + response.getStatus());
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        return Response.status((Response.Status)Response.Status.CREATED).build();
    }

    @GET
    @Path(value="/download/{strategyId}/{offerId}/{dataType}/{uid}")
    @Produces(value={"application/octet-stream"})
    public Response getObjectAsInputStreamAsync(@HeaderParam(value="X-Tenant-Id") String xTenantId, @PathParam(value="uid") String uid, @PathParam(value="dataType") String dataType, @PathParam(value="strategyId") String strategyId, @PathParam(value="offerId") String offerId) {
        VitamThreadUtils.getVitamSession().setTenantId(Integer.valueOf(Integer.parseInt(xTenantId)));
        try {
            return this.storageService.download(VitamThreadUtils.getVitamSession().getTenantId(), DataCategory.valueOf((String)dataType), strategyId, offerId, uid);
        }
        catch (StorageTechnicalException e) {
            LOGGER.error(INTERNAL_SERVER_ERROR_MSG, (Throwable)e);
            return this.buildError(VitamCode.STORAGE_TECHNICAL_INTERNAL_ERROR, e.getMessage()).toResponse();
        }
        catch (StorageDriverUnavailableDataFromAsyncOfferException e) {
            LOGGER.error("No active access request found", (Throwable)e);
            return this.buildCustomError(CustomVitamHttpStatusCode.UNAVAILABLE_DATA_FROM_ASYNC_OFFER, e.getMessage());
        }
        catch (StorageDriverException e) {
            LOGGER.error(INTERNAL_SERVER_ERROR_MSG, (Throwable)e);
            return this.buildError(VitamCode.STORAGE_OFFER_NOT_FOUND, e.getMessage()).toResponse();
        }
        catch (StorageNotFoundException e) {
            LOGGER.warn("Not found", (Throwable)e);
            return this.buildError(VitamCode.STORAGE_NOT_FOUND, e.getMessage()).toResponse();
        }
    }

    private VitamError<JsonNode> buildError(VitamCode vitamCode, String message) {
        return new VitamError(VitamCodeHelper.getCode((VitamCode)vitamCode)).setContext(vitamCode.getService().getName()).setHttpCode(vitamCode.getStatus().getStatusCode()).setState(vitamCode.getDomain().getName()).setMessage(vitamCode.getMessage()).setDescription(message);
    }

    private Response buildCustomError(CustomVitamHttpStatusCode customStatusCode, String message) {
        return Response.status((int)customStatusCode.getStatusCode()).entity((Object)new RequestResponseError().setError(new VitamError(customStatusCode.toString()).setContext(IHM_RECETTE).setHttpCode(customStatusCode.getStatusCode()).setMessage(customStatusCode.getMessage()).setDescription(Strings.isNullOrEmpty((String)message) ? customStatusCode.getMessage() : message)).toString()).build();
    }

    @POST
    @Path(value="/access-request/{strategyId}/{offerId}/{dataType}/{uid}")
    @Produces(value={"application/json"})
    public Response createAccessRequest(@HeaderParam(value="X-Tenant-Id") String xTenantId, @PathParam(value="strategyId") String strategyId, @PathParam(value="offerId") String offerId, @PathParam(value="dataType") String dataType, @PathParam(value="uid") String uid) {
        VitamThreadUtils.getVitamSession().setTenantId(Integer.valueOf(Integer.parseInt(xTenantId)));
        try {
            return this.storageService.createAccessRequest(Integer.parseInt(xTenantId), strategyId, offerId, uid, DataCategory.valueOf((String)dataType)).toResponse();
        }
        catch (StorageNotFoundException | StorageTechnicalException e) {
            LOGGER.error(INTERNAL_SERVER_ERROR_MSG, e);
            return this.buildError(VitamCode.STORAGE_TECHNICAL_INTERNAL_ERROR, e.getMessage()).toResponse();
        }
    }

    @GET
    @Path(value="/access-request/{strategyId}/{offerId}/{accessRequestId}")
    @Consumes(value={"application/json"})
    public Response checkAccessRequestStatus(@HeaderParam(value="X-Tenant-Id") String xTenantId, @PathParam(value="strategyId") String strategyId, @PathParam(value="offerId") String offerId, @PathParam(value="accessRequestId") String accessRequestId) {
        VitamThreadUtils.getVitamSession().setTenantId(Integer.valueOf(Integer.parseInt(xTenantId)));
        try {
            return this.storageService.checkAccessRequestStatus(Integer.parseInt(xTenantId), strategyId, offerId, accessRequestId).toResponse();
        }
        catch (StorageNotFoundException | StorageTechnicalException e) {
            LOGGER.error(INTERNAL_SERVER_ERROR_MSG, e);
            return this.buildError(VitamCode.STORAGE_TECHNICAL_INTERNAL_ERROR, e.getMessage()).toResponse();
        }
    }

    @DELETE
    @Path(value="/access-request/{strategyId}/{offerId}/{accessRequestId}")
    @Consumes(value={"application/json"})
    public Response removeAccessRequest(@HeaderParam(value="X-Tenant-Id") String xTenantId, @PathParam(value="strategyId") String strategyId, @PathParam(value="offerId") String offerId, @PathParam(value="accessRequestId") String accessRequestId) {
        VitamThreadUtils.getVitamSession().setTenantId(Integer.valueOf(Integer.parseInt(xTenantId)));
        try {
            RequestResponse<AccessRequestStatus> readOrderRequest = this.storageService.removeAccessRequest(Integer.parseInt(xTenantId), strategyId, offerId, accessRequestId);
            return readOrderRequest.toResponse();
        }
        catch (StorageNotFoundException | StorageTechnicalException e) {
            LOGGER.error(INTERNAL_SERVER_ERROR_MSG, e);
            return this.buildError(VitamCode.STORAGE_TECHNICAL_INTERNAL_ERROR, e.getMessage()).toResponse();
        }
    }

    @GET
    @Path(value="/messages/logbook")
    @Produces(value={"application/json"})
    public Response getLogbookMessages() {
        return Response.status((Response.Status)Response.Status.OK).entity((Object)VitamLogbookMessages.getAllMessages()).build();
    }

    @POST
    @Path(value="login")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response login(@Context HttpServletRequest httpRequest, JsonNode object) {
        Subject subject = ThreadContext.getSubject();
        String username = object.get("token").get("principal").textValue();
        String password = object.get("token").get("credentials").textValue();
        if (username == null || password == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        UsernamePasswordToken token = new UsernamePasswordToken(username, password);
        String tokenCSRF = XSRFHelper.generateCSRFToken();
        XSRFFilter.addToken((String)httpRequest.getSession().getId(), (String)tokenCSRF);
        try {
            subject.login((AuthenticationToken)token);
            LOGGER.info("Login success: " + username);
        }
        catch (Exception uae) {
            LOGGER.debug("Login fail: " + username);
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        return Response.status((Response.Status)Response.Status.OK).entity((Object)new LoginModel(tokenCSRF)).build();
    }

    @GET
    @Path(value="/securemode")
    @Produces(value={"application/json"})
    public Response getSecureMode() {
        return Response.status((Response.Status)Response.Status.OK).entity(this.secureMode).build();
    }

    @POST
    @Path(value="/operations/traceability")
    @Produces(value={"application/json"})
    public Response traceability(@HeaderParam(value="X-Tenant-Id") String xTenantId) throws LogbookClientServerException {
        Response response;
        block8: {
            LogbookOperationsClient logbookOperationsClient = LogbookOperationsClientFactory.getInstance().getClient();
            try {
                VitamThreadUtils.getVitamSession().setTenantId(VitamConfiguration.getAdminTenant());
                RequestResponseOK result = logbookOperationsClient.traceability(Collections.singletonList(Integer.parseInt(xTenantId)));
                response = Response.status((Response.Status)Response.Status.OK).entity((Object)result).build();
                if (logbookOperationsClient == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (logbookOperationsClient != null) {
                        try {
                            logbookOperationsClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InvalidParseOperationException e) {
                    LOGGER.error("The reporting json can't be created", (Throwable)e);
                    return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
                }
            }
            logbookOperationsClient.close();
        }
        return response;
    }

    @POST
    @Path(value="/lifecycles/units/traceability")
    @Produces(value={"application/json"})
    public Response traceabilityLfcUnit(@HeaderParam(value="X-Tenant-Id") String xTenantId) throws LogbookClientServerException {
        LogbookOperationsClient logbookOperationsClient = LogbookOperationsClientFactory.getInstance().getClient();
        try {
            RequestResponseOK result;
            try {
                VitamThreadUtils.getVitamSession().setTenantId(Integer.valueOf(Integer.parseInt(xTenantId)));
                result = logbookOperationsClient.traceabilityLfcUnit();
            }
            catch (InvalidParseOperationException e) {
                LOGGER.error("The reporting json can't be created", (Throwable)e);
                Response response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
                if (logbookOperationsClient != null) {
                    logbookOperationsClient.close();
                }
                return response;
            }
            Response response = Response.status((Response.Status)Response.Status.OK).entity((Object)result).build();
            return response;
        }
        finally {
            if (logbookOperationsClient != null) {
                try {
                    logbookOperationsClient.close();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    throwable2.addSuppressed(throwable);
                }
            }
        }
    }

    @POST
    @Path(value="/lifecycles/objectgroups/traceability")
    @Produces(value={"application/json"})
    public Response traceabilityLfcObjectGroup(@HeaderParam(value="X-Tenant-Id") String xTenantId) throws LogbookClientServerException {
        LogbookOperationsClient logbookOperationsClient = LogbookOperationsClientFactory.getInstance().getClient();
        try {
            RequestResponseOK result;
            try {
                VitamThreadUtils.getVitamSession().setTenantId(Integer.valueOf(Integer.parseInt(xTenantId)));
                result = logbookOperationsClient.traceabilityLfcObjectGroup();
            }
            catch (InvalidParseOperationException e) {
                LOGGER.error("The reporting json can't be created", (Throwable)e);
                Response response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
                if (logbookOperationsClient != null) {
                    logbookOperationsClient.close();
                }
                return response;
            }
            Response response = Response.status((Response.Status)Response.Status.OK).entity((Object)result).build();
            return response;
        }
        finally {
            if (logbookOperationsClient != null) {
                try {
                    logbookOperationsClient.close();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    throwable2.addSuppressed(throwable);
                }
            }
        }
    }

    @POST
    @Path(value="/storages/traceability")
    @Produces(value={"application/json"})
    public Response traceabilityStorage(@HeaderParam(value="X-Tenant-Id") String xTenantId) {
        StorageClient storageClient = StorageClientFactory.getInstance().getClient();
        try {
            RequestResponseOK result;
            try {
                VitamThreadUtils.getVitamSession().setTenantId(VitamConfiguration.getAdminTenant());
                result = storageClient.storageLogTraceability(Collections.singletonList(Integer.parseInt(xTenantId)));
            }
            catch (InvalidParseOperationException | StorageServerClientException e) {
                LOGGER.error("The reporting json can't be created", e);
                Response response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
                if (storageClient != null) {
                    storageClient.close();
                }
                return response;
            }
            Response response = Response.status((Response.Status)Response.Status.OK).entity((Object)result).build();
            return response;
        }
        finally {
            if (storageClient != null) {
                try {
                    storageClient.close();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    throwable2.addSuppressed(throwable);
                }
            }
        }
    }

    @POST
    @Path(value="storages/storagelogbackup")
    @Produces(value={"application/json"})
    public Response storageLogBackup(@HeaderParam(value="X-Tenant-Id") String xTenantId) {
        StorageClient storageClient = StorageClientFactory.getInstance().getClient();
        try {
            RequestResponseOK result;
            try {
                VitamThreadUtils.getVitamSession().setTenantId(VitamConfiguration.getAdminTenant());
                result = storageClient.storageLogBackup(VitamConfiguration.getTenants());
            }
            catch (InvalidParseOperationException | StorageServerClientException e) {
                LOGGER.error("The reporting json can't be created", e);
                Response response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
                if (storageClient != null) {
                    storageClient.close();
                }
                return response;
            }
            Response response = Response.status((Response.Status)Response.Status.OK).entity((Object)result).build();
            return response;
        }
        finally {
            if (storageClient != null) {
                try {
                    storageClient.close();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    throwable2.addSuppressed(throwable);
                }
            }
        }
    }

    @POST
    @Path(value="/logbooks")
    @Produces(value={"application/json"})
    public Response getLogbookResultByBrowser(@Context HttpServletRequest request, @HeaderParam(value="X-Http-Method-Override") String xhttpOverride, @CookieParam(value="JSESSIONID") String sessionId, String options) {
        if (!HTTP_GET.equalsIgnoreCase(xhttpOverride)) {
            Response.Status status = Response.Status.PRECONDITION_FAILED;
            VitamError vitamError = new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(IHM_RECETTE).setMessage(status.getReasonPhrase()).setDescription(status.getReasonPhrase());
            return Response.status((Response.Status)status).entity((Object)vitamError).build();
        }
        return this.findLogbookBy(request, sessionId, options);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @POST
    @Path(value="/updateLinks")
    @Produces(value={"application/json"})
    public Response updateLinksBetweenAU(@Context HttpServletRequest request, String select) {
        try {
            Map optionsMap = JsonHandler.getMapFromString((String)select);
            JsonNode query = this.dslQueryHelper.createSelectAndUpdateDSLQuery(optionsMap);
            try (AccessExternalClient accessExternalClient = AccessExternalClientFactory.getInstance().getClient();){
                RequestResponse response = accessExternalClient.reclassification(this.getVitamContext(request), query);
                if (response instanceof RequestResponseOK) {
                    Response response2 = Response.status((Response.Status)Response.Status.OK).entity((Object)response).header(X_REQUEST_ID, (Object)response.getHeaderString(X_REQUEST_ID)).build();
                    return response2;
                }
                if (response instanceof VitamError) {
                    LOGGER.error(response.toString());
                    Response response3 = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)response).build();
                    return response3;
                }
                Response response4 = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
                return response4;
            }
        }
        catch (Exception e) {
            LOGGER.error(INTERNAL_SERVER_ERROR_MSG, (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GET
    @Path(value="/logbooks")
    @Produces(value={"application/json"})
    public Response getLogbookResult(@Context HttpServletRequest request, @CookieParam(value="JSESSIONID") String sessionId, String options) {
        return this.findLogbookBy(request, sessionId, options);
    }

    private Response findLogbookBy(@Context HttpServletRequest request, @CookieParam(value="JSESSIONID") String sessionId, String options) {
        RequestResponse result;
        OffsetBasedPagination pagination;
        ParametersChecker.checkParameter((String)"cookie is mandatory", (String[])new String[]{sessionId});
        String xTenantId = request.getHeader("X-Tenant-Id");
        if (Strings.isNullOrEmpty((String)xTenantId)) {
            LOGGER.error(MISSING_THE_TENANT_ID_X_TENANT_ID);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        int tenantId = Integer.parseInt(xTenantId);
        try {
            Enumeration headersReqId = request.getHeaders(IhmWebAppHeader.REQUEST_ID.name());
            while (headersReqId.hasMoreElements()) {
                SanityChecker.checkParameter((String[])new String[]{(String)headersReqId.nextElement()});
            }
            pagination = new OffsetBasedPagination(request);
        }
        catch (VitamException e) {
            LOGGER.error("Bad request Exception ", (Throwable)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        ArrayList requestIds = Collections.list(request.getHeaders(IhmWebAppHeader.REQUEST_ID.name()));
        if (!requestIds.isEmpty()) {
            String requestId = (String)requestIds.get(0);
            try {
                RequestResponseOK result2 = RequestResponseOK.getFromJsonNode((JsonNode)this.paginationHelper.getResult(sessionId, pagination), LogbookOperation.class);
                return Response.status((Response.Status)Response.Status.OK).entity((Object)result2).header(X_REQUEST_ID, (Object)requestId).header("X-Offset", (Object)pagination.getOffset()).header("X-Limit", (Object)pagination.getLimit()).build();
            }
            catch (VitamException e) {
                LOGGER.error("Bad request Exception ", (Throwable)e);
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).header(X_REQUEST_ID, (Object)requestId).build();
            }
        }
        String requestId = GUIDFactory.newRequestIdGUID((int)tenantId).toString();
        try {
            ParametersChecker.checkParameter((String)"Search criteria payload is mandatory", (String[])new String[]{options});
            SanityChecker.checkJsonAll((JsonNode)JsonHandler.toJsonNode((Object)options));
            Map optionsMap = JsonHandler.getMapFromString((String)options);
            JsonNode query = this.dslQueryHelper.createSingleQueryDSL(optionsMap);
            LOGGER.debug("query >>>>>>>>>>>>>>>>> : " + String.valueOf(query));
            result = this.userInterfaceTransactionManager.selectOperation(query, this.userInterfaceTransactionManager.getVitamContext(request));
            LOGGER.debug("resultr <<<<<<<<<<<<<<<<<<<<<<<: " + String.valueOf(result));
            this.paginationHelper.setResult(sessionId, result.toJsonNode());
            result = RequestResponseOK.getFromJsonNode((JsonNode)this.paginationHelper.getResult(result.toJsonNode(), pagination), LogbookOperation.class);
        }
        catch (InvalidCreateOperationException | InvalidParseOperationException e) {
            LOGGER.error("Bad request Exception ", e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).header(X_REQUEST_ID, (Object)requestId).build();
        }
        catch (LogbookClientException e) {
            LOGGER.error("Logbook Client NOT FOUND Exception ", (Throwable)e);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).header(X_REQUEST_ID, (Object)requestId).build();
        }
        catch (Exception e) {
            LOGGER.error("Internal server error", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).header(X_REQUEST_ID, (Object)requestId).build();
        }
        return Response.status((Response.Status)Response.Status.OK).entity((Object)result).header(X_REQUEST_ID, (Object)requestId).header("X-Offset", (Object)pagination.getOffset()).header("X-Limit", (Object)pagination.getLimit()).build();
    }

    @GET
    @Path(value="/logbooks/{idOperation}")
    @Produces(value={"application/json"})
    public Response getLogbookResultById(@PathParam(value="idOperation") String operationId, @HeaderParam(value="X-Tenant-Id") String xTenantId) {
        try {
            if (Strings.isNullOrEmpty((String)xTenantId)) {
                LOGGER.error(MISSING_THE_TENANT_ID_X_TENANT_ID);
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            int tenantId = Integer.parseInt(xTenantId);
            VitamContext context = new VitamContext(Integer.valueOf(tenantId));
            context.setAccessContract(DEFAULT_CONTRACT_NAME).setApplicationSessionId(WebApplicationResource.getAppSessionId());
            RequestResponse result = this.userInterfaceTransactionManager.selectOperationbyId(operationId, context);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)result).build();
        }
        catch (IllegalArgumentException e) {
            LOGGER.error((Throwable)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
        catch (VitamClientException e) {
            LOGGER.error("Vitam Client NOT FOUND Exception ", (Throwable)e);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (Exception e) {
            LOGGER.error(INTERNAL_SERVER_ERROR_MSG, (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GET
    @Path(value="/logbooks/{idOperation}")
    @Produces(value={"application/octet-stream"})
    public void downloadObjectAsStream(@PathParam(value="idOperation") String operationId, @Suspended AsyncResponse asyncResponse, @QueryParam(value="X-Tenant-Id") String xTenantId) {
        if (Strings.isNullOrEmpty((String)xTenantId)) {
            LOGGER.error(MISSING_THE_TENANT_ID_X_TENANT_ID);
            AsyncInputStreamHelper.asyncResponseResume((AsyncResponse)asyncResponse, (Response)Response.status((Response.Status)Response.Status.BAD_REQUEST).build());
        }
        this.threadPoolExecutor.execute(() -> this.downloadObjectAsync(asyncResponse, operationId, Integer.parseInt(xTenantId)));
    }

    @GET
    @Path(value="/logbooks/{idOperation}/content")
    @Produces(value={"application/octet-stream"})
    public void downloadObjectAsStreamForBrowser(@PathParam(value="idOperation") String operationId, @Suspended AsyncResponse asyncResponse, @QueryParam(value="X-Tenant-Id") Integer tenantId) {
        this.threadPoolExecutor.execute(() -> this.downloadObjectAsync(asyncResponse, operationId, tenantId));
    }

    /*
     * Exception decompiling
     */
    private void downloadObjectAsync(AsyncResponse asyncResponse, String operationId, int tenantId) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @POST
    @Path(value="/accesscontracts")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response findAccessContract(@Context HttpServletRequest request, String select) {
        try {
            Map optionsMap = JsonHandler.getMapFromString((String)select);
            JsonNode query = this.dslQueryHelper.createSingleQueryDSL(optionsMap);
            try (AdminExternalClient adminClient = AdminExternalClientFactory.getInstance().getClient();){
                RequestResponse response = adminClient.findAccessContracts(this.getVitamContext(request), query);
                if (response instanceof RequestResponseOK) {
                    Response response2 = Response.status((Response.Status)Response.Status.OK).entity((Object)response).build();
                    return response2;
                }
                if (response instanceof VitamError) {
                    LOGGER.error(response.toString());
                    Response response3 = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)response).build();
                    return response3;
                }
                Response response4 = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
                return response4;
            }
        }
        catch (Exception e) {
            LOGGER.error(INTERNAL_SERVER_ERROR_MSG, (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @POST
    @Path(value="/dslQueryTest")
    @Produces(value={"application/json"})
    public Response getAndExecuteTestRequest(@Context HttpServletRequest request, @CookieParam(value="JSESSIONID") String sessionId, JsonNode criteria) {
        OffsetBasedPagination pagination;
        String requestMethod = request.getHeader("X-Http-Method-Override");
        String requestedCollection = request.getHeader(X_REQUESTED_COLLECTION);
        String objectID = request.getHeader(X_OBJECT_ID);
        String xAction = request.getHeader("X-ACTION");
        try {
            pagination = new OffsetBasedPagination(request);
            Enumeration headersReqId = request.getHeaders(IhmWebAppHeader.REQUEST_ID.name());
            while (headersReqId.hasMoreElements()) {
                SanityChecker.checkParameter((String[])new String[]{(String)headersReqId.nextElement()});
            }
        }
        catch (VitamException e) {
            LOGGER.error("Bad request Exception ", (Throwable)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        ArrayList requestIds = Collections.list(request.getHeaders(IhmWebAppHeader.REQUEST_ID.name()));
        if (!requestIds.isEmpty()) {
            String requestId = (String)requestIds.get(0);
            try {
                RequestResponseOK result = RequestResponseOK.getFromJsonNode((JsonNode)this.paginationHelper.getResult(sessionId, pagination));
                return Response.status((Response.Status)Response.Status.OK).entity((Object)result).header(X_REQUEST_ID, (Object)requestId).header("X-Offset", (Object)pagination.getOffset()).header("X-Limit", (Object)pagination.getLimit()).build();
            }
            catch (VitamException e) {
                LOGGER.error("Bad request Exception ", (Throwable)e);
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).header(X_REQUEST_ID, (Object)requestId).build();
            }
        }
        try {
            RequestResponse result;
            AdminCollections requestedAdminCollection = this.existsInAdminCollections(requestedCollection);
            if (requestedCollection != null && requestedAdminCollection == null) {
                if (!requestedCollection.equalsIgnoreCase(WORKFLOW_OPERATIONS) && !requestedCollection.equalsIgnoreCase(WORKFLOWS)) {
                    try (AccessExternalClient client = AccessExternalClientFactory.getInstance().getClient();){
                        if (requestedCollection.equalsIgnoreCase(UNIT_COLLECTION)) {
                            switch (requestMethod) {
                                case "GET": {
                                    if (StringUtils.isBlank((CharSequence)objectID)) {
                                        result = client.selectUnits(this.getVitamContext(request), criteria);
                                        return Response.status((Response.Status)Response.Status.OK).entity((Object)result).build();
                                    }
                                    result = client.selectUnitbyId(this.getVitamContext(request), criteria, objectID);
                                    return Response.status((Response.Status)Response.Status.OK).entity((Object)result).build();
                                }
                                case "PUT": {
                                    if (StringUtils.isNotBlank((CharSequence)objectID)) {
                                        result = client.updateUnitbyId(this.getVitamContext(request), criteria, objectID);
                                        return Response.status((Response.Status)Response.Status.OK).entity((Object)result).build();
                                    }
                                    if (criteria.get(RULE_ACTIONS) != null) {
                                        result = client.massUpdateUnitsRules(this.getVitamContext(request), criteria);
                                        return Response.status((Response.Status)Response.Status.OK).entity((Object)result).build();
                                    }
                                    result = client.massUpdateUnits(this.getVitamContext(request), criteria);
                                    return Response.status((Response.Status)Response.Status.OK).entity((Object)result).build();
                                }
                            }
                            throw new UnsupportedOperationException("Request method undefined for collection " + requestedCollection);
                        }
                        if (requestedCollection.equalsIgnoreCase(LOGBOOK_COLLECTION)) {
                            switch (requestMethod) {
                                case "GET": {
                                    if (StringUtils.isBlank((CharSequence)objectID)) {
                                        result = client.selectOperations(this.getVitamContext(request), criteria);
                                        return Response.status((Response.Status)Response.Status.OK).entity((Object)result).build();
                                    }
                                    result = client.selectOperationbyId(this.getVitamContext(request), objectID, criteria);
                                    return Response.status((Response.Status)Response.Status.OK).entity((Object)result).build();
                                }
                            }
                            throw new UnsupportedOperationException("Request method undefined for collection " + requestedCollection);
                        }
                        if (requestedCollection.equalsIgnoreCase(OBJECT_GROUP_COLLECTION)) {
                            switch (requestMethod) {
                                case "GET": {
                                    if (StringUtils.isBlank((CharSequence)objectID)) {
                                        result = client.selectObjects(this.getVitamContext(request), criteria);
                                        return Response.status((Response.Status)Response.Status.OK).entity((Object)result).build();
                                    }
                                    result = client.selectObjectMetadatasByUnitId(this.getVitamContext(request), criteria, objectID);
                                    if (result == null) return Response.status((Response.Status)Response.Status.OK).entity((Object)result).build();
                                    Response response = Response.status((Response.Status)Response.Status.OK).entity((Object)result.toJsonNode()).build();
                                    return response;
                                }
                            }
                            throw new UnsupportedOperationException("Request method undefined for collection " + requestedCollection);
                        }
                        if (requestedCollection.equalsIgnoreCase(UNIT_LIFECYCLES)) {
                            switch (requestMethod) {
                                case "GET": {
                                    result = client.selectUnitLifeCycleById(this.getVitamContext(request), objectID, criteria);
                                    return Response.status((Response.Status)Response.Status.OK).entity((Object)result).build();
                                }
                            }
                            throw new UnsupportedOperationException("Request method undefined for collection " + requestedCollection);
                        }
                        if (!requestedCollection.equalsIgnoreCase(OBJECT_GROUP_LIFECYCLES)) throw new UnsupportedOperationException("Collection unrecognized");
                        switch (requestMethod) {
                            case "GET": {
                                result = client.selectObjectGroupLifeCycleById(this.getVitamContext(request), objectID, criteria);
                                return Response.status((Response.Status)Response.Status.OK).entity((Object)result).build();
                            }
                        }
                        throw new UnsupportedOperationException("Request method undefined for collection " + requestedCollection);
                    }
                }
                try (AdminExternalClient adminExternalClient = AdminExternalClientFactory.getInstance().getClient();){
                    if (requestedCollection.equalsIgnoreCase(WORKFLOW_OPERATIONS)) {
                        switch (requestMethod) {
                            case "GET": {
                                RequestResponse result2;
                                if (!StringUtils.isBlank((CharSequence)objectID)) {
                                    RequestResponse result3 = adminExternalClient.getOperationProcessExecutionDetails(this.getVitamContext(request), objectID);
                                    Response response = result3.toResponse();
                                    return response;
                                }
                                if (criteria != null) {
                                    LOGGER.error("criteria not null");
                                    result2 = adminExternalClient.listOperationsDetails(this.getVitamContext(request), (ProcessQuery)JsonHandler.getFromJsonNode((JsonNode)criteria, ProcessQuery.class));
                                } else {
                                    LOGGER.error("criteria null");
                                    result2 = adminExternalClient.listOperationsDetails(this.getVitamContext(request), null);
                                }
                                Response response = Response.status((Response.Status)Response.Status.OK).entity((Object)result2).build();
                                return response;
                            }
                            case "PUT": {
                                if (StringUtils.isBlank((CharSequence)objectID)) throw new InvalidParseOperationException("Operation ID should be filled");
                                adminExternalClient.updateOperationActionProcess(this.getVitamContext(request), xAction, objectID);
                                RequestResponse result4 = adminExternalClient.getOperationProcessExecutionDetails(this.getVitamContext(request), objectID);
                                Response response = result4.toResponse();
                                return response;
                            }
                            case "DELETE": {
                                if (StringUtils.isBlank((CharSequence)objectID)) throw new InvalidParseOperationException("Operation ID should be filled");
                                RequestResponse result5 = adminExternalClient.cancelOperationProcessExecution(this.getVitamContext(request), objectID);
                                Response response = result5.toResponse();
                                return response;
                            }
                        }
                        throw new UnsupportedOperationException("Request method undefined for collection " + requestedCollection);
                    }
                    if (!requestedCollection.equalsIgnoreCase(WORKFLOWS)) throw new UnsupportedOperationException("No implementation found for collection " + requestedCollection);
                    switch (requestMethod) {
                        case "GET": {
                            RequestResponse result6 = adminExternalClient.getWorkflowDefinitions(this.getVitamContext(request));
                            Response response = Response.status((Response.Status)Response.Status.OK).entity((Object)result6).build();
                            return response;
                        }
                    }
                    throw new UnsupportedOperationException("Request method undefined for collection " + requestedCollection);
                }
            }
            requestedAdminCollection = AdminCollections.valueOf((String)requestedCollection);
            try (AdminExternalClient adminExternalClient = AdminExternalClientFactory.getInstance().getClient();){
                switch (requestMethod) {
                    case "GET": {
                        if (StringUtils.isBlank((CharSequence)objectID)) {
                            switch (requestedAdminCollection) {
                                case FORMATS: {
                                    result = adminExternalClient.findFormats(this.getVitamContext(request), criteria);
                                    return Response.status((Response.Status)Response.Status.OK).entity((Object)result).build();
                                }
                                case RULES: {
                                    result = adminExternalClient.findRules(this.getVitamContext(request), criteria);
                                    return Response.status((Response.Status)Response.Status.OK).entity((Object)result).build();
                                }
                                case ACCESS_CONTRACTS: {
                                    result = adminExternalClient.findAccessContracts(this.getVitamContext(request), criteria);
                                    return Response.status((Response.Status)Response.Status.OK).entity((Object)result).build();
                                }
                                case INGEST_CONTRACTS: {
                                    result = adminExternalClient.findIngestContracts(this.getVitamContext(request), criteria);
                                    return Response.status((Response.Status)Response.Status.OK).entity((Object)result).build();
                                }
                                case MANAGEMENT_CONTRACTS: {
                                    result = adminExternalClient.findManagementContracts(this.getVitamContext(request), criteria);
                                    return Response.status((Response.Status)Response.Status.OK).entity((Object)result).build();
                                }
                                case CONTEXTS: {
                                    result = adminExternalClient.findContexts(this.getVitamContext(request), criteria);
                                    return Response.status((Response.Status)Response.Status.OK).entity((Object)result).build();
                                }
                                case PROFILE: {
                                    result = adminExternalClient.findProfiles(this.getVitamContext(request), criteria);
                                    return Response.status((Response.Status)Response.Status.OK).entity((Object)result).build();
                                }
                                case ACCESSION_REGISTERS: {
                                    result = adminExternalClient.findAccessionRegister(this.getVitamContext(request), criteria);
                                    return Response.status((Response.Status)Response.Status.OK).entity((Object)result).build();
                                }
                                case AGENCIES: {
                                    result = adminExternalClient.findAgencies(this.getVitamContext(request), criteria);
                                    return Response.status((Response.Status)Response.Status.OK).entity((Object)result).build();
                                }
                            }
                            throw new UnsupportedOperationException("No implementation found for collection " + requestedCollection);
                        }
                        if (AdminCollections.ACCESSION_REGISTERS.equals((Object)requestedAdminCollection)) {
                            result = adminExternalClient.getAccessionRegisterDetail(this.getVitamContext(request), objectID, criteria);
                            return Response.status((Response.Status)Response.Status.OK).entity((Object)result).build();
                        }
                        switch (requestedAdminCollection) {
                            case FORMATS: {
                                result = adminExternalClient.findFormatById(this.getVitamContext(request), objectID);
                                return Response.status((Response.Status)Response.Status.OK).entity((Object)result).build();
                            }
                            case RULES: {
                                result = adminExternalClient.findRuleById(this.getVitamContext(request), objectID);
                                return Response.status((Response.Status)Response.Status.OK).entity((Object)result).build();
                            }
                            case ACCESS_CONTRACTS: {
                                result = adminExternalClient.findAccessContractById(this.getVitamContext(request), objectID);
                                return Response.status((Response.Status)Response.Status.OK).entity((Object)result).build();
                            }
                            case INGEST_CONTRACTS: {
                                result = adminExternalClient.findIngestContractById(this.getVitamContext(request), objectID);
                                return Response.status((Response.Status)Response.Status.OK).entity((Object)result).build();
                            }
                            case MANAGEMENT_CONTRACTS: {
                                result = adminExternalClient.findManagementContractById(this.getVitamContext(request), objectID);
                                return Response.status((Response.Status)Response.Status.OK).entity((Object)result).build();
                            }
                            case CONTEXTS: {
                                result = adminExternalClient.findContextById(this.getVitamContext(request), objectID);
                                return Response.status((Response.Status)Response.Status.OK).entity((Object)result).build();
                            }
                            case PROFILE: {
                                result = adminExternalClient.findProfileById(this.getVitamContext(request), objectID);
                                return Response.status((Response.Status)Response.Status.OK).entity((Object)result).build();
                            }
                            case AGENCIES: {
                                result = adminExternalClient.findAgencyByID(this.getVitamContext(request), objectID);
                                return Response.status((Response.Status)Response.Status.OK).entity((Object)result).build();
                            }
                        }
                        throw new UnsupportedOperationException("No implementation found for collection " + requestedCollection);
                    }
                    case "PUT": {
                        if (StringUtils.isBlank((CharSequence)objectID)) throw new InvalidParseOperationException("Unit ID should be filled.");
                        if (AdminCollections.CONTEXTS.equals((Object)requestedAdminCollection)) {
                            result = adminExternalClient.updateContext(this.getVitamContext(request), objectID, criteria);
                            return Response.status((Response.Status)Response.Status.OK).entity((Object)result).build();
                        }
                        if (AdminCollections.ACCESS_CONTRACTS.equals((Object)requestedAdminCollection)) {
                            result = adminExternalClient.updateAccessContract(this.getVitamContext(request), objectID, criteria);
                            return Response.status((Response.Status)Response.Status.OK).entity((Object)result).build();
                        }
                        if (AdminCollections.INGEST_CONTRACTS.equals((Object)requestedAdminCollection)) {
                            result = adminExternalClient.updateIngestContract(this.getVitamContext(request), objectID, criteria);
                            return Response.status((Response.Status)Response.Status.OK).entity((Object)result).build();
                        }
                        if (AdminCollections.MANAGEMENT_CONTRACTS.equals((Object)requestedAdminCollection)) {
                            result = adminExternalClient.updateManagementContract(this.getVitamContext(request), objectID, criteria);
                            return Response.status((Response.Status)Response.Status.OK).entity((Object)result).build();
                        }
                        if (AdminCollections.PROFILE.equals((Object)requestedAdminCollection)) {
                            result = adminExternalClient.updateProfile(this.getVitamContext(request), objectID, criteria);
                            return Response.status((Response.Status)Response.Status.OK).entity((Object)result).build();
                        }
                        if (!AdminCollections.SECURITY_PROFILES.equals((Object)requestedAdminCollection)) throw new UnsupportedOperationException("Request method undefined for collection " + requestedCollection);
                        result = adminExternalClient.updateSecurityProfile(this.getVitamContext(request), objectID, criteria);
                        return Response.status((Response.Status)Response.Status.OK).entity((Object)result).build();
                    }
                }
                throw new UnsupportedOperationException("Request method undefined for collection " + requestedCollection);
            }
        }
        catch (InvalidParseOperationException | IllegalArgumentException e) {
            LOGGER.error(BAD_REQUEST_EXCEPTION_MSG, e);
            VitamError vitamError = new VitamError(VitamCode.GLOBAL_EMPTY_QUERY.getItem()).setHttpCode(Response.Status.BAD_REQUEST.getStatusCode()).setContext(IHM_RECETTE).setState(StatusCode.KO.name()).setMessage(Response.Status.BAD_REQUEST.getReasonPhrase()).setDescription(e.getMessage());
            return vitamError.toResponse();
        }
        catch (AccessExternalClientServerException e) {
            LOGGER.error(ACCESS_SERVER_EXCEPTION_MSG, (Throwable)e);
            VitamError vitamError = new VitamError(VitamCode.ACCESS_EXTERNAL_SERVER_ERROR.getItem()).setHttpCode(VitamCode.ACCESS_EXTERNAL_SERVER_ERROR.getStatus().getStatusCode()).setContext(ACCESS_EXTERNAL_MODULE).setState(StatusCode.KO.name()).setMessage(VitamCode.ACCESS_EXTERNAL_SERVER_ERROR.getMessage()).setDescription(e.getMessage());
            return vitamError.toResponse();
        }
        catch (AccessExternalClientNotFoundException e) {
            LOGGER.error(ACCESS_CLIENT_NOT_FOUND_EXCEPTION_MSG, (Throwable)e);
            VitamError vitamError = new VitamError(VitamCode.ACCESS_EXTERNAL_CLIENT_ERROR.getItem()).setHttpCode(VitamCode.ACCESS_EXTERNAL_CLIENT_ERROR.getStatus().getStatusCode()).setContext(ACCESS_EXTERNAL_MODULE).setState(StatusCode.KO.name()).setMessage(VitamCode.ACCESS_EXTERNAL_CLIENT_ERROR.getMessage()).setDescription(e.getMessage());
            return vitamError.toResponse();
        }
        catch (AccessUnauthorizedException e) {
            LOGGER.error(ACCESS_SERVER_EXCEPTION_MSG, (Throwable)e);
            VitamError vitamError = new VitamError(VitamCode.ACCESS_EXTERNAL_CLIENT_ERROR.getItem()).setHttpCode(Response.Status.UNAUTHORIZED.getStatusCode()).setContext(ACCESS_EXTERNAL_MODULE).setState(Response.Status.UNAUTHORIZED.name()).setMessage(Response.Status.UNAUTHORIZED.getReasonPhrase()).setDescription(e.getMessage());
            return vitamError.toResponse();
        }
        catch (Exception e) {
            LOGGER.error(INTERNAL_SERVER_ERROR_MSG, (Throwable)e);
            VitamError vitamError = new VitamError(VitamCode.GLOBAL_INTERNAL_SERVER_ERROR.getItem()).setHttpCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).setContext(IHM_RECETTE).setState(StatusCode.KO.name()).setMessage(Response.Status.INTERNAL_SERVER_ERROR.getReasonPhrase()).setDescription(e.getMessage());
            return vitamError.toResponse();
        }
    }

    private Integer getTenantId(HttpServletRequest request) {
        int tenantId = 0;
        String tenantIdHeader = request.getHeader("X-Tenant-Id");
        if (tenantIdHeader != null) {
            try {
                tenantId = Integer.parseInt(tenantIdHeader);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return tenantId;
    }

    private String getContractId(HttpServletRequest request) {
        return request.getHeader("X-Access-Contract-Id");
    }

    private AdminCollections existsInAdminCollections(String valueToCheck) {
        try {
            return AdminCollections.valueOf((String)valueToCheck);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private VitamContext getVitamContext(HttpServletRequest request) {
        return new VitamContext(this.getTenantId(request)).setAccessContract(this.getContractId(request)).setApplicationSessionId(WebApplicationResource.getAppSessionId()).setPersonalCertificate(this.getPersonalCertificate(request));
    }

    private String getPersonalCertificate(HttpServletRequest request) {
        return (String)request.getAttribute("Personae");
    }
}

