/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.logbook.lifecycles.client;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.ServerIdentity;
import fr.gouv.vitam.common.client.DefaultClient;
import fr.gouv.vitam.common.client.VitamClientFactoryInterface;
import fr.gouv.vitam.common.client.VitamRequestBuilder;
import fr.gouv.vitam.common.collection.CloseableIterator;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.PreconditionFailedClientException;
import fr.gouv.vitam.common.exception.VitamClientInternalException;
import fr.gouv.vitam.common.exception.VitamRuntimeException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.model.JsonLineIterator;
import fr.gouv.vitam.common.model.LifeCycleStatusCode;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.logbook.LogbookOperation;
import fr.gouv.vitam.common.model.processing.DistributionType;
import fr.gouv.vitam.common.server.application.VitamHttpHeader;
import fr.gouv.vitam.common.stream.ExactSizeInputStream;
import fr.gouv.vitam.logbook.common.client.ErrorMessage;
import fr.gouv.vitam.logbook.common.exception.LogbookClientAlreadyExistsException;
import fr.gouv.vitam.logbook.common.exception.LogbookClientBadRequestException;
import fr.gouv.vitam.logbook.common.exception.LogbookClientException;
import fr.gouv.vitam.logbook.common.exception.LogbookClientNotFoundException;
import fr.gouv.vitam.logbook.common.exception.LogbookClientServerException;
import fr.gouv.vitam.logbook.common.model.LogbookLifeCycleObjectGroupModel;
import fr.gouv.vitam.logbook.common.model.LogbookLifeCycleUnitModel;
import fr.gouv.vitam.logbook.common.model.RawLifecycleByLastPersistedDateRequest;
import fr.gouv.vitam.logbook.common.parameters.LogbookLifeCycleObjectGroupParameters;
import fr.gouv.vitam.logbook.common.parameters.LogbookLifeCycleParameters;
import fr.gouv.vitam.logbook.common.parameters.LogbookLifeCycleParametersBulk;
import fr.gouv.vitam.logbook.common.parameters.LogbookLifeCycleUnitParameters;
import fr.gouv.vitam.logbook.common.parameters.LogbookParameterName;
import fr.gouv.vitam.logbook.lifecycles.client.LogbookLifeCyclesClient;
import fr.gouv.vitam.logbook.lifecycles.client.LogbookLifeCyclesClientFactory;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

class LogbookLifeCyclesClientRest
extends DefaultClient
implements LogbookLifeCyclesClient {
    private static final String REQUEST_PRECONDITION_FAILED = "Request precondition failed";
    private static final String OPERATIONS_URL = "/operations";
    private static final String UNIT_LIFECYCLES_URL = "/unitlifecycles";
    private static final String OBJECT_GROUP_LIFECYCLES_URL = "/objectgrouplifecycles";
    private static final String OBJECT_GROUP_LIFECYCLES_RAW_BULK_URL = "/raw/objectgrouplifecycles/bulk";
    private static final String UNIT_LIFECYCLES_RAW_BULK_URL = "/raw/unitlifecycles/bulk";
    private static final String UNIT_LIFECYCLES_RAW_BY_ID_URL = "/raw/unitlifecycles/byid/";
    private static final String UNIT_LIFECYCLES_RAW_BY_IDS_URL = "/raw/unitlifecycles/byids";
    private static final String OBJECT_GROUP_LIFECYCLES_RAW_BY_ID_URL = "/raw/objectgrouplifecycles/byid/";
    private static final String OBJECT_GROUP_LIFECYCLES_RAW_BY_IDS_URL = "/raw/objectgrouplifecycles/byids";
    private static final String UNIT_LIFECYCLES_RAW_BY_LAST_PERSISTED_DATE_URL = "/raw/unitlifecycles/bylastpersisteddate";
    private static final String OBJECT_GROUP_LIFECYCLES_RAW_BY_LAST_PERSISTED_DATE_URL = "/raw/objectgrouplifecycles/bylastpersisteddate";
    private static final String LAST_LIFE_CYCLE_TRACEABILITY_OPERATION_URL = "/lastLifeCycleTraceabilityOperation";
    private static final ServerIdentity SERVER_IDENTITY = ServerIdentity.getInstance();

    LogbookLifeCyclesClientRest(LogbookLifeCyclesClientFactory factory) {
        super((VitamClientFactoryInterface)factory);
    }

    @Override
    public void create(LogbookLifeCycleParameters parameters) throws LogbookClientBadRequestException, LogbookClientAlreadyExistsException, LogbookClientServerException {
        String eip = parameters.getParameterValue(LogbookParameterName.eventIdentifierProcess);
        String oid = parameters.getParameterValue(LogbookParameterName.objectIdentifier);
        parameters.putParameterValue(LogbookParameterName.agentIdentifier, SERVER_IDENTITY.getJsonIdentity());
        parameters.putParameterValue(LogbookParameterName.eventDateTime, LocalDateUtil.nowFormatted());
        ParametersChecker.checkNullOrEmptyParameters((Map)parameters.getMapParameters(), (Set)parameters.getMandatoriesParameters());
        try (Response response = this.make(VitamRequestBuilder.post().withPath(this.getServiceUrl(parameters, eip, oid)).withJson().withBody((Object)parameters));){
            this.check(response);
        }
        catch (PreconditionFailedClientException | VitamClientInternalException | LogbookClientNotFoundException e) {
            throw new LogbookClientServerException(ErrorMessage.INTERNAL_SERVER_ERROR.getMessage(), e);
        }
    }

    @Override
    public void update(LogbookLifeCycleParameters parameters) throws LogbookClientBadRequestException, LogbookClientNotFoundException, LogbookClientServerException {
        this.update(parameters, null);
    }

    @Override
    public void update(LogbookLifeCycleParameters parameters, LifeCycleStatusCode lifeCycleStatusCode) throws LogbookClientBadRequestException, LogbookClientNotFoundException, LogbookClientServerException {
        parameters.putParameterValue(LogbookParameterName.agentIdentifier, SERVER_IDENTITY.getJsonIdentity());
        if (parameters.getParameterValue(LogbookParameterName.eventDateTime) == null) {
            parameters.putParameterValue(LogbookParameterName.eventDateTime, LocalDateUtil.nowFormatted());
        }
        ParametersChecker.checkNullOrEmptyParameters((Map)parameters.getMapParameters(), (Set)parameters.getMandatoriesParameters());
        String eip = parameters.getParameterValue(LogbookParameterName.eventIdentifierProcess);
        String oid = parameters.getParameterValue(LogbookParameterName.objectIdentifier);
        String lid = parameters.getParameterValue(LogbookParameterName.lifeCycleIdentifier);
        VitamRequestBuilder request = VitamRequestBuilder.put().withPath(this.getServiceUrl(parameters, eip, lid != null ? lid : oid)).withBody((Object)parameters).withJson().withHeaderIgnoreNull("X-Event-Status", (Object)lifeCycleStatusCode);
        try (Response response = this.make(request);){
            this.check(response);
        }
        catch (PreconditionFailedClientException | VitamClientInternalException | LogbookClientAlreadyExistsException e) {
            throw new LogbookClientServerException(ErrorMessage.INTERNAL_SERVER_ERROR.getMessage(), e);
        }
    }

    @Override
    @Deprecated
    public void commit(LogbookLifeCycleParameters parameters) throws LogbookClientBadRequestException, LogbookClientNotFoundException, LogbookClientServerException {
        parameters.putParameterValue(LogbookParameterName.agentIdentifier, SERVER_IDENTITY.getJsonIdentity());
        parameters.putParameterValue(LogbookParameterName.eventDateTime, LocalDateUtil.nowFormatted());
        ParametersChecker.checkNullOrEmptyParameters((Map)parameters.getMapParameters(), (Set)parameters.getMandatoriesParameters());
        String eip = parameters.getParameterValue(LogbookParameterName.eventIdentifierProcess);
        String oid = parameters.getParameterValue(LogbookParameterName.objectIdentifier);
        try (Response response = this.make(VitamRequestBuilder.put().withPath(this.getServiceUrl(parameters, eip, oid) + "/commit").withJsonAccept());){
            this.check(response);
        }
        catch (PreconditionFailedClientException | VitamClientInternalException | LogbookClientAlreadyExistsException e) {
            throw new LogbookClientServerException(ErrorMessage.INTERNAL_SERVER_ERROR.getMessage(), e);
        }
    }

    @Override
    public void rollback(LogbookLifeCycleParameters parameters) throws LogbookClientBadRequestException, LogbookClientNotFoundException, LogbookClientServerException {
        parameters.putParameterValue(LogbookParameterName.agentIdentifier, SERVER_IDENTITY.getJsonIdentity());
        parameters.putParameterValue(LogbookParameterName.eventDateTime, LocalDateUtil.nowFormatted());
        ParametersChecker.checkNullOrEmptyParameters((Map)parameters.getMapParameters(), (Set)parameters.getMandatoriesParameters());
        String eip = parameters.getParameterValue(LogbookParameterName.eventIdentifierProcess);
        String oid = parameters.getParameterValue(LogbookParameterName.objectIdentifier);
        try (Response response = this.make(VitamRequestBuilder.delete().withPath(this.getServiceUrl(parameters, eip, oid)).withJsonAccept());){
            this.check(response);
        }
        catch (PreconditionFailedClientException | VitamClientInternalException | LogbookClientAlreadyExistsException e) {
            throw new LogbookClientNotFoundException(ErrorMessage.LOGBOOK_NOT_FOUND.getMessage(), e);
        }
    }

    @Override
    public JsonNode selectUnitLifeCycleById(String id, JsonNode queryDsl) throws LogbookClientException, InvalidParseOperationException {
        return this.selectUnitLifeCycleById(id, queryDsl, null);
    }

    @Override
    public JsonNode selectUnitLifeCycleById(String id, JsonNode queryDsl, LifeCycleStatusCode lifeCycleStatus) throws LogbookClientException, InvalidParseOperationException {
        JsonNode jsonNode;
        block9: {
            VitamRequestBuilder request = VitamRequestBuilder.get().withPath("/unitlifecycles/" + id).withJson().withBody((Object)queryDsl).withHeaderIgnoreNull("X-Event-Status", (Object)lifeCycleStatus);
            Response response = this.make(request);
            try {
                this.check(response);
                jsonNode = JsonHandler.getFromString((String)((String)response.readEntity(String.class)));
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientInternalException e) {
                    throw new LogbookClientServerException(ErrorMessage.INTERNAL_SERVER_ERROR.getMessage(), (Throwable)e);
                }
                catch (PreconditionFailedClientException e) {
                    throw new LogbookClientException(REQUEST_PRECONDITION_FAILED, (Throwable)e);
                }
            }
            response.close();
        }
        return jsonNode;
    }

    @Override
    public JsonNode selectUnitLifeCycle(JsonNode queryDsl) throws LogbookClientException, InvalidParseOperationException {
        JsonNode jsonNode;
        block9: {
            Response response = this.make(VitamRequestBuilder.get().withPath(UNIT_LIFECYCLES_URL).withJson().withBody((Object)queryDsl, "QueryDSL cannot be null."));
            try {
                this.check(response);
                jsonNode = JsonHandler.getFromString((String)((String)response.readEntity(String.class)));
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (PreconditionFailedClientException e) {
                    throw new LogbookClientException(REQUEST_PRECONDITION_FAILED, (Throwable)e);
                }
                catch (VitamClientInternalException e) {
                    throw new LogbookClientServerException(ErrorMessage.INTERNAL_SERVER_ERROR.getMessage(), (Throwable)e);
                }
            }
            response.close();
        }
        return jsonNode;
    }

    @Override
    public InputStream exportRawUnitLifecyclesByLastPersistedDate(LocalDateTime startDate, LocalDateTime endDate, int maxEntries) throws LogbookClientException, InvalidParseOperationException, IOException {
        return this.exportRawLifecyclesByLastPersistedDate(UNIT_LIFECYCLES_RAW_BY_LAST_PERSISTED_DATE_URL, startDate, endDate, maxEntries);
    }

    @Override
    public InputStream exportRawObjectGroupLifecyclesByLastPersistedDate(LocalDateTime startDate, LocalDateTime endDate, int maxEntries) throws LogbookClientException, InvalidParseOperationException, IOException {
        return this.exportRawLifecyclesByLastPersistedDate(OBJECT_GROUP_LIFECYCLES_RAW_BY_LAST_PERSISTED_DATE_URL, startDate, endDate, maxEntries);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private InputStream exportRawLifecyclesByLastPersistedDate(String uri, LocalDateTime startDate, LocalDateTime endDate, int limit) throws LogbookClientException, InvalidParseOperationException, IOException {
        ExactSizeInputStream exactSizeInputStream;
        block7: {
            RawLifecycleByLastPersistedDateRequest request = new RawLifecycleByLastPersistedDateRequest(LocalDateUtil.getFormattedDateTimeForMongo((LocalDateTime)startDate), LocalDateUtil.getFormattedDateTimeForMongo((LocalDateTime)endDate), limit);
            Response response = null;
            boolean doNotCloseResponse = false;
            try {
                response = this.make(VitamRequestBuilder.post().withPath(uri).withOctetAccept().withJsonContentType().withBody((Object)JsonHandler.toJsonNode((Object)request), "Request cannot be null."));
                this.check(response);
                String contentLengthHeader = response.getHeaderString(VitamHttpHeader.X_CONTENT_LENGTH.getName());
                if (contentLengthHeader == null) {
                    throw new LogbookClientException("Missing " + VitamHttpHeader.X_CONTENT_LENGTH.getName() + " header");
                }
                long contentLength = Long.parseLong(contentLengthHeader);
                doNotCloseResponse = true;
                exactSizeInputStream = new ExactSizeInputStream((InputStream)response.readEntity(InputStream.class), contentLength);
                if (response == null || doNotCloseResponse) break block7;
            }
            catch (PreconditionFailedClientException e) {
                try {
                    throw new LogbookClientException((Throwable)e);
                    catch (VitamClientInternalException e2) {
                        throw new LogbookClientServerException(ErrorMessage.INTERNAL_SERVER_ERROR.getMessage(), (Throwable)e2);
                    }
                }
                catch (Throwable throwable) {
                    if (response != null && !doNotCloseResponse) {
                        this.consumeAnyEntityAndClose(response);
                    }
                    throw throwable;
                }
            }
            this.consumeAnyEntityAndClose(response);
        }
        return exactSizeInputStream;
    }

    @Override
    public JsonNode selectObjectGroupLifeCycleById(String id, JsonNode queryDsl) throws LogbookClientException, InvalidParseOperationException {
        return this.selectObjectGroupLifeCycleById(id, queryDsl, null);
    }

    @Override
    public JsonNode selectObjectGroupLifeCycleById(String id, JsonNode queryDsl, LifeCycleStatusCode lifeCycleStatus) throws LogbookClientException, InvalidParseOperationException {
        JsonNode jsonNode;
        block9: {
            VitamRequestBuilder request = VitamRequestBuilder.get().withJson().withPath("/objectgrouplifecycles/" + id).withBody((Object)queryDsl).withHeaderIgnoreNull("X-Event-Status", (Object)lifeCycleStatus);
            Response response = this.make(request);
            try {
                this.check(response);
                jsonNode = JsonHandler.getFromString((String)((String)response.readEntity(String.class)));
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (PreconditionFailedClientException e) {
                    throw new LogbookClientException(REQUEST_PRECONDITION_FAILED, (Throwable)e);
                }
                catch (VitamClientInternalException e) {
                    throw new LogbookClientServerException(ErrorMessage.INTERNAL_SERVER_ERROR.getMessage(), (Throwable)e);
                }
            }
            response.close();
        }
        return jsonNode;
    }

    @Override
    public JsonNode selectObjectGroupLifeCycle(JsonNode queryDsl) throws LogbookClientException, InvalidParseOperationException {
        JsonNode jsonNode;
        block9: {
            Response response = this.make(VitamRequestBuilder.get().withPath(OBJECT_GROUP_LIFECYCLES_URL).withBody((Object)queryDsl).withJson());
            try {
                this.check(response);
                jsonNode = JsonHandler.getFromString((String)((String)response.readEntity(String.class)));
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (PreconditionFailedClientException e) {
                    throw new LogbookClientException(REQUEST_PRECONDITION_FAILED, (Throwable)e);
                }
                catch (VitamClientInternalException e) {
                    throw new LogbookClientServerException(ErrorMessage.INTERNAL_SERVER_ERROR.getMessage(), (Throwable)e);
                }
            }
            response.close();
        }
        return jsonNode;
    }

    @Override
    public JsonNode selectObjectGroupLifeCycle(JsonNode queryDsl, LifeCycleStatusCode lifeCycleStatus) throws LogbookClientException, InvalidParseOperationException {
        JsonNode jsonNode;
        block9: {
            Response response = this.make(VitamRequestBuilder.get().withPath(OBJECT_GROUP_LIFECYCLES_URL).withBody((Object)queryDsl).withHeaderIgnoreNull("X-Event-Status", (Object)lifeCycleStatus).withJson());
            try {
                this.check(response);
                jsonNode = JsonHandler.getFromInputStream((InputStream)((InputStream)response.readEntity(InputStream.class)));
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (PreconditionFailedClientException e) {
                    throw new LogbookClientException(REQUEST_PRECONDITION_FAILED, (Throwable)e);
                }
                catch (VitamClientInternalException e) {
                    throw new LogbookClientServerException(ErrorMessage.INTERNAL_SERVER_ERROR.getMessage(), (Throwable)e);
                }
            }
            response.close();
        }
        return jsonNode;
    }

    @Override
    public CloseableIterator<JsonNode> objectGroupLifeCyclesByOperationIterator(String operationId, LifeCycleStatusCode lifeCycleStatus, JsonNode query) throws LogbookClientException {
        return this.getLifeCyclesByOperationIterator(operationId, lifeCycleStatus, query, OBJECT_GROUP_LIFECYCLES_URL);
    }

    @Override
    public CloseableIterator<JsonNode> unitLifeCyclesByOperationIterator(String operationId, LifeCycleStatusCode lifeCycleStatus, JsonNode query) throws LogbookClientException {
        return this.getLifeCyclesByOperationIterator(operationId, lifeCycleStatus, query, UNIT_LIFECYCLES_URL);
    }

    private CloseableIterator<JsonNode> getLifeCyclesByOperationIterator(String operationId, LifeCycleStatusCode lifeCycleStatus, JsonNode query, String operationTypeUrlSuffix) throws LogbookClientAlreadyExistsException, LogbookClientServerException, LogbookClientBadRequestException, LogbookClientNotFoundException {
        JsonLineIterator jsonLineIterator;
        block8: {
            VitamRequestBuilder request = VitamRequestBuilder.get().withPath("/operations/" + operationId + operationTypeUrlSuffix).withJsonContentType().withOctetAccept().withBody((Object)query).withHeader("X-Event-Status", (Object)lifeCycleStatus);
            Response response = this.make(request);
            try {
                this.check(response);
                jsonLineIterator = JsonLineIterator.parseFromResponse((Response)response, JsonNode.class);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (PreconditionFailedClientException | VitamClientInternalException e) {
                    throw new LogbookClientServerException(ErrorMessage.INTERNAL_SERVER_ERROR.getMessage(), e);
                }
            }
            response.close();
        }
        return jsonLineIterator;
    }

    @Override
    public void bulkCreateUnit(String eventIdProc, Iterable<LogbookLifeCycleParameters> queue) throws LogbookClientBadRequestException, LogbookClientAlreadyExistsException, LogbookClientServerException {
        this.bulkCreate(eventIdProc, queue, UNIT_LIFECYCLES_URL);
    }

    @Override
    public void bulkCreateObjectGroup(String eventIdProc, Iterable<LogbookLifeCycleParameters> queue) throws LogbookClientBadRequestException, LogbookClientAlreadyExistsException, LogbookClientServerException {
        this.bulkCreate(eventIdProc, queue, OBJECT_GROUP_LIFECYCLES_URL);
    }

    private void bulkCreate(String eventIdProc, Iterable<LogbookLifeCycleParameters> queue, String uri) throws LogbookClientBadRequestException, LogbookClientAlreadyExistsException, LogbookClientServerException {
        if (queue == null) {
            throw new LogbookClientBadRequestException(ErrorMessage.LOGBOOK_MISSING_MANDATORY_PARAMETER.getMessage());
        }
        try (Response response = this.make(VitamRequestBuilder.post().withPath("/operations/" + eventIdProc + uri).withBody(queue, "Queue must be not null.").withJson());){
            this.check(response);
        }
        catch (PreconditionFailedClientException | VitamClientInternalException | LogbookClientNotFoundException e) {
            throw new LogbookClientServerException(ErrorMessage.INTERNAL_SERVER_ERROR.getMessage(), e);
        }
    }

    @Override
    public void bulkUpdateUnit(String eventIdProc, Iterable<? extends LogbookLifeCycleParameters> queue) throws LogbookClientNotFoundException, LogbookClientBadRequestException, LogbookClientServerException {
        this.bulkUpdate(eventIdProc, queue, UNIT_LIFECYCLES_URL);
    }

    @Override
    public void bulkUpdateObjectGroup(String eventIdProc, Iterable<? extends LogbookLifeCycleParameters> queue) throws LogbookClientNotFoundException, LogbookClientBadRequestException, LogbookClientServerException {
        this.bulkUpdate(eventIdProc, queue, OBJECT_GROUP_LIFECYCLES_URL);
    }

    private void bulkUpdate(String eventIdProc, Iterable<? extends LogbookLifeCycleParameters> queue, String uri) throws LogbookClientNotFoundException, LogbookClientBadRequestException, LogbookClientServerException {
        if (queue == null) {
            throw new LogbookClientBadRequestException(ErrorMessage.LOGBOOK_MISSING_MANDATORY_PARAMETER.getMessage());
        }
        try (Response response = this.make(VitamRequestBuilder.put().withPath("/operations/" + eventIdProc + uri).withBody(queue).withJson());){
            this.check(response);
        }
        catch (PreconditionFailedClientException | VitamClientInternalException | LogbookClientAlreadyExistsException e) {
            throw new LogbookClientServerException(ErrorMessage.INTERNAL_SERVER_ERROR.getMessage(), e);
        }
    }

    @Override
    public void commitUnit(String operationId, String unitId) throws LogbookClientBadRequestException, LogbookClientNotFoundException, LogbookClientServerException {
        this.commitLifeCycle(operationId, unitId, UNIT_LIFECYCLES_URL);
    }

    @Override
    public void commitObjectGroup(String operationId, String objectGroupId) throws LogbookClientBadRequestException, LogbookClientNotFoundException, LogbookClientServerException {
        this.commitLifeCycle(operationId, objectGroupId, OBJECT_GROUP_LIFECYCLES_URL);
    }

    private void commitLifeCycle(String operationId, String idLc, String uri) throws LogbookClientBadRequestException, LogbookClientNotFoundException, LogbookClientServerException {
        String commitPath = "/operations/" + operationId + uri + "/" + idLc;
        VitamRequestBuilder request = VitamRequestBuilder.put().withPath(commitPath).withJson().withBody((Object)JsonHandler.createObjectNode()).withHeader("X-Event-Status", (Object)LifeCycleStatusCode.LIFE_CYCLE_COMMITTED.toString());
        try (Response response = this.make(request);){
            this.check(response);
        }
        catch (PreconditionFailedClientException | VitamClientInternalException | LogbookClientAlreadyExistsException e) {
            throw new LogbookClientServerException(ErrorMessage.INTERNAL_SERVER_ERROR.getMessage(), e);
        }
    }

    @Override
    public void rollBackUnitsByOperation(String operationId) throws LogbookClientNotFoundException, LogbookClientBadRequestException, LogbookClientServerException {
        this.rollBackOperationObjects(operationId, UNIT_LIFECYCLES_URL);
    }

    @Override
    public void rollBackObjectGroupsByOperation(String operationId) throws LogbookClientNotFoundException, LogbookClientBadRequestException, LogbookClientServerException {
        this.rollBackOperationObjects(operationId, OBJECT_GROUP_LIFECYCLES_URL);
    }

    private void rollBackOperationObjects(String operationId, String uri) throws LogbookClientNotFoundException, LogbookClientBadRequestException, LogbookClientServerException {
        String rollBackPath = "/operations/" + operationId + uri;
        try (Response response = this.make(VitamRequestBuilder.delete().withPath(rollBackPath).withJsonAccept());){
            this.check(response);
        }
        catch (PreconditionFailedClientException | VitamClientInternalException | LogbookClientAlreadyExistsException e) {
            throw new LogbookClientServerException(ErrorMessage.INTERNAL_SERVER_ERROR.getMessage(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public LifeCycleStatusCode getUnitLifeCycleStatus(String unitId) throws LogbookClientNotFoundException, LogbookClientServerException {
        try (Response response = this.make(VitamRequestBuilder.head().withPath("/unitlifecycles/" + unitId).withJsonAccept());){
            this.check(response);
            if (response.getHeaderString("X-Event-Status") == null) throw new LogbookClientServerException(ErrorMessage.INTERNAL_SERVER_ERROR.getMessage());
            LifeCycleStatusCode lifeCycleStatusCode = LifeCycleStatusCode.valueOf((String)response.getHeaderString("X-Event-Status"));
            return lifeCycleStatusCode;
        }
        catch (PreconditionFailedClientException | VitamClientInternalException | LogbookClientAlreadyExistsException | LogbookClientBadRequestException e) {
            throw new LogbookClientServerException(ErrorMessage.INTERNAL_SERVER_ERROR.getMessage(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public LifeCycleStatusCode getObjectGroupLifeCycleStatus(String objectGroupId) throws LogbookClientNotFoundException, LogbookClientServerException {
        try (Response response = this.make(VitamRequestBuilder.head().withPath("/objectgrouplifecycles/" + objectGroupId).withJsonAccept());){
            this.check(response);
            if (response.getHeaderString("X-Event-Status") == null) throw new LogbookClientServerException(ErrorMessage.INTERNAL_SERVER_ERROR.getMessage());
            LifeCycleStatusCode lifeCycleStatusCode = LifeCycleStatusCode.valueOf((String)response.getHeaderString("X-Event-Status"));
            return lifeCycleStatusCode;
        }
        catch (PreconditionFailedClientException | VitamClientInternalException | LogbookClientAlreadyExistsException | LogbookClientBadRequestException e) {
            throw new LogbookClientServerException(ErrorMessage.INTERNAL_SERVER_ERROR.getMessage(), e);
        }
    }

    @Override
    public void bulkObjectGroup(String eventIdProc, List<LogbookLifeCycleObjectGroupModel> logbookLifeCycleModels) throws LogbookClientAlreadyExistsException, LogbookClientBadRequestException, LogbookClientServerException {
        try (Response response = this.make(VitamRequestBuilder.put().withPath("/operations/" + eventIdProc + "/lifecycles/objectgroup/bulk").withBody(logbookLifeCycleModels).withJson());){
            this.check(response);
        }
        catch (PreconditionFailedClientException | VitamClientInternalException | LogbookClientNotFoundException e) {
            throw new LogbookClientServerException(ErrorMessage.INTERNAL_SERVER_ERROR.getMessage(), e);
        }
    }

    @Override
    public void bulkUnit(String eventIdProc, List<LogbookLifeCycleUnitModel> logbookLifeCycleModels) throws LogbookClientAlreadyExistsException, LogbookClientBadRequestException, LogbookClientServerException {
        try (Response response = this.make(VitamRequestBuilder.put().withPath("/operations/" + eventIdProc + "/lifecycles/unit/bulk").withBody(logbookLifeCycleModels, "Cannot be null").withJson());){
            this.check(response);
        }
        catch (PreconditionFailedClientException | VitamClientInternalException | LogbookClientNotFoundException e) {
            throw new LogbookClientServerException(ErrorMessage.INTERNAL_SERVER_ERROR.getMessage(), e);
        }
    }

    @Override
    public JsonNode getRawUnitLifeCycleById(String id) throws LogbookClientException {
        JsonNode jsonNode;
        block8: {
            Response response = this.make(VitamRequestBuilder.get().withPath(UNIT_LIFECYCLES_RAW_BY_ID_URL + id).withJsonAccept());
            try {
                this.check(response);
                jsonNode = (JsonNode)((RequestResponseOK)RequestResponse.parseFromResponse((Response)response)).getFirstResult();
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (PreconditionFailedClientException | VitamClientInternalException e) {
                    throw new LogbookClientServerException(ErrorMessage.INTERNAL_SERVER_ERROR.getMessage(), e);
                }
            }
            response.close();
        }
        return jsonNode;
    }

    @Override
    public List<JsonNode> getRawUnitLifeCycleByIds(List<String> ids) throws LogbookClientException {
        List list;
        block8: {
            Response response = this.make(VitamRequestBuilder.get().withPath(UNIT_LIFECYCLES_RAW_BY_IDS_URL).withBody(ids, "Ids cannot be null.").withJson());
            try {
                this.check(response);
                list = ((RequestResponseOK)RequestResponse.parseFromResponse((Response)response)).getResults();
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (PreconditionFailedClientException | VitamClientInternalException e) {
                    throw new LogbookClientServerException(ErrorMessage.INTERNAL_SERVER_ERROR.getMessage(), e);
                }
            }
            response.close();
        }
        return list;
    }

    @Override
    public JsonNode getRawObjectGroupLifeCycleById(String id) throws LogbookClientException {
        JsonNode jsonNode;
        block8: {
            Response response = this.make(VitamRequestBuilder.get().withPath(OBJECT_GROUP_LIFECYCLES_RAW_BY_ID_URL + id).withJsonAccept());
            try {
                this.check(response);
                jsonNode = (JsonNode)((RequestResponseOK)RequestResponse.parseFromResponse((Response)response)).getFirstResult();
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (PreconditionFailedClientException | VitamClientInternalException e) {
                    throw new LogbookClientServerException(ErrorMessage.INTERNAL_SERVER_ERROR.getMessage(), e);
                }
            }
            response.close();
        }
        return jsonNode;
    }

    @Override
    public List<JsonNode> getRawObjectGroupLifeCycleByIds(List<String> ids) throws LogbookClientException {
        List list;
        block8: {
            Response response = this.make(VitamRequestBuilder.get().withPath(OBJECT_GROUP_LIFECYCLES_RAW_BY_IDS_URL).withBody(ids, "Ids cannot be null.").withJson());
            try {
                this.check(response);
                list = ((RequestResponseOK)RequestResponse.parseFromResponse((Response)response)).getResults();
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (PreconditionFailedClientException | VitamClientInternalException e) {
                    throw new LogbookClientServerException(ErrorMessage.INTERNAL_SERVER_ERROR.getMessage(), e);
                }
            }
            response.close();
        }
        return list;
    }

    @Override
    public void createRawbulkObjectgrouplifecycles(List<JsonNode> logbookLifeCycleRaws) throws LogbookClientBadRequestException, LogbookClientServerException {
        this.createRawbulk(logbookLifeCycleRaws, OBJECT_GROUP_LIFECYCLES_RAW_BULK_URL);
    }

    @Override
    public void createRawbulkUnitlifecycles(List<JsonNode> logbookLifeCycleRaws) throws LogbookClientBadRequestException, LogbookClientServerException {
        this.createRawbulk(logbookLifeCycleRaws, UNIT_LIFECYCLES_RAW_BULK_URL);
    }

    @Override
    public void bulkLifeCycleTemporary(String operationId, DistributionType type, List<LogbookLifeCycleParametersBulk> logbookLifeCycleParametersBulk) throws VitamClientInternalException {
        this.bulkLFC(type, logbookLifeCycleParametersBulk, "/operations/" + operationId + "/bulklifecycles/%s/temporary");
    }

    @Override
    public void bulkLifeCycle(String operationId, DistributionType type, List<LogbookLifeCycleParametersBulk> logbookLifeCycleParametersBulk) throws VitamClientInternalException {
        this.bulkLFC(type, logbookLifeCycleParametersBulk, "/operations/" + operationId + "/bulklifecycles/%s");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public LogbookOperation findLastLifecycleTraceabilityOperation(String eventType) throws LogbookClientException {
        try (Response response = this.make(VitamRequestBuilder.get().withPath("/lastLifeCycleTraceabilityOperation/" + eventType).withJson());){
            this.check(response);
            RequestResponseOK results = (RequestResponseOK)RequestResponse.parseFromResponse((Response)response);
            if (results.getResults().isEmpty()) {
                LogbookOperation logbookOperation2 = null;
                return logbookOperation2;
            }
            LogbookOperation logbookOperation = (LogbookOperation)JsonHandler.getFromJsonNode((JsonNode)((JsonNode)results.getResults().get(0)), LogbookOperation.class);
            return logbookOperation;
        }
        catch (InvalidParseOperationException | PreconditionFailedClientException | VitamClientInternalException e) {
            throw new LogbookClientServerException(ErrorMessage.INTERNAL_SERVER_ERROR.getMessage(), e);
        }
    }

    private void bulkLFC(DistributionType type, List<LogbookLifeCycleParametersBulk> logbookLifeCycleParametersBulk, String uriPattern) throws VitamClientInternalException {
        VitamRequestBuilder request = VitamRequestBuilder.post().withBody(logbookLifeCycleParametersBulk, "LogbookLifeCycleParametersBulk cannot be null.").withJson();
        if (type == DistributionType.Units) {
            request.withPath(String.format(uriPattern, "unit"));
        } else if (type == DistributionType.ObjectGroup) {
            request.withPath(String.format(uriPattern, "got"));
        } else {
            throw new VitamClientInternalException(String.format("DistributionType with '%s' not managed.", type));
        }
        try (Response response = this.make(request);){
            this.check(response);
        }
        catch (PreconditionFailedClientException | LogbookClientAlreadyExistsException | LogbookClientBadRequestException | LogbookClientNotFoundException | LogbookClientServerException e) {
            throw new VitamRuntimeException("Unable to store lifecycle.", e);
        }
    }

    @Override
    public void deleteLifecycleUnitsBulk(Collection<String> unitsIds) throws LogbookClientServerException, LogbookClientBadRequestException {
        try (Response response = this.make(VitamRequestBuilder.delete().withPath("/lifeCycleUnits/bulkDelete").withBody(unitsIds, "unitsIds has to be provided").withJson());){
            this.check(response);
        }
        catch (PreconditionFailedClientException | VitamClientInternalException | LogbookClientAlreadyExistsException | LogbookClientNotFoundException e) {
            throw new LogbookClientServerException(ErrorMessage.INTERNAL_SERVER_ERROR.getMessage(), e);
        }
    }

    @Override
    public void deleteLifecycleObjectGroupBulk(Collection<String> objectGroupIds) throws LogbookClientBadRequestException, LogbookClientServerException {
        try (Response response = this.make(VitamRequestBuilder.delete().withPath("/objectgrouplifecycles/bulkDelete").withBody(objectGroupIds, "objectGroupIds has to be provided").withJson());){
            this.check(response);
        }
        catch (PreconditionFailedClientException | VitamClientInternalException | LogbookClientAlreadyExistsException | LogbookClientNotFoundException e) {
            throw new LogbookClientServerException(ErrorMessage.INTERNAL_SERVER_ERROR.getMessage(), e);
        }
    }

    private void createRawbulk(List<JsonNode> logbookLifeCycleRaws, String url) throws LogbookClientBadRequestException, LogbookClientServerException {
        try (Response response = this.make(VitamRequestBuilder.post().withPath(url).withBody(logbookLifeCycleRaws, "logbookLifeCycleRaws has to be provided").withJson());){
            this.check(response);
        }
        catch (PreconditionFailedClientException | VitamClientInternalException | LogbookClientAlreadyExistsException | LogbookClientNotFoundException e) {
            throw new LogbookClientServerException(ErrorMessage.INTERNAL_SERVER_ERROR.getMessage(), e);
        }
    }

    private String getServiceUrl(LogbookLifeCycleParameters parameters, String eip, String oid) {
        String logBookLifeCycleUrl;
        if (parameters instanceof LogbookLifeCycleObjectGroupParameters) {
            logBookLifeCycleUrl = OBJECT_GROUP_LIFECYCLES_URL;
        } else if (parameters instanceof LogbookLifeCycleUnitParameters) {
            logBookLifeCycleUrl = UNIT_LIFECYCLES_URL;
        } else {
            throw new IllegalArgumentException("Parameters to be checked");
        }
        return "/operations/" + eip + logBookLifeCycleUrl + "/" + oid;
    }

    private void check(Response response) throws LogbookClientAlreadyExistsException, LogbookClientServerException, LogbookClientBadRequestException, LogbookClientNotFoundException, PreconditionFailedClientException {
        Response.Status status = response.getStatusInfo().toEnum();
        if (Response.Status.Family.SUCCESSFUL.equals((Object)status.getFamily())) {
            return;
        }
        switch (status) {
            case INTERNAL_SERVER_ERROR: {
                throw new LogbookClientServerException(ErrorMessage.INTERNAL_SERVER_ERROR.getMessage());
            }
            case CONFLICT: {
                throw new LogbookClientAlreadyExistsException(ErrorMessage.LOGBOOK_ALREADY_EXIST.getMessage());
            }
            case PRECONDITION_FAILED: {
                throw new PreconditionFailedClientException(REQUEST_PRECONDITION_FAILED);
            }
            case NOT_FOUND: {
                throw new LogbookClientNotFoundException(ErrorMessage.LOGBOOK_NOT_FOUND.getMessage());
            }
            case BAD_REQUEST: {
                throw new LogbookClientBadRequestException(ErrorMessage.LOGBOOK_MISSING_MANDATORY_PARAMETER.getMessage());
            }
        }
        throw new LogbookClientServerException(status.toString());
    }
}

