/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.collect.external.client;

import fr.gouv.vitam.collect.external.client.CollectExternalClient;
import fr.gouv.vitam.collect.external.client.CollectExternalClientRest;
import fr.gouv.vitam.common.PropertiesUtils;
import fr.gouv.vitam.common.client.VitamClientFactoryInterface;
import fr.gouv.vitam.common.client.configuration.ClientConfiguration;
import fr.gouv.vitam.common.external.client.VitamClientFactory;
import fr.gouv.vitam.common.external.client.configuration.SecureClientConfigurationImpl;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import java.io.File;
import java.io.IOException;

public class CollectExternalClientFactory
extends VitamClientFactory<CollectExternalClient> {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(CollectExternalClientFactory.class);
    private static final String CONFIGURATION_FILENAME = "collect-external-client.conf";
    private static final String RESOURCE_PATH = "/collect-external/v1";
    private static final CollectExternalClientFactory COLLECT_CLIENT_FACTORY = new CollectExternalClientFactory();

    protected CollectExternalClientFactory() {
        super(CollectExternalClientFactory.changeConfigurationFile(CONFIGURATION_FILENAME), RESOURCE_PATH, false);
    }

    public static CollectExternalClientFactory getInstance() {
        return COLLECT_CLIENT_FACTORY;
    }

    static ClientConfiguration changeConfigurationFile(String configurationPath) {
        ClientConfiguration configuration = null;
        try {
            configuration = (ClientConfiguration)PropertiesUtils.readYaml((File)PropertiesUtils.findFile((String)configurationPath), SecureClientConfigurationImpl.class);
        }
        catch (IOException fnf) {
            LOGGER.debug("Error when retrieving configuration file {}, using mock", (Object)CONFIGURATION_FILENAME, (Object)fnf);
        }
        if (configuration == null) {
            LOGGER.error("Error when retrieving configuration file {}, using mock", (Object)CONFIGURATION_FILENAME);
        }
        return configuration;
    }

    public static void changeMode(String configurationFile) {
        ClientConfiguration configuration = CollectExternalClientFactory.changeConfigurationFile(configurationFile);
        CollectExternalClientFactory.getInstance().initialisation(configuration, CollectExternalClientFactory.getInstance().getResourcePath());
    }

    static void changeMode(ClientConfiguration configuration) {
        CollectExternalClientFactory.getInstance().initialisation(configuration, CollectExternalClientFactory.getInstance().getResourcePath());
    }

    public CollectExternalClient getClient() {
        return switch (this.getVitamClientType()) {
            case VitamClientFactoryInterface.VitamClientType.PRODUCTION -> new CollectExternalClientRest((VitamClientFactoryInterface<?>)this);
            default -> throw new IllegalArgumentException("Collect client type unknown");
        };
    }
}

