/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.collect.internal.server;

import com.fasterxml.jackson.jakarta.rs.base.JsonParseExceptionMapper;
import com.mongodb.client.MongoClient;
import fr.gouv.vitam.access.internal.client.AccessInternalClientFactory;
import fr.gouv.vitam.collect.common.exception.CollectInternalException;
import fr.gouv.vitam.collect.internal.core.configuration.CollectInternalConfiguration;
import fr.gouv.vitam.collect.internal.core.repository.MetadataRepository;
import fr.gouv.vitam.collect.internal.core.repository.ProjectRepository;
import fr.gouv.vitam.collect.internal.core.repository.TransactionRepository;
import fr.gouv.vitam.collect.internal.core.service.BulkAtomicUpdateMetadataService;
import fr.gouv.vitam.collect.internal.core.service.CollectService;
import fr.gouv.vitam.collect.internal.core.service.FluxService;
import fr.gouv.vitam.collect.internal.core.service.MetadataService;
import fr.gouv.vitam.collect.internal.core.service.ProjectService;
import fr.gouv.vitam.collect.internal.core.service.SipService;
import fr.gouv.vitam.collect.internal.core.service.TransactionService;
import fr.gouv.vitam.collect.internal.rest.CollectInternalResource;
import fr.gouv.vitam.collect.internal.rest.ProjectInternalResource;
import fr.gouv.vitam.collect.internal.rest.TransactionInternalResource;
import fr.gouv.vitam.collect.internal.thread.ManageStatusThread;
import fr.gouv.vitam.collect.internal.thread.PurgeTransactionThread;
import fr.gouv.vitam.common.PropertiesUtils;
import fr.gouv.vitam.common.database.server.mongodb.MongoDbAccess;
import fr.gouv.vitam.common.database.server.mongodb.SimpleMongoDBAccess;
import fr.gouv.vitam.common.format.identification.FormatIdentifierFactory;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.processing.WorkFlowExecutionContext;
import fr.gouv.vitam.common.server.application.configuration.DbConfiguration;
import fr.gouv.vitam.common.serverv2.ConfigurationApplication;
import fr.gouv.vitam.common.serverv2.application.CommonBusinessApplication;
import fr.gouv.vitam.functional.administration.client.AdminManagementClientFactory;
import fr.gouv.vitam.ingest.internal.client.IngestInternalClientFactory;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClientFactory;
import fr.gouv.vitam.metadata.client.MetaDataClientFactory;
import fr.gouv.vitam.processing.management.client.ProcessingManagementClientFactory;
import fr.gouv.vitam.workspace.client.WorkspaceClientFactory;
import fr.gouv.vitam.workspace.client.WorkspaceCollectClientFactory;
import jakarta.servlet.ServletConfig;
import jakarta.ws.rs.core.Context;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;

public class BusinessApplication
extends ConfigurationApplication {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(BusinessApplication.class);
    private final Set<Object> singletons;

    public BusinessApplication(@Context ServletConfig servletConfig) throws CollectInternalException {
        String configurationFile = servletConfig.getInitParameter("vitam.configurationFile");
        this.singletons = new HashSet<Object>();
        try (InputStream yamlIS = PropertiesUtils.getConfigAsStream((String)configurationFile);){
            CollectInternalConfiguration configuration = (CollectInternalConfiguration)PropertiesUtils.readYaml((InputStream)yamlIS, CollectInternalConfiguration.class);
            MongoClient mongoClient = MongoDbAccess.createMongoClient((DbConfiguration)configuration);
            SimpleMongoDBAccess mongoDbAccess = new SimpleMongoDBAccess(mongoClient, configuration.getDbName());
            WorkspaceCollectClientFactory.changeMode((String)configuration.getWorkspaceCollectUrl(), (WorkFlowExecutionContext)WorkFlowExecutionContext.COLLECT);
            WorkspaceClientFactory.changeMode((String)configuration.getWorkspaceUrl(), (WorkFlowExecutionContext)WorkFlowExecutionContext.VITAM);
            MetaDataClientFactory metadataCollectClientFactory = MetaDataClientFactory.getInstance((WorkFlowExecutionContext)WorkFlowExecutionContext.COLLECT);
            WorkspaceCollectClientFactory workspaceCollectClientFactory = WorkspaceCollectClientFactory.getInstance();
            WorkspaceClientFactory workspaceClientFactory = WorkspaceClientFactory.getInstance((WorkFlowExecutionContext)WorkFlowExecutionContext.VITAM);
            IngestInternalClientFactory ingestInternalClientFactory = IngestInternalClientFactory.getInstance();
            AccessInternalClientFactory accessInternalClientFactory = AccessInternalClientFactory.getInstance();
            AdminManagementClientFactory adminManagementClientFactory = AdminManagementClientFactory.getInstance();
            ProcessingManagementClientFactory processingManagementClientFactory = ProcessingManagementClientFactory.getInstance((WorkFlowExecutionContext)WorkFlowExecutionContext.COLLECT);
            LogbookOperationsClientFactory logbookOperationsClientFactory = LogbookOperationsClientFactory.getInstance((WorkFlowExecutionContext)WorkFlowExecutionContext.COLLECT);
            TransactionRepository transactionRepository = new TransactionRepository((MongoDbAccess)mongoDbAccess);
            ProjectRepository projectRepository = new ProjectRepository((MongoDbAccess)mongoDbAccess);
            MetadataRepository metadataRepository = new MetadataRepository(metadataCollectClientFactory);
            BulkAtomicUpdateMetadataService bulkAtomicUpdateMetadataService = new BulkAtomicUpdateMetadataService(metadataRepository, metadataCollectClientFactory, configuration);
            MetadataService metadataService = new MetadataService(metadataRepository, projectRepository, bulkAtomicUpdateMetadataService, adminManagementClientFactory);
            ProjectService projectService = new ProjectService(projectRepository);
            CollectService collectService = new CollectService(metadataRepository, (WorkspaceClientFactory)workspaceCollectClientFactory, workspaceClientFactory, FormatIdentifierFactory.getInstance(), processingManagementClientFactory, logbookOperationsClientFactory);
            FluxService fluxService = new FluxService(collectService, metadataService, projectRepository, metadataRepository, adminManagementClientFactory, configuration);
            TransactionService transactionService = new TransactionService(transactionRepository, projectService, metadataRepository, fluxService, workspaceCollectClientFactory, workspaceClientFactory, accessInternalClientFactory, ingestInternalClientFactory, processingManagementClientFactory, logbookOperationsClientFactory, configuration);
            SipService sipService = new SipService(workspaceCollectClientFactory, metadataRepository, transactionService);
            TransactionInternalResource transactionInternalResource = new TransactionInternalResource(transactionService, sipService, metadataService, bulkAtomicUpdateMetadataService);
            ProjectInternalResource projectInternalResource = new ProjectInternalResource(projectService, fluxService, transactionService, metadataService);
            CollectInternalResource collectInternalResource = new CollectInternalResource(metadataService, collectService, transactionService);
            new PurgeTransactionThread(configuration, transactionService);
            new ManageStatusThread(configuration, transactionService);
            CommonBusinessApplication commonBusinessApplication = new CommonBusinessApplication();
            this.singletons.addAll(commonBusinessApplication.getResources());
            this.singletons.add(new JsonParseExceptionMapper());
            this.singletons.add(transactionInternalResource);
            this.singletons.add(projectInternalResource);
            this.singletons.add((Object)collectInternalResource);
        }
        catch (IOException e) {
            LOGGER.debug("Error when starting BusinessApplication :", (Throwable)e);
            throw new CollectInternalException((Throwable)e);
        }
    }

    public Set<Object> getSingletons() {
        return this.singletons;
    }
}

