/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.collect.internal.rest;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import fr.gouv.vitam.collect.common.dto.TransactionDto;
import fr.gouv.vitam.collect.common.dto.UploadSipResult;
import fr.gouv.vitam.collect.common.enums.TransactionStatus;
import fr.gouv.vitam.collect.common.exception.CollectInternalException;
import fr.gouv.vitam.collect.common.exception.CollectInternalInvalidRequestException;
import fr.gouv.vitam.collect.common.exception.CollectInternalNotFoundException;
import fr.gouv.vitam.collect.common.exception.CollectRequestResponse;
import fr.gouv.vitam.collect.internal.core.common.TransactionModel;
import fr.gouv.vitam.collect.internal.core.helpers.CollectHelper;
import fr.gouv.vitam.collect.internal.core.service.BulkAtomicUpdateMetadataService;
import fr.gouv.vitam.collect.internal.core.service.MetadataService;
import fr.gouv.vitam.collect.internal.core.service.SipService;
import fr.gouv.vitam.collect.internal.core.service.TransactionService;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.PropertiesUtils;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.parser.request.multiple.SelectParserMultiple;
import fr.gouv.vitam.common.error.VitamCode;
import fr.gouv.vitam.common.error.VitamError;
import fr.gouv.vitam.common.exception.BadRequestException;
import fr.gouv.vitam.common.exception.InternalServerException;
import fr.gouv.vitam.common.exception.InvalidGuidOperationException;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.elimination.DeletionRequestBody;
import fr.gouv.vitam.common.model.elimination.EliminationRequestBody;
import fr.gouv.vitam.common.security.SanityChecker;
import fr.gouv.vitam.common.stream.StreamUtils;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.logbook.common.exception.LogbookClientAlreadyExistsException;
import fr.gouv.vitam.logbook.common.exception.LogbookClientBadRequestException;
import fr.gouv.vitam.logbook.common.exception.LogbookClientServerException;
import fr.gouv.vitam.logbook.common.parameters.Contexts;
import fr.gouv.vitam.metadata.api.utils.BulkAtomicUpdateModelUtils;
import fr.gouv.vitam.processing.engine.core.operation.OperationContextException;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageNotFoundException;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageServerException;
import jakarta.annotation.Nullable;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;

@Path(value="/collect-internal/v1/transactions")
public class TransactionInternalResource {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(TransactionInternalResource.class);
    private static final String EMPTY_QUERY_IS_IMPOSSIBLE = "Empty query is impossible";
    private static final String INVALID_QUERY_DSL_EXCEPTION = "Invalid query DSL ";
    private static final String EXECUTION_OF_DSL_VITAM_FROM_COLLECT_ONGOING = "Execution of DSL Vitam from Collect ongoing...";
    private static final String DEBUG = "DEBUG {}";
    private final TransactionService transactionService;
    private final MetadataService metadataService;
    private final SipService sipService;
    private final BulkAtomicUpdateMetadataService bulkAtomicUpdateMetadataService;

    public TransactionInternalResource(TransactionService transactionService, SipService sipService, MetadataService metadataService, BulkAtomicUpdateMetadataService bulkAtomicUpdateMetadataService) {
        this.transactionService = transactionService;
        this.sipService = sipService;
        this.metadataService = metadataService;
        this.bulkAtomicUpdateMetadataService = bulkAtomicUpdateMetadataService;
    }

    @GET
    @Path(value="/withAutomaticIngest")
    @Produces(value={"application/json"})
    public Response getTransactionsToAutomaticallyIngest() throws CollectInternalException {
        return CollectRequestResponse.toResponseOK(this.transactionService.findValidatedAutoIngestTransactions().stream().map(CollectHelper::convertTransactionModelToTransactionDto).collect(Collectors.toList()));
    }

    @Path(value="/{transactionId}")
    @GET
    @Produces(value={"application/json"})
    public Response getTransactionById(@PathParam(value="transactionId") String transactionId) {
        try {
            SanityChecker.checkParameter((String[])new String[]{transactionId});
            TransactionModel transactionModel = this.getTransaction(transactionId);
            TransactionDto transactionDto = CollectHelper.convertTransactionModelToTransactionDto((TransactionModel)transactionModel);
            return CollectRequestResponse.toResponseOK((Object)transactionDto);
        }
        catch (CollectInternalNotFoundException e) {
            LOGGER.error("Error when get transaction by Id. Not Found", (Throwable)e);
            return CollectRequestResponse.toVitamError((Response.Status)Response.Status.NOT_FOUND, (String)e.getLocalizedMessage());
        }
        catch (CollectInternalInvalidRequestException | InvalidParseOperationException e) {
            LOGGER.error("Error when get transaction by Id. Bad Request", e);
            return CollectRequestResponse.toVitamError((Response.Status)Response.Status.BAD_REQUEST, (String)e.getLocalizedMessage());
        }
        catch (Exception e) {
            LOGGER.error("Error when get transaction by Id. Internal Server Error", (Throwable)e);
            return CollectRequestResponse.toVitamError((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (String)e.getLocalizedMessage());
        }
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updateTransaction(TransactionDto transactionDto) {
        try {
            ParametersChecker.checkParameter((String)"You must supply transaction data!", (Object[])new Object[]{transactionDto});
            SanityChecker.checkJsonAll((JsonNode)JsonHandler.toJsonNode((Object)transactionDto));
            TransactionModel transactionModel = this.transactionService.replaceTransaction(transactionDto);
            TransactionDto result = CollectHelper.convertTransactionModelToTransactionDto((TransactionModel)transactionModel);
            return CollectRequestResponse.toResponseOK((Object)result);
        }
        catch (CollectInternalNotFoundException e) {
            LOGGER.error("Error updating transaction. Not Found", (Throwable)e);
            return CollectRequestResponse.toVitamError((Response.Status)Response.Status.NOT_FOUND, (String)e.getLocalizedMessage());
        }
        catch (CollectInternalInvalidRequestException | InvalidParseOperationException e) {
            LOGGER.error("Error updating transaction. Bad Request", e);
            return CollectRequestResponse.toVitamError((Response.Status)Response.Status.BAD_REQUEST, (String)e.getLocalizedMessage());
        }
        catch (Exception e) {
            LOGGER.error("Error updating transaction. Internal Server Error :", (Throwable)e);
            return CollectRequestResponse.toVitamError((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (String)e.getLocalizedMessage());
        }
    }

    @Path(value="/{transactionId}")
    @DELETE
    @Produces(value={"application/json"})
    public Response deleteTransactionById(@PathParam(value="transactionId") String transactionId) {
        try {
            SanityChecker.checkParameter((String[])new String[]{transactionId});
            TransactionModel transactionModel = this.getTransaction(transactionId);
            this.transactionService.deleteTransaction(transactionModel.getId());
            return Response.status((Response.Status)Response.Status.OK).build();
        }
        catch (CollectInternalNotFoundException e) {
            LOGGER.error("Error while deleting transaction by Id. Not Found", (Throwable)e);
            return CollectRequestResponse.toVitamError((Response.Status)Response.Status.NOT_FOUND, (String)e.getLocalizedMessage());
        }
        catch (CollectInternalInvalidRequestException | InvalidParseOperationException e) {
            LOGGER.error("Error while deleting transaction by Id. Bad Request", e);
            return CollectRequestResponse.toVitamError((Response.Status)Response.Status.BAD_REQUEST, (String)e.getLocalizedMessage());
        }
        catch (Exception e) {
            LOGGER.error("Error while deleting transaction by Id. Internal Server Error", (Throwable)e);
            return CollectRequestResponse.toVitamError((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (String)e.getLocalizedMessage());
        }
    }

    @Path(value="/{transactionId}/units")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response uploadArchiveUnit(@PathParam(value="transactionId") String transactionId, JsonNode unitJsonNode) {
        try {
            SanityChecker.checkParameter((String[])new String[]{transactionId});
            SanityChecker.checkJsonAll((JsonNode)unitJsonNode);
            TransactionModel transactionModel = this.getTransaction(transactionId);
            this.transactionService.ensureTransactionIsOpen(transactionModel);
            JsonNode savedUnitJsonNode = this.metadataService.saveArchiveUnit(unitJsonNode, transactionModel);
            return CollectRequestResponse.toResponseOK((Object)savedUnitJsonNode);
        }
        catch (CollectInternalNotFoundException e) {
            LOGGER.error("Error while uploading archive unit. Not Found", (Throwable)e);
            return CollectRequestResponse.toVitamError((Response.Status)Response.Status.NOT_FOUND, (String)e.getLocalizedMessage());
        }
        catch (CollectInternalInvalidRequestException e) {
            LOGGER.error("Error while uploading archive unit. Bad Request", (Throwable)e);
            return CollectRequestResponse.toVitamError((Response.Status)Response.Status.BAD_REQUEST, (String)e.getLocalizedMessage());
        }
        catch (Exception e) {
            LOGGER.error("Error while uploading archive unit. Internal Server Error", (Throwable)e);
            return CollectRequestResponse.toVitamError((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (String)e.getLocalizedMessage());
        }
    }

    @Path(value="/{transactionId}/units")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response selectUnits(@PathParam(value="transactionId") String transactionId, JsonNode jsonQuery) {
        try {
            RequestResponseOK units = this.metadataService.selectUnitsByTransactionId(jsonQuery, transactionId);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)units).build();
        }
        catch (Exception e) {
            LOGGER.error("Error when getting units in metadata :", (Throwable)e);
            return CollectRequestResponse.toVitamError((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (String)e.getLocalizedMessage());
        }
    }

    @Path(value="/{transactionId}/close")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response closeTransaction(@PathParam(value="transactionId") String transactionId) {
        try {
            SanityChecker.checkParameter((String[])new String[]{transactionId});
            TransactionModel transaction = this.getTransaction(transactionId);
            this.transactionService.closeTransaction(transaction);
            this.sipService.generateSipAsync(transaction);
            return Response.status((Response.Status)Response.Status.OK).build();
        }
        catch (CollectInternalNotFoundException e) {
            LOGGER.error("An error occurred while closing transaction. Not Found", (Throwable)e);
            return CollectRequestResponse.toVitamError((Response.Status)Response.Status.NOT_FOUND, (String)e.getLocalizedMessage());
        }
        catch (CollectInternalInvalidRequestException | InvalidParseOperationException e) {
            LOGGER.error("An error occurred while closing transaction. Bad Request", e);
            return CollectRequestResponse.toVitamError((Response.Status)Response.Status.BAD_REQUEST, (String)e.getLocalizedMessage());
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while closing transaction. Internal Server Error", (Throwable)e);
            return CollectRequestResponse.toVitamError((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (String)e.getLocalizedMessage());
        }
    }

    @Path(value="/{transactionId}/abort")
    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response abortTransaction(@PathParam(value="transactionId") String transactionId) {
        try {
            SanityChecker.checkParameter((String[])new String[]{transactionId});
            this.transactionService.abortTransaction(transactionId);
            this.sipService.cleanupSip(transactionId);
            return Response.status((Response.Status)Response.Status.OK).build();
        }
        catch (CollectInternalNotFoundException e) {
            LOGGER.error("An error occurred while aborting transaction. Not Found", (Throwable)e);
            return CollectRequestResponse.toVitamError((Response.Status)Response.Status.NOT_FOUND, (String)e.getLocalizedMessage());
        }
        catch (CollectInternalInvalidRequestException | InvalidParseOperationException e) {
            LOGGER.error("An error occurred while aborting transaction. Bad Request", e);
            return CollectRequestResponse.toVitamError((Response.Status)Response.Status.BAD_REQUEST, (String)e.getLocalizedMessage());
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while aborting transaction. Internal Server Error", (Throwable)e);
            return CollectRequestResponse.toVitamError((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (String)e.getLocalizedMessage());
        }
    }

    @Path(value="/{transactionId}/reopen")
    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response reopenTransaction(@PathParam(value="transactionId") String transactionId) {
        try {
            SanityChecker.checkParameter((String[])new String[]{transactionId});
            this.transactionService.reopenTransaction(transactionId);
            this.sipService.cleanupSip(transactionId);
            return Response.status((Response.Status)Response.Status.OK).build();
        }
        catch (CollectInternalNotFoundException e) {
            LOGGER.error("An error occurred while reopening transaction. Not Found", (Throwable)e);
            return CollectRequestResponse.toVitamError((Response.Status)Response.Status.NOT_FOUND, (String)e.getLocalizedMessage());
        }
        catch (CollectInternalInvalidRequestException | InvalidParseOperationException e) {
            LOGGER.error("An error occurred while reopening transaction. Bad Request", e);
            return CollectRequestResponse.toVitamError((Response.Status)Response.Status.BAD_REQUEST, (String)e.getLocalizedMessage());
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while reopening transaction. Internal Server Error", (Throwable)e);
            return CollectRequestResponse.toVitamError((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (String)e.getLocalizedMessage());
        }
    }

    @Path(value="/{transactionId}/awaitTransactionValidation")
    @POST
    @Produces(value={"application/json"})
    public Response awaitTransactionValidation(@PathParam(value="transactionId") String transactionId) {
        try {
            SanityChecker.checkParameter((String[])new String[]{transactionId});
            this.transactionService.awaitTransactionValidationForIngest(transactionId);
            return Response.status((Response.Status)Response.Status.OK).build();
        }
        catch (CollectInternalNotFoundException e) {
            LOGGER.error("Error while awaiting transaction validation. Not Found", (Throwable)e);
            return CollectRequestResponse.toVitamError((Response.Status)Response.Status.NOT_FOUND, (String)e.getLocalizedMessage());
        }
        catch (CollectInternalInvalidRequestException | InvalidParseOperationException e) {
            LOGGER.error("Error while awaiting transaction validation. Bad Request", e);
            return CollectRequestResponse.toVitamError((Response.Status)Response.Status.BAD_REQUEST, (String)e.getLocalizedMessage());
        }
        catch (Exception e) {
            LOGGER.error("Error while awaiting transaction validation. Internal Server Error", (Throwable)e);
            return CollectRequestResponse.toVitamError((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (String)e.getLocalizedMessage());
        }
    }

    @Path(value="/{transactionId}/downloadSIP")
    @GET
    @Produces(value={"application/octet-stream"})
    public Response downloadSip(@PathParam(value="transactionId") String transactionId) {
        try {
            SanityChecker.checkParameter((String[])new String[]{transactionId});
            TransactionModel transaction = this.getTransaction(transactionId);
            this.transactionService.checkSipDownloadable(transaction);
            InputStream sipInputStream = this.sipService.getIngestedFileFromWorkspace(transactionId);
            return Response.ok((Object)sipInputStream).build();
        }
        catch (CollectInternalNotFoundException e) {
            LOGGER.error("Error while downloading transaction SIP. Not Found", (Throwable)e);
            return CollectRequestResponse.toVitamError((Response.Status)Response.Status.NOT_FOUND, (String)e.getLocalizedMessage());
        }
        catch (CollectInternalInvalidRequestException | InvalidParseOperationException e) {
            LOGGER.error("Error while downloading transaction SIP. Bad Request", e);
            return CollectRequestResponse.toVitamError((Response.Status)Response.Status.BAD_REQUEST, (String)e.getLocalizedMessage());
        }
        catch (Exception e) {
            LOGGER.error("Error while downloading transaction SIP. Internal Server Error", (Throwable)e);
            return CollectRequestResponse.toVitamError((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (String)e.getLocalizedMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Path(value="/{transactionId}/units/metadata/csv")
    @PUT
    @Consumes(value={"text/csv"})
    @Produces(value={"application/json"})
    public Response updateUnitsWithMetadataCsv(@PathParam(value="transactionId") String transactionId, InputStream metadataCsvInputStream) {
        try {
            ParametersChecker.checkParameter((String)"DOCUMENT_IS_MANDATORY", (Object[])new Object[]{metadataCsvInputStream});
            SanityChecker.checkParameter((String[])new String[]{transactionId});
            TransactionModel transaction = this.getTransaction(transactionId);
            this.transactionService.ensureTransactionIsOpen(transaction);
            String requestId = VitamThreadUtils.getVitamSession().getRequestId();
            File file = PropertiesUtils.fileFromTmpFolder((String)String.format("metadata_%s.csv", requestId));
            try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
                StreamUtils.copy((InputStream)metadataCsvInputStream, (OutputStream)fileOutputStream);
                if (file.length() == 0L) {
                    throw new CollectInternalInvalidRequestException("Empty file");
                }
                SanityChecker.checkHTMLFile((File)file);
                try (FileInputStream sanityStream = new FileInputStream(file);){
                    this.metadataService.updateUnitsWithMetadataCsv(transaction, (InputStream)sanityStream);
                }
            }
            finally {
                FileUtils.deleteQuietly((File)file);
            }
            return Response.ok((Object)new RequestResponseOK()).build();
        }
        catch (CollectInternalNotFoundException e) {
            LOGGER.error("An occurred while updating metadata. Not Found", (Throwable)e);
            return CollectRequestResponse.toVitamError((Response.Status)Response.Status.NOT_FOUND, (String)e.getLocalizedMessage());
        }
        catch (CollectInternalInvalidRequestException | InvalidParseOperationException e) {
            LOGGER.error("An occurred while updating metadata. Bad Request", e);
            return CollectRequestResponse.toVitamError((Response.Status)Response.Status.BAD_REQUEST, (String)e.getLocalizedMessage());
        }
        catch (Exception e) {
            LOGGER.error("An occurred while updating metadata. Internal Server Error", (Throwable)e);
            return CollectRequestResponse.toVitamError((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (String)e.getLocalizedMessage());
        }
    }

    @Path(value="/{transactionId}/units/metadata/jsonl")
    @PUT
    @Consumes(value={"application/octet-stream"})
    @Produces(value={"application/json"})
    public Response updateUnitsWithMetadataJsonl(@PathParam(value="transactionId") String transactionId, InputStream metadataJsonlInputStream) {
        try {
            ParametersChecker.checkParameter((String)"DOCUMENT_IS_MANDATORY", (Object[])new Object[]{metadataJsonlInputStream});
            SanityChecker.checkParameter((String[])new String[]{transactionId});
            TransactionModel transaction = this.getTransaction(transactionId);
            this.transactionService.ensureTransactionIsOpen(transaction);
            this.metadataService.updateUnitsWithJsonlMetadata(transaction, metadataJsonlInputStream);
            return Response.ok((Object)new RequestResponseOK()).build();
        }
        catch (CollectInternalNotFoundException e) {
            LOGGER.error("An error occurred while updating metadata. Not Found", (Throwable)e);
            return CollectRequestResponse.toVitamError((Response.Status)Response.Status.NOT_FOUND, (String)e.getLocalizedMessage());
        }
        catch (CollectInternalInvalidRequestException | InvalidParseOperationException e) {
            LOGGER.error("An occurred while updating metadata. Bad Request", e);
            return CollectRequestResponse.toVitamError((Response.Status)Response.Status.BAD_REQUEST, (String)e.getLocalizedMessage());
        }
        catch (Exception e) {
            LOGGER.error("An occurred while updating metadata. Internal Server Error", (Throwable)e);
            return CollectRequestResponse.toVitamError((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (String)e.getLocalizedMessage());
        }
    }

    @Path(value="/{transactionId}/upload")
    @POST
    @Consumes(value={"application/zip"})
    @Produces(value={"application/json"})
    public Response uploadTransactionZip(@PathParam(value="transactionId") String transactionId, InputStream inputStreamObject, @HeaderParam(value="X-Encoding") @Nullable String encoding, @HeaderParam(value="X-Attachement-Id") @Nullable String attachementId) {
        try {
            ParametersChecker.checkParameter((String)"You must supply a file!", (Object[])new Object[]{inputStreamObject});
            SanityChecker.checkParameter((String[])new String[]{transactionId});
            TransactionModel transactionModel = this.getTransaction(transactionId);
            this.transactionService.ensureTransactionIsOpen(transactionModel);
            return this.transactionService.uploadTransactionZip(inputStreamObject, transactionModel, encoding, attachementId);
        }
        catch (CollectInternalNotFoundException e) {
            LOGGER.error("An error occurred while uploading the ZIP. Bad Request", (Throwable)e);
            return CollectRequestResponse.toVitamError((Response.Status)Response.Status.NOT_FOUND, (String)e.getLocalizedMessage());
        }
        catch (CollectInternalInvalidRequestException | InvalidParseOperationException e) {
            LOGGER.error("An error occurred while uploading the ZIP. Bad Request", e);
            return CollectRequestResponse.toVitamError((Response.Status)Response.Status.BAD_REQUEST, (String)e.getLocalizedMessage());
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while uploading the ZIP. Internal Server Error", (Throwable)e);
            return CollectRequestResponse.toVitamError((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (String)e.getLocalizedMessage());
        }
    }

    @Path(value="/{transactionId}/status/{transactionStatus}")
    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response changeTransactionStatus(@PathParam(value="transactionId") String transactionId, @PathParam(value="transactionStatus") TransactionStatus transactionStatus) {
        try {
            SanityChecker.checkParameter((String[])new String[]{transactionId});
            TransactionModel transaction = this.getTransaction(transactionId);
            this.transactionService.changeTransactionStatus(transactionStatus, transaction);
            return Response.status((Response.Status)Response.Status.OK).build();
        }
        catch (CollectInternalNotFoundException e) {
            LOGGER.error("An error occurred while updating status. Not Found", (Throwable)e);
            return CollectRequestResponse.toVitamError((Response.Status)Response.Status.NOT_FOUND, (String)e.getLocalizedMessage());
        }
        catch (CollectInternalInvalidRequestException | InvalidParseOperationException e) {
            LOGGER.error("An error occurred while updating status. Bad Request", e);
            return CollectRequestResponse.toVitamError((Response.Status)Response.Status.BAD_REQUEST, (String)e.getLocalizedMessage());
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while updating status. Internal Server Error", (Throwable)e);
            return CollectRequestResponse.toVitamError((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (String)e.getLocalizedMessage());
        }
    }

    @Path(value="/{transactionId}/operation-id/{operationId}")
    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response attachVitamOperationId(@PathParam(value="transactionId") String transactionId, @PathParam(value="operationId") String operationId) {
        try {
            SanityChecker.checkParameter((String[])new String[]{transactionId});
            SanityChecker.checkParameter((String[])new String[]{operationId});
            this.transactionService.attachVitamOperationId(transactionId, operationId);
            return Response.status((Response.Status)Response.Status.OK).build();
        }
        catch (CollectInternalNotFoundException e) {
            LOGGER.error("An error occurred while transaction with ingest operation id. Not Found", (Throwable)e);
            return CollectRequestResponse.toVitamError((Response.Status)Response.Status.NOT_FOUND, (String)e.getLocalizedMessage());
        }
        catch (CollectInternalInvalidRequestException | InvalidParseOperationException e) {
            LOGGER.error("An error occurred while transaction with ingest operation id. Bad Request", e);
            return CollectRequestResponse.toVitamError((Response.Status)Response.Status.BAD_REQUEST, (String)e.getLocalizedMessage());
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while transaction with ingest operation id. Internal Server Error", (Throwable)e);
            return CollectRequestResponse.toVitamError((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (String)e.getLocalizedMessage());
        }
    }

    private void checkEmptyQuery(JsonNode queryDsl) throws InvalidParseOperationException, BadRequestException {
        SelectParserMultiple parser = new SelectParserMultiple();
        parser.parse(queryDsl.deepCopy());
        if (parser.getRequest().getNbQueries() == 0 && parser.getRequest().getRoots().isEmpty()) {
            throw new BadRequestException("Query cant be empty");
        }
    }

    @GET
    @Path(value="/{transactionId}/unitsWithInheritedRules")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response selectUnitsWithInheritedRules(@PathParam(value="transactionId") String transactionId, JsonNode queryDsl) {
        JsonNode result;
        LOGGER.debug(EXECUTION_OF_DSL_VITAM_FROM_COLLECT_ONGOING);
        LOGGER.debug("DEBUG: start selectUnitsWithInheritedRules {}", (Object)queryDsl);
        try {
            SanityChecker.checkJsonAll((JsonNode)queryDsl);
            this.checkEmptyQuery(queryDsl);
            result = this.metadataService.selectUnitsWithInheritedRules(transactionId, queryDsl);
            LOGGER.debug(DEBUG, (Object)result);
        }
        catch (InvalidParseOperationException e) {
            LOGGER.error(INVALID_QUERY_DSL_EXCEPTION, (Throwable)e);
            return CollectRequestResponse.toVitamError((Response.Status)Response.Status.BAD_REQUEST, (String)EMPTY_QUERY_IS_IMPOSSIBLE);
        }
        catch (BadRequestException e) {
            LOGGER.error(EMPTY_QUERY_IS_IMPOSSIBLE, (Throwable)e);
            return CollectRequestResponse.toVitamError((Response.Status)VitamCode.GLOBAL_EMPTY_QUERY.getStatus(), (String)EMPTY_QUERY_IS_IMPOSSIBLE);
        }
        catch (Exception ve) {
            LOGGER.error((Throwable)ve);
            Response.Status status = Response.Status.INTERNAL_SERVER_ERROR;
            return Response.status((Response.Status)status).entity((Object)new VitamError(status.name()).setHttpCode(status.getStatusCode()).setMessage(ve.getMessage()).setDescription(status.getReasonPhrase())).build();
        }
        return Response.status((Response.Status)Response.Status.OK).entity((Object)result).build();
    }

    @POST
    @Path(value="/{transactionId}/units/bulk")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response bulkAtomicUpdateUnits(@PathParam(value="transactionId") String transactionId, JsonNode updateQueriesJson) {
        try {
            SanityChecker.checkParameter((String[])new String[]{transactionId});
            TransactionModel transactionModel = this.getTransaction(transactionId);
            this.transactionService.ensureTransactionIsOpen(transactionModel);
            this.bulkAtomicUpdateMetadataService.checkThreshold(updateQueriesJson);
            ArrayNode queries = BulkAtomicUpdateModelUtils.getQueries((JsonNode)updateQueriesJson);
            List bulkAtomicUpdateResults = this.bulkAtomicUpdateMetadataService.bulkAtomicUpdateUnits(transactionModel.getId(), queries, false);
            return new RequestResponseOK().addAllResults(bulkAtomicUpdateResults).setHttpCode(Response.Status.ACCEPTED.getStatusCode()).toResponse();
        }
        catch (CollectInternalNotFoundException e) {
            LOGGER.error("Bulk atomic update failed - Not Found. Transaction : '" + transactionId + "'", (Throwable)e);
            return CollectRequestResponse.toVitamError((Response.Status)Response.Status.NOT_FOUND, (String)e.getLocalizedMessage());
        }
        catch (CollectInternalInvalidRequestException | InvalidParseOperationException e) {
            LOGGER.error("Bulk atomic update failed - Bad request. Transaction : '" + transactionId + "'", e);
            return CollectRequestResponse.toVitamError((Response.Status)Response.Status.BAD_REQUEST, (String)e.getLocalizedMessage());
        }
        catch (CollectInternalException | RuntimeException e) {
            LOGGER.error("Bulk atomic update failed - Internal server error. Transaction : '" + transactionId + "'", e);
            return CollectRequestResponse.toVitamError((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (String)e.getLocalizedMessage());
        }
    }

    /*
     * Exception decompiling
     */
    @POST
    @Path(value="/{transactionId}/reclassification")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response reclassification(@PathParam(value="transactionId") String transactionId, JsonNode reclassificationRequestJson) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @POST
    @Path(value="/{transactionId}/elimination/action")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response startEliminationActionWorkflow(@PathParam(value="transactionId") String transactionId, EliminationRequestBody eliminationRequestBody) {
        try {
            SanityChecker.checkParameter((String[])new String[]{transactionId});
            TransactionModel transaction = this.getTransaction(transactionId);
            this.transactionService.ensureTransactionIsOpen(transaction);
            return this.transactionService.startEliminationActionWorkflow(transactionId, eliminationRequestBody, Contexts.COLLECT_ELIMINATION_ACTION);
        }
        catch (CollectInternalException | InternalServerException | VitamClientException | LogbookClientServerException | OperationContextException | ContentAddressableStorageServerException e) {
            return CollectRequestResponse.toVitamError((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (String)e.getLocalizedMessage());
        }
        catch (InvalidCreateOperationException | BadRequestException | InvalidGuidOperationException | InvalidParseOperationException | LogbookClientAlreadyExistsException | LogbookClientBadRequestException e) {
            LOGGER.error("Error starting elimination workflow - Bad Request", e);
            return CollectRequestResponse.toVitamError((Response.Status)Response.Status.BAD_REQUEST, (String)e.getLocalizedMessage());
        }
        catch (Exception e) {
            LOGGER.error("Error starting elimination workflow - Internal Server Error", (Throwable)e);
            return CollectRequestResponse.toVitamError((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (String)e.getLocalizedMessage());
        }
    }

    @POST
    @Path(value="/{transactionId}/deletion/action")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response startDeletionWorkflow(@PathParam(value="transactionId") String transactionId, DeletionRequestBody deletionRequestBody) {
        try {
            SanityChecker.checkParameter((String[])new String[]{transactionId});
            TransactionModel transaction = this.getTransaction(transactionId);
            this.transactionService.ensureTransactionIsOpen(transaction);
            return this.transactionService.startDeletionWorkflow(transactionId, deletionRequestBody, Contexts.COLLECT_DELETION_ACTION);
        }
        catch (InternalServerException | VitamClientException | LogbookClientServerException | OperationContextException | ContentAddressableStorageServerException e) {
            return CollectRequestResponse.toVitamError((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (String)e.getLocalizedMessage());
        }
        catch (InvalidCreateOperationException | BadRequestException | InvalidGuidOperationException | InvalidParseOperationException | LogbookClientAlreadyExistsException | LogbookClientBadRequestException e) {
            LOGGER.error("Error starting deletion workflow - Bad Request", e);
            return CollectRequestResponse.toVitamError((Response.Status)Response.Status.BAD_REQUEST, (String)e.getLocalizedMessage());
        }
        catch (Exception e) {
            LOGGER.error("Error starting deletion workflow - Internal Server Error", (Throwable)e);
            return CollectRequestResponse.toVitamError((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (String)e.getLocalizedMessage());
        }
    }

    @POST
    @Path(value="/{transactionId}/uploadSip")
    @Consumes(value={"application/octet-stream", "application/zip", "application/x-gzip", "application/gzip", "application/x-tar", "application/x-bzip2"})
    public Response uploadSipAsStreamToTransaction(@PathParam(value="transactionId") String transactionId, @HeaderParam(value="Content-Type") String contentType, InputStream uploadedInputStream) {
        try {
            SanityChecker.checkParameter((String[])new String[]{transactionId, contentType});
            UploadSipResult operationIdDto = new UploadSipResult(this.transactionService.uploadSipOnTransaction(transactionId, contentType, uploadedInputStream));
            return new RequestResponseOK().addResult((Object)operationIdDto).setHttpCode(Response.Status.OK.getStatusCode()).toResponse();
        }
        catch (CollectInternalNotFoundException e) {
            LOGGER.error("Error when uploading SIP to transaction. Not found", (Throwable)e);
            return CollectRequestResponse.toVitamError((Response.Status)Response.Status.NOT_FOUND, (String)e.getLocalizedMessage());
        }
        catch (CollectInternalInvalidRequestException | BadRequestException | InvalidGuidOperationException | InvalidParseOperationException | LogbookClientAlreadyExistsException | LogbookClientBadRequestException | ContentAddressableStorageNotFoundException | IllegalArgumentException e) {
            LOGGER.error("Error when uploading SIP to transaction. Bad Request: {}", (Object)e.getMessage(), (Object)e);
            return CollectRequestResponse.toVitamError((Response.Status)Response.Status.BAD_REQUEST, (String)e.getLocalizedMessage());
        }
        catch (Exception e) {
            LOGGER.error("Error when uploading SIP to transaction. Internal Server Error: {}", (Object)e.getMessage(), (Object)e);
            return CollectRequestResponse.toVitamError((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (String)e.getLocalizedMessage());
        }
    }

    private TransactionModel getTransaction(String transactionId) throws CollectInternalException {
        Optional transactionModel = this.transactionService.findTransaction(transactionId);
        if (transactionModel.isEmpty()) {
            throw new CollectInternalNotFoundException("No such transaction '" + transactionId + "'");
        }
        return (TransactionModel)transactionModel.get();
    }
}

