/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.collect.internal;

import fr.gouv.vitam.collect.internal.core.configuration.CollectInternalConfiguration;
import fr.gouv.vitam.collect.internal.server.BusinessApplication;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.ServerIdentity;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.exception.VitamApplicationServerException;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.server.application.resources.VitamServiceRegistry;
import fr.gouv.vitam.common.serverv2.VitamStarter;
import fr.gouv.vitam.common.serverv2.application.AdminApplication;

public class CollectInternalMain {
    public static final String PARAMETER_JETTY_SERVER_PORT = "jetty.collect-internal.port";
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(CollectInternalMain.class);
    private static final String CONF_FILE_NAME = "collect-internal.conf";
    private static final String MODULE_NAME = ServerIdentity.getInstance().getRole();
    private final VitamStarter vitamStarter;

    public CollectInternalMain(String configurationFile) {
        ParametersChecker.checkParameter((String)String.format("Config file %s is a mandatory argument. ", CONF_FILE_NAME), (String[])new String[]{configurationFile});
        this.vitamStarter = new VitamStarter(CollectInternalConfiguration.class, configurationFile, BusinessApplication.class, AdminApplication.class);
    }

    public static void main(String[] args) {
        if (args == null || args.length == 0) {
            LOGGER.error(String.format("Config file %s is a mandatory argument. ", CONF_FILE_NAME));
            throw new IllegalArgumentException(String.format("Config file %s is a mandatory argument. ", CONF_FILE_NAME));
        }
        CollectInternalMain collectInternalMain = new CollectInternalMain(args[0]);
        try {
            VitamServiceRegistry serviceRegistry = new VitamServiceRegistry();
            serviceRegistry.checkDependencies(VitamConfiguration.getRetryNumber().intValue(), (long)VitamConfiguration.getRetryDelay().intValue());
            collectInternalMain.startAndJoin();
        }
        catch (VitamApplicationServerException | InterruptedException e) {
            LOGGER.error(String.format("%s application server can not start. ", MODULE_NAME) + e.getMessage(), e);
            try {
                collectInternalMain.stop();
            }
            catch (VitamApplicationServerException ex) {
                LOGGER.error("Error when trying to stop Collect application: \n", e);
                ex.printStackTrace();
            }
            System.exit(1);
        }
    }

    public void start() throws VitamApplicationServerException {
        this.vitamStarter.start();
    }

    public void startAndJoin() throws VitamApplicationServerException {
        this.vitamStarter.run();
    }

    public void stop() throws VitamApplicationServerException {
        this.vitamStarter.stop();
    }
}

