/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.format.identification.siegfried;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.client.AbstractMockClient;
import fr.gouv.vitam.common.format.identification.exception.FormatIdentifierNotFoundException;
import fr.gouv.vitam.common.format.identification.exception.FormatIdentifierTechnicalException;
import fr.gouv.vitam.common.format.identification.siegfried.SiegfriedClient;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import java.nio.file.Path;

class SiegfriedClientMock
extends AbstractMockClient
implements SiegfriedClient {
    SiegfriedClientMock() {
    }

    @Override
    public RequestResponse<JsonNode> status(Path filePath) throws FormatIdentifierTechnicalException, FormatIdentifierNotFoundException {
        return new RequestResponseOK().addResult((Object)this.getVersionJson());
    }

    @Override
    public RequestResponse<JsonNode> analysePath(Path filePath) throws FormatIdentifierTechnicalException, FormatIdentifierNotFoundException {
        return new RequestResponseOK().addResult((Object)this.getFormatJson(filePath));
    }

    private JsonNode getVersionJson() {
        String versionResponse = "{\"siegfried\":\"mock-1.0\"}";
        return SiegfriedClientMock.getJsonNode("{\"siegfried\":\"mock-1.0\"}");
    }

    private JsonNode getFormatJson(Path path) {
        String okResponse = path.endsWith(".zip") ? "{\"files\":[{\"matches\":[{\"ns\": \"pronom\",\"id\": \"x-fmt/263\",\"format\": \"ZIP Format\",\"mime\": \"application/zip\"}]}]}" : (path.endsWith(".tar.gz") ? "{\"files\":[{\"matches\":[{\"ns\": \"pronom\",\"id\": \"x-fmt/266\",\"format\": \"TAR GZIP Format\",\"mime\": \"application/x-tar\"}]}]}" : (path.endsWith(".tar.bz2") ? "{\"files\":[{\"matches\":[{\"ns\": \"pronom\",\"id\": \"x-fmt/267\",\"format\": \"TAR BZ2 Format\",\"mime\": \"application/x-bzip2\"}]}]}" : (path.endsWith(".tar") ? "{\"files\":[{\"matches\":[{\"ns\": \"pronom\",\"id\": \"x-fmt/265\",\"format\": \"TAR Format\",\"mime\": \"application/x-tar\"}]}]}" : (path.endsWith(".pdf") ? "{\"files\":[{\"matches\":[{\"ns\": \"pronom\",\"id\": \"x-fmt/18\",\"format\": \"PDF Format\",\"mime\": \"application/pdf\"}]}]}" : (path.endsWith(".jpg") ? "{\"files\":[{\"matches\":[{\"ns\": \"pronom\",\"id\": \"fmt/43\",\"format\": \"JPG Format\",\"mime\": \"image/jpeg\"}]}]}" : (path.endsWith(".png") ? "{\"files\":[{\"matches\":[{\"ns\": \"pronom\",\"id\": \"fmt/12\",\"format\": \"PNG Format\",\"mime\": \"image/png\"}]}]}" : (path.endsWith(".ods") ? "{\"files\":[{\"matches\":[{\"ns\": \"pronom\",\"id\": \"fmt/295\",\"format\": \"ODS Format\",\"mime\": \"application/vnd.oasis.opendocument.spreadsheet\"}]}]}" : (path.endsWith(".odt") ? "{\"files\":[{\"matches\":[{\"ns\": \"pronom\",\"id\": \"fmt/290\",\"format\": \"ODT Format\",\"mime\": \"application/vnd.oasis.opendocument.text\"}]}]}" : (path.endsWith(".doc") ? "{\"files\":[{\"matches\":[{\"ns\": \"pronom\",\"id\": \"fmt/40\",\"format\": \"DOC Format\",\"mime\": \"application/msword\"}]}]}" : (path.endsWith(".xls") ? "{\"files\":[{\"matches\":[{\"ns\": \"pronom\",\"id\": \"fmt/61\",\"format\": \"XLS Format\",\"mime\": \"application/vnd.ms-excel\"}]}]}" : "{\"files\":[{\"matches\":[{\"ns\": \"pronom\",\"id\": \"x-fmt/263\",\"format\": \"ZIP Format\",\"mime\": \"application/zip\"}]}]}"))))))))));
        return SiegfriedClientMock.getJsonNode(okResponse);
    }

    private static JsonNode getJsonNode(String jsonString) {
        try {
            return JsonHandler.getFromString((String)jsonString);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }
}

