/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.format.identification.siegfried;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.format.identification.FormatIdentifier;
import fr.gouv.vitam.common.format.identification.exception.FileFormatNotFoundException;
import fr.gouv.vitam.common.format.identification.exception.FormatIdentifierBadRequestException;
import fr.gouv.vitam.common.format.identification.exception.FormatIdentifierNotFoundException;
import fr.gouv.vitam.common.format.identification.exception.FormatIdentifierTechnicalException;
import fr.gouv.vitam.common.format.identification.model.FormatIdentifierInfo;
import fr.gouv.vitam.common.format.identification.model.FormatIdentifierResponse;
import fr.gouv.vitam.common.format.identification.siegfried.SiegfriedClient;
import fr.gouv.vitam.common.format.identification.siegfried.SiegfriedClientFactory;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.RequestResponse;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class FormatIdentifierSiegfried
implements FormatIdentifier {
    public static final String PRONOM_NAMESPACE = "pronom";
    public static final String UNKNOW_NAMESPACE = "UNKNOWN";
    private final Path versionPath;
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(FormatIdentifierSiegfried.class);
    private final SiegfriedClientFactory siegfriedClientFactory;

    public FormatIdentifierSiegfried(Map<String, Object> configurationProperties) throws FormatIdentifierTechnicalException {
        ParametersChecker.checkParameter((String)"Client type cannot be null", (Object[])new Object[]{configurationProperties.get("client")});
        ParametersChecker.checkParameter((String)"Root path cannot be null", (Object[])new Object[]{configurationProperties.get("rootPath")});
        ParametersChecker.checkParameter((String)"Version pathcannot be null", (Object[])new Object[]{configurationProperties.get("versionPath")});
        String clientType = (String)configurationProperties.get("client");
        String version = (String)configurationProperties.get("versionPath");
        this.siegfriedClientFactory = SiegfriedClientFactory.getInstance();
        if ("http".equals(clientType)) {
            ParametersChecker.checkParameter((String)"Host cannot be null", (Object[])new Object[]{configurationProperties.get("host")});
            ParametersChecker.checkParameter((String)"Port cannot be null", (Object[])new Object[]{configurationProperties.get("port")});
            String host = (String)configurationProperties.get("host");
            int port = (Integer)configurationProperties.get("port");
            this.siegfriedClientFactory.changeConfiguration(host, port);
            this.versionPath = Paths.get(version, new String[0]);
            Boolean createVersionPath = (Boolean)configurationProperties.get("createVersionPath");
            if (createVersionPath == null || createVersionPath.booleanValue()) {
                try {
                    Files.createDirectories(this.versionPath, new FileAttribute[0]);
                }
                catch (IOException e) {
                    throw new FormatIdentifierTechnicalException(e);
                }
            }
        } else {
            LOGGER.info("Bad value of client. Use mock");
            this.siegfriedClientFactory.changeConfiguration(null, 0);
            this.versionPath = Paths.get(version, new String[0]);
        }
    }

    @VisibleForTesting
    public FormatIdentifierSiegfried(SiegfriedClientFactory siegfriedClientFactory, Path versionPath) {
        this.siegfriedClientFactory = siegfriedClientFactory;
        this.versionPath = versionPath;
    }

    @Override
    public FormatIdentifierInfo status() throws FormatIdentifierTechnicalException, FormatIdentifierNotFoundException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Check Siegfried status");
        }
        try (SiegfriedClient siegfriedClient = this.siegfriedClientFactory.getClient();){
            RequestResponse<JsonNode> response = siegfriedClient.status(this.versionPath);
            String version = response.toJsonNode().get("$results").get(0).get("siegfried").asText();
            FormatIdentifierInfo formatIdentifierInfo = new FormatIdentifierInfo(version, "Siegfried");
            return formatIdentifierInfo;
        }
    }

    @Override
    public List<FormatIdentifierResponse> analysePath(Path path) throws FileFormatNotFoundException, FormatIdentifierBadRequestException, FormatIdentifierTechnicalException, FormatIdentifierNotFoundException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("identify format for " + String.valueOf(path));
        }
        try (SiegfriedClient siegfriedClient = this.siegfriedClientFactory.getClient();){
            RequestResponse<JsonNode> response = siegfriedClient.analysePath(path);
            List<FormatIdentifierResponse> list = this.extractFormat(response.toJsonNode().get("$results").get(0), path);
            return list;
        }
    }

    private List<FormatIdentifierResponse> extractFormat(JsonNode siegfriedResponse, Path path) throws FileFormatNotFoundException, FormatIdentifierBadRequestException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("extract format from siegfried response");
        }
        ArrayList<FormatIdentifierResponse> matchesFormats = new ArrayList<FormatIdentifierResponse>();
        ArrayNode files = (ArrayNode)siegfriedResponse.get("files");
        if (files == null || files.size() != 1) {
            throw new FormatIdentifierBadRequestException("The given path is not link to an unique file");
        }
        JsonNode file = files.get(0);
        ArrayNode matches = (ArrayNode)file.get("matches");
        for (JsonNode match : matches) {
            JsonNode warnNode;
            LOGGER.debug("Check match {}", (Object)match);
            String formatId = match.get("id").asText();
            String namespace = match.get("ns").asText();
            if (this.formatResolved(formatId, namespace)) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Find a format " + formatId + " for " + namespace);
                }
                String mimetype = match.get("mime").asText();
                String format = match.get("format").asText();
                FormatIdentifierResponse formatIdentifier = new FormatIdentifierResponse(format, mimetype, formatId, namespace);
                matchesFormats.add(formatIdentifier);
                continue;
            }
            if (!PRONOM_NAMESPACE.equals(namespace) || (warnNode = match.get("warning")) == null) continue;
            String warn = warnNode.asText();
            int pos = warn.indexOf("fmt/");
            int xpos = warn.indexOf("x-fmt/");
            int start = -1;
            start = pos > 0 && xpos > 0 ? (pos < xpos ? pos : xpos) : (pos > 0 ? pos : xpos);
            if (start <= 0) continue;
            int end = warn.indexOf(44, start);
            if (end == -1) {
                end = warn.length();
            }
            if (end <= start) continue;
            String newFormatId = warn.substring(start, end);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Find a format " + formatId + " for " + namespace);
            }
            String mimetype = "application/octet-stream";
            String format = "Approximative format: " + newFormatId;
            FormatIdentifierResponse formatIdentifier = new FormatIdentifierResponse(format, "application/octet-stream", newFormatId, namespace);
            matchesFormats.add(formatIdentifier);
        }
        if (matchesFormats.isEmpty()) {
            LOGGER.warn("No format match found for file " + String.valueOf(path));
            throw new FileFormatNotFoundException("No match found");
        }
        return matchesFormats;
    }

    private boolean formatResolved(String formatId, String nameSpace) {
        return !PRONOM_NAMESPACE.equals(nameSpace) || !UNKNOW_NAMESPACE.equals(formatId);
    }
}

