/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.format.identification;

import fr.gouv.vitam.common.format.identification.FormatIdentifier;
import fr.gouv.vitam.common.format.identification.model.FormatIdentifierInfo;
import fr.gouv.vitam.common.format.identification.model.FormatIdentifierResponse;
import fr.gouv.vitam.common.logging.SysErrLogger;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;

class FormatIdentifierMock
implements FormatIdentifier {
    public static final String ZIP = "zip";

    FormatIdentifierMock() {
    }

    @Override
    public List<FormatIdentifierResponse> analysePath(Path pathToFile) {
        try {
            if (this.isProbableZip(pathToFile) && this.isProbableSipFile(pathToFile)) {
                String formatLitteral = "Zip File";
                String mimeType = "application/zip";
                String formatId = "x-fmt/263";
                String ns = "pronom";
                return Collections.singletonList(new FormatIdentifierResponse(formatLitteral, mimeType, formatId, ns));
            }
        }
        catch (IOException e) {
            SysErrLogger.FAKE_LOGGER.ignoreLog((Throwable)e);
        }
        String formatLitteral = "Plain Text File";
        String mimeType = "text/plain";
        String formatId = "x-fmt/111";
        String ns = "pronom";
        return Collections.singletonList(new FormatIdentifierResponse(formatLitteral, mimeType, formatId, ns));
    }

    private boolean isProbableZip(Path pathToFile) throws IOException {
        try (FileInputStream fis = new FileInputStream(pathToFile.toFile());){
            boolean bl = fis.read() == 80 && fis.read() == 75;
            return bl;
        }
    }

    private boolean isProbableSipFile(Path pathToFile) throws IOException {
        try (ZipFile zipFile = new ZipFile(pathToFile.toFile());){
            Enumeration entries = zipFile.getEntries();
            while (entries.hasMoreElements()) {
                ZipArchiveEntry entry = (ZipArchiveEntry)entries.nextElement();
                if (!entry.getName().matches("^([a-zA-Z0-9_\\-]{0,56}[_-]{1}){0,1}(manifest.xml)\\b")) continue;
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    @Override
    public FormatIdentifierInfo status() {
        return new FormatIdentifierInfo("1.0", "FormatIdentifierMock");
    }
}

