/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.format.identification;

import com.fasterxml.jackson.core.type.TypeReference;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.PropertiesUtils;
import fr.gouv.vitam.common.format.identification.FormatIdentifier;
import fr.gouv.vitam.common.format.identification.FormatIdentifierMock;
import fr.gouv.vitam.common.format.identification.exception.FormatIdentifierFactoryException;
import fr.gouv.vitam.common.format.identification.exception.FormatIdentifierNotFoundException;
import fr.gouv.vitam.common.format.identification.exception.FormatIdentifierTechnicalException;
import fr.gouv.vitam.common.format.identification.model.FormatIdentifierConfiguration;
import fr.gouv.vitam.common.format.identification.siegfried.FormatIdentifierSiegfried;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class FormatIdentifierFactory {
    private static final String FORMAT_IDENTIFIER_ID_NOT_NULL = "formatIdentifierId cannot be null";
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(FormatIdentifierFactory.class);
    private static final FormatIdentifierFactory FORMAT_IDENTIFIER_FACTORY = new FormatIdentifierFactory();
    private final Map<String, FormatIdentifierConfiguration> configurationsFormatIdentifiers = Collections.synchronizedMap(new HashMap());
    private static final String FORMAT_IDENTIFIERS_CONF_FILE = "format-identifiers.conf";

    private FormatIdentifierFactory() {
        this.changeConfigurationFile(FORMAT_IDENTIFIERS_CONF_FILE);
    }

    public final void changeConfigurationFile(String configurationPath) {
        try {
            File configurationFile = PropertiesUtils.findFile((String)configurationPath);
            if (configurationFile != null) {
                Map configMap = (Map)PropertiesUtils.readYaml((File)configurationFile, (TypeReference)new TypeReference<Map<String, FormatIdentifierConfiguration>>(this){});
                for (FormatIdentifierConfiguration configuration : configMap.values()) {
                    this.checkConfiguration(configuration);
                }
                this.configurationsFormatIdentifiers.clear();
                this.configurationsFormatIdentifiers.putAll(configMap);
            }
        }
        catch (IOException e) {
            LOGGER.warn("could not load format identifiers configuration for file {}, no format identifier available", (Object)configurationPath, (Object)e);
        }
    }

    public static FormatIdentifierFactory getInstance() {
        return FORMAT_IDENTIFIER_FACTORY;
    }

    public FormatIdentifier getFormatIdentifierFor(String formatIdentifierId) throws FormatIdentifierNotFoundException, FormatIdentifierFactoryException, FormatIdentifierTechnicalException {
        ParametersChecker.checkParameter((String)FORMAT_IDENTIFIER_ID_NOT_NULL, (String[])new String[]{formatIdentifierId});
        return this.instanciate(formatIdentifierId);
    }

    public void addFormatIdentifier(String formatIdentifierId, FormatIdentifierConfiguration configuration) {
        ParametersChecker.checkParameter((String)FORMAT_IDENTIFIER_ID_NOT_NULL, (String[])new String[]{formatIdentifierId});
        this.checkConfiguration(configuration);
        this.configurationsFormatIdentifiers.put(formatIdentifierId, configuration);
    }

    public void removeFormatIdentifier(String formatIdentifierId) throws FormatIdentifierNotFoundException {
        ParametersChecker.checkParameter((String)FORMAT_IDENTIFIER_ID_NOT_NULL, (String[])new String[]{formatIdentifierId});
        if (this.configurationsFormatIdentifiers.remove(formatIdentifierId) == null) {
            throw new FormatIdentifierNotFoundException("Can't remove " + formatIdentifierId + " because no configuration with this name is registered");
        }
    }

    private FormatIdentifier instanciate(String formatIdentifierId) throws FormatIdentifierFactoryException, FormatIdentifierNotFoundException, FormatIdentifierTechnicalException {
        FormatIdentifierConfiguration infos = this.configurationsFormatIdentifiers.get(formatIdentifierId);
        if (infos == null) {
            throw new FormatIdentifierNotFoundException("Format Identifier configuration can't be found for id " + formatIdentifierId);
        }
        switch (infos.getType()) {
            case MOCK: {
                return new FormatIdentifierMock();
            }
            case SIEGFRIED: {
                return new FormatIdentifierSiegfried(infos.getConfigurationProperties());
            }
        }
        throw new FormatIdentifierFactoryException("Format Identifier Configuration implementation can't be found for id " + formatIdentifierId);
    }

    private void checkConfiguration(FormatIdentifierConfiguration configuration) {
        ParametersChecker.checkParameter((String)"Configuration cannot be null", (Object[])new Object[]{configuration});
        ParametersChecker.checkParameter((String)"Type cannot be null", (Object[])new Object[]{configuration.getType()});
    }
}

