/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.workspace.rest;

import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.ServerIdentity;
import fr.gouv.vitam.common.exception.VitamApplicationServerException;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.serverv2.VitamStarter;
import fr.gouv.vitam.common.serverv2.application.AdminApplication;
import fr.gouv.vitam.common.storage.StorageConfiguration;
import fr.gouv.vitam.workspace.rest.BusinessApplication;

public class WorkspaceMain {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(WorkspaceMain.class);
    public static final String PARAMETER_JETTY_SERVER_PORT = "jetty.workspace.port";
    private static final String CONF_FILE_NAME = "workspace.conf";
    private static final String MODULE_NAME = ServerIdentity.getInstance().getRole();
    private VitamStarter vitamStarter;

    public WorkspaceMain(String configurationFile) {
        ParametersChecker.checkParameter((String)String.format("Config file %s is a mandatory argument. ", CONF_FILE_NAME), (String[])new String[]{configurationFile});
        this.vitamStarter = new VitamStarter(StorageConfiguration.class, configurationFile, BusinessApplication.class, AdminApplication.class);
    }

    public static void main(String[] args) {
        try {
            if (args == null || args.length == 0) {
                LOGGER.error(String.format("Config file %s is a mandatory argument. ", CONF_FILE_NAME));
                throw new IllegalArgumentException(String.format("Config file %s is a mandatory argument. ", CONF_FILE_NAME));
            }
            WorkspaceMain workspaceMain = new WorkspaceMain(args[0]);
            workspaceMain.startAndJoin();
        }
        catch (Exception e) {
            LOGGER.error(String.format("%s application server can not start. ", MODULE_NAME) + e.getMessage(), (Throwable)e);
            System.exit(1);
        }
    }

    public void start() throws VitamApplicationServerException {
        this.vitamStarter.start();
    }

    public void startAndJoin() throws VitamApplicationServerException {
        this.vitamStarter.run();
    }

    public void stop() throws VitamApplicationServerException {
        this.vitamStarter.stop();
    }
}

