/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.batch.report.model;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(value={"total"}, allowGetters=true)
public class ReportResults {
    @JsonProperty(value="OK")
    private Integer nbOk;
    @JsonProperty(value="KO")
    private Integer nbKo;
    @JsonProperty(value="WARNING")
    private Integer nbWarning;

    public ReportResults() {
        this(0, 0, 0);
    }

    public ReportResults(Integer nbOk, Integer nbKo, Integer nbWarning) {
        this.nbOk = nbOk;
        this.nbKo = nbKo;
        this.nbWarning = nbWarning;
    }

    public Integer getNbOk() {
        return this.nbOk;
    }

    public void setNbOk(Integer nbOk) {
        this.nbOk = nbOk;
    }

    public Integer getNbKo() {
        return this.nbKo;
    }

    public void setNbKo(Integer nbKo) {
        this.nbKo = nbKo;
    }

    public Integer getNbWarning() {
        return this.nbWarning;
    }

    public void setNbWarning(Integer nbWarning) {
        this.nbWarning = nbWarning;
    }

    @JsonGetter(value="total")
    public Integer getTotal() {
        return this.nbOk + this.nbWarning + this.nbKo;
    }

    public void addOneStatus(String status, Integer count) {
        switch (status) {
            case "OK": {
                this.nbOk = count;
                break;
            }
            case "WARNING": {
                this.nbWarning = count;
                break;
            }
            case "KO": {
                this.nbKo = count;
                break;
            }
            default: {
                throw new IllegalArgumentException("Status invalid " + status);
            }
        }
    }

    public void incrementStatus(String status, Integer count) {
        switch (status) {
            case "OK": {
                this.nbOk = this.nbOk + count;
                break;
            }
            case "WARNING": {
                this.nbWarning = this.nbWarning + count;
                break;
            }
            case "KO": {
                this.nbKo = this.nbKo + count;
                break;
            }
            default: {
                throw new IllegalArgumentException("Status invalid " + status);
            }
        }
    }
}

