/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.logbook.common.server.reconstruction;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterators;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.accesslog.AccessLogUtils;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamRuntimeException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.stream.StreamUtils;
import fr.gouv.vitam.logbook.common.server.database.collections.LogbookOperation;
import fr.gouv.vitam.logbook.common.server.reconstruction.LogbookBackupModel;
import fr.gouv.vitam.storage.engine.client.OfferLogHelper;
import fr.gouv.vitam.storage.engine.client.StorageClient;
import fr.gouv.vitam.storage.engine.client.StorageClientFactory;
import fr.gouv.vitam.storage.engine.client.exception.StorageNotFoundClientException;
import fr.gouv.vitam.storage.engine.client.exception.StorageServerClientException;
import fr.gouv.vitam.storage.engine.client.exception.StorageUnavailableDataFromAsyncOfferClientException;
import fr.gouv.vitam.storage.engine.common.exception.StorageException;
import fr.gouv.vitam.storage.engine.common.exception.StorageNotFoundException;
import fr.gouv.vitam.storage.engine.common.model.DataCategory;
import fr.gouv.vitam.storage.engine.common.model.OfferLog;
import fr.gouv.vitam.storage.engine.common.model.Order;
import jakarta.ws.rs.core.Response;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import org.bson.Document;

public class RestoreBackupService {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(RestoreBackupService.class);
    private StorageClientFactory storageClientFactory;

    public RestoreBackupService() {
        this(StorageClientFactory.getInstance());
    }

    @VisibleForTesting
    public RestoreBackupService(StorageClientFactory storageClientFactory) {
        this.storageClientFactory = storageClientFactory;
    }

    public Iterator<List<OfferLog>> getListing(String strategy, long offset, int limit) throws StorageServerClientException, StorageNotFoundClientException {
        LOGGER.info(String.format("[Reconstruction]: Retrieve listing of {%s} Collection on {%s} Vitam strategy from {%s} offset with {%s} limit", DataCategory.BACKUP_OPERATION.name(), strategy, offset, limit));
        return Iterators.partition((Iterator)OfferLogHelper.getListing((StorageClientFactory)this.storageClientFactory, (String)strategy, (String)this.storageClientFactory.getClient().getReferentOffer(strategy), (DataCategory)DataCategory.BACKUP_OPERATION, (Long)offset, (Order)Order.ASC, (int)VitamConfiguration.getBatchSize(), (Integer)limit), (int)VitamConfiguration.getBatchSize());
    }

    /*
     * Loose catch block
     */
    public LogbookBackupModel loadData(String strategy, String filename, long offset) throws StorageNotFoundException {
        LogbookBackupModel logbookBackupModel;
        StorageClient storageClient;
        Response response;
        InputStream inputStream;
        block10: {
            LOGGER.info(String.format("[Reconstruction]: Retrieve file {%s} from storage of {%s} Collection on {%s} Vitam strategy", filename, DataCategory.BACKUP_OPERATION.name(), strategy));
            inputStream = null;
            response = null;
            storageClient = this.storageClientFactory.getClient();
            DataCategory type = DataCategory.BACKUP_OPERATION;
            String referentOfferForStrategy = storageClient.getReferentOffer(strategy);
            response = storageClient.getContainerAsync(strategy, referentOfferForStrategy, filename, type, AccessLogUtils.getNoLogAccessLog());
            inputStream = (InputStream)response.readEntity(InputStream.class);
            LogbookOperation logbookOperationDocument = new LogbookOperation((JsonNode)JsonHandler.getFromInputStream((InputStream)inputStream, JsonNode.class));
            LogbookBackupModel logbookBackupModel2 = new LogbookBackupModel();
            logbookBackupModel2.setLogbookOperation((Document)logbookOperationDocument);
            logbookBackupModel2.setLogbookId(logbookOperationDocument.getId());
            logbookBackupModel2.setOffset(offset);
            logbookBackupModel = logbookBackupModel2;
            if (storageClient == null) break block10;
            storageClient.close();
        }
        StreamUtils.closeSilently((InputStream)inputStream);
        StreamUtils.consumeAnyEntityAndClose((Response)response);
        return logbookBackupModel;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        if (storageClient != null) {
                            try {
                                storageClient.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (InvalidParseOperationException | StorageNotFoundClientException | StorageServerClientException | StorageUnavailableDataFromAsyncOfferClientException | StorageException e) {
                        throw new VitamRuntimeException("ERROR: Exception has been thrown when using storage service:", e);
                    }
                }
                catch (Throwable throwable3) {
                    StreamUtils.closeSilently(inputStream);
                    StreamUtils.consumeAnyEntityAndClose(response);
                    throw throwable3;
                }
            }
        }
    }
}

