/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.logbook.common.server.database.collections;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.logbook.common.server.database.collections.LogbookMongoDbName;
import java.util.List;
import org.bson.Document;

public class LogbookTransformData {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(LogbookTransformData.class);

    private LogbookTransformData() {
    }

    public static void transformDataForElastic(Document document) {
        List eventDocuments;
        if (document.get((Object)LogbookMongoDbName.eventDetailData.getDbname()) != null) {
            String evDetDataString = (String)document.get((Object)LogbookMongoDbName.eventDetailData.getDbname());
            LOGGER.debug(evDetDataString);
            try {
                JsonNode evDetData = JsonHandler.getFromString((String)evDetDataString);
                document.remove((Object)LogbookMongoDbName.eventDetailData.getDbname());
                document.put(LogbookMongoDbName.eventDetailData.getDbname(), (Object)evDetData);
            }
            catch (InvalidParseOperationException e) {
                LOGGER.warn("EvDetData is not a json compatible field", (Throwable)e);
            }
        }
        if (document.get((Object)LogbookMongoDbName.agIdExt.getDbname()) != null) {
            String agidExt = (String)document.get((Object)LogbookMongoDbName.agIdExt.getDbname());
            LOGGER.debug(agidExt);
            try {
                JsonNode agidExtNode = JsonHandler.getFromString((String)agidExt);
                document.remove((Object)LogbookMongoDbName.agIdExt.getDbname());
                document.put(LogbookMongoDbName.agIdExt.getDbname(), (Object)agidExtNode);
            }
            catch (InvalidParseOperationException e) {
                LOGGER.warn("agidExtNode is not a json compatible field", (Throwable)e);
            }
        }
        if (document.get((Object)LogbookMongoDbName.rightsStatementIdentifier.getDbname()) != null) {
            String rightsStatementIdentifier = (String)document.get((Object)LogbookMongoDbName.rightsStatementIdentifier.getDbname());
            LOGGER.debug(rightsStatementIdentifier);
            try {
                JsonNode rightsStatementIdentifierNode = JsonHandler.getFromString((String)rightsStatementIdentifier);
                document.remove((Object)LogbookMongoDbName.rightsStatementIdentifier.getDbname());
                document.put(LogbookMongoDbName.rightsStatementIdentifier.getDbname(), (Object)rightsStatementIdentifierNode);
            }
            catch (InvalidParseOperationException e) {
                LOGGER.warn("rightsStatementIdentifier is not a json compatible field", (Throwable)e);
            }
        }
        if ((eventDocuments = document.getList((Object)"events", Document.class)) != null) {
            for (Document eventDocument : eventDocuments) {
                Document eventEvDetDataDocument;
                if (eventDocument.getString((Object)LogbookMongoDbName.eventDetailData.getDbname()) != null) {
                    String eventEvDetDataString = eventDocument.getString((Object)LogbookMongoDbName.eventDetailData.getDbname());
                    eventEvDetDataDocument = Document.parse((String)eventEvDetDataString);
                    eventDocument.remove((Object)LogbookMongoDbName.eventDetailData.getDbname());
                    eventDocument.put(LogbookMongoDbName.eventDetailData.getDbname(), (Object)eventEvDetDataDocument);
                }
                if (eventDocument.getString((Object)LogbookMongoDbName.rightsStatementIdentifier.getDbname()) != null) {
                    String eventrightsStatementIdentifier = eventDocument.getString((Object)LogbookMongoDbName.rightsStatementIdentifier.getDbname());
                    eventEvDetDataDocument = Document.parse((String)eventrightsStatementIdentifier);
                    eventDocument.remove((Object)LogbookMongoDbName.rightsStatementIdentifier.getDbname());
                    eventDocument.put(LogbookMongoDbName.rightsStatementIdentifier.getDbname(), (Object)eventEvDetDataDocument);
                }
                if (eventDocument.getString((Object)LogbookMongoDbName.agIdExt.getDbname()) == null) continue;
                String eventagIdExt = eventDocument.getString((Object)LogbookMongoDbName.agIdExt.getDbname());
                eventEvDetDataDocument = Document.parse((String)eventagIdExt);
                eventDocument.remove((Object)LogbookMongoDbName.agIdExt.getDbname());
                eventDocument.put(LogbookMongoDbName.agIdExt.getDbname(), (Object)eventEvDetDataDocument);
            }
        }
        document.remove((Object)"events");
        document.put("events", (Object)eventDocuments);
    }
}

