/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.logbook.common.server.database.collections;

import co.elastic.clients.elasticsearch.core.search.Hit;
import co.elastic.clients.elasticsearch.core.search.HitsMetadata;
import co.elastic.clients.elasticsearch.core.search.ResponseBody;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.mongodb.BasicDBObject;
import com.mongodb.ErrorCategory;
import com.mongodb.MongoException;
import com.mongodb.bulk.BulkWriteResult;
import com.mongodb.client.FindIterable;
import com.mongodb.client.ListIndexesIterable;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoIterable;
import com.mongodb.client.model.BulkWriteOptions;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.Indexes;
import com.mongodb.client.model.InsertOneModel;
import com.mongodb.client.model.Projections;
import com.mongodb.client.model.ReturnDocument;
import com.mongodb.client.model.UpdateOneModel;
import com.mongodb.client.model.Updates;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.client.OntologyLoader;
import fr.gouv.vitam.common.database.builder.query.NopQuery;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.query.QueryHelper;
import fr.gouv.vitam.common.database.builder.query.VitamFieldsHelper;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.single.Select;
import fr.gouv.vitam.common.database.collections.DynamicParserTokens;
import fr.gouv.vitam.common.database.parser.request.AbstractParser;
import fr.gouv.vitam.common.database.parser.request.adapter.VarNameAdapter;
import fr.gouv.vitam.common.database.parser.request.single.RequestParserSingle;
import fr.gouv.vitam.common.database.parser.request.single.SelectParserSingle;
import fr.gouv.vitam.common.database.server.DbRequestHelper;
import fr.gouv.vitam.common.database.server.mongodb.BsonHelper;
import fr.gouv.vitam.common.database.server.mongodb.EmptyMongoCursor;
import fr.gouv.vitam.common.database.server.mongodb.MongoDbAccess;
import fr.gouv.vitam.common.database.server.mongodb.VitamDocument;
import fr.gouv.vitam.common.database.server.mongodb.VitamMongoCursor;
import fr.gouv.vitam.common.database.translators.elasticsearch.SelectToElasticsearch;
import fr.gouv.vitam.common.database.translators.mongodb.QueryToMongodb;
import fr.gouv.vitam.common.database.translators.mongodb.SelectToMongodb;
import fr.gouv.vitam.common.exception.DatabaseException;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamDBException;
import fr.gouv.vitam.common.exception.VitamRuntimeException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.parameter.ParameterHelper;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.logbook.common.model.LogbookLifeCycleModel;
import fr.gouv.vitam.logbook.common.parameters.LogbookLifeCycleObjectGroupParameters;
import fr.gouv.vitam.logbook.common.parameters.LogbookLifeCycleParametersBulk;
import fr.gouv.vitam.logbook.common.parameters.LogbookLifeCycleUnitParameters;
import fr.gouv.vitam.logbook.common.parameters.LogbookOperationParameters;
import fr.gouv.vitam.logbook.common.parameters.LogbookParameterName;
import fr.gouv.vitam.logbook.common.parameters.LogbookParameters;
import fr.gouv.vitam.logbook.common.parameters.LogbookTypeProcess;
import fr.gouv.vitam.logbook.common.server.LogbookDbAccess;
import fr.gouv.vitam.logbook.common.server.database.collections.LogbookCollections;
import fr.gouv.vitam.logbook.common.server.database.collections.LogbookElasticsearchAccess;
import fr.gouv.vitam.logbook.common.server.database.collections.LogbookLifeCycle;
import fr.gouv.vitam.logbook.common.server.database.collections.LogbookLifeCycleMongoDbName;
import fr.gouv.vitam.logbook.common.server.database.collections.LogbookLifeCycleObjectGroup;
import fr.gouv.vitam.logbook.common.server.database.collections.LogbookLifeCycleObjectGroupInProcess;
import fr.gouv.vitam.logbook.common.server.database.collections.LogbookLifeCycleUnit;
import fr.gouv.vitam.logbook.common.server.database.collections.LogbookLifeCycleUnitInProcess;
import fr.gouv.vitam.logbook.common.server.database.collections.LogbookMongoDbName;
import fr.gouv.vitam.logbook.common.server.database.collections.LogbookOperation;
import fr.gouv.vitam.logbook.common.server.database.collections.LogbookTransformData;
import fr.gouv.vitam.logbook.common.server.database.collections.request.LogbookVarNameAdapter;
import fr.gouv.vitam.logbook.common.server.exception.LogbookAlreadyExistsException;
import fr.gouv.vitam.logbook.common.server.exception.LogbookDatabaseException;
import fr.gouv.vitam.logbook.common.server.exception.LogbookException;
import fr.gouv.vitam.logbook.common.server.exception.LogbookExecutionException;
import fr.gouv.vitam.logbook.common.server.exception.LogbookNotFoundException;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.bson.Document;
import org.bson.conversions.Bson;

public final class LogbookMongoDbAccessImpl
extends MongoDbAccess
implements LogbookDbAccess {
    private static final String ITEM_CANNOT_BE_NULL = "Item cannot be null";
    private static final String AT_LEAST_ONE_ITEM_IS_NEEDED = "At least one item is needed";
    private static final String SELECT_ISSUE = "Select issue";
    private static final String ELEMENT_ALREADY_EXISTS = " (element already exists)";
    private static final String TIMEOUT_OPERATION = " (timeout operation)";
    private static final String EXISTS_ISSUE = "Exists issue";
    private static final String SLICE = "$slice";
    private static final String UPDATE_NOT_FOUND_ITEM = "Update not found item: ";
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(LogbookMongoDbAccessImpl.class);
    private static final String SELECT_PARAMETER_IS_NULL = "select parameter is null";
    private static final String LIFECYCLE_ITEM = "lifecycleItem";
    private static final String OPERATION_ITEM = "operationItem";
    private static final String CREATION_ISSUE = "Creation issue";
    private static final String UPDATE_ISSUE = "Update issue";
    private static final String ROLLBACK_ISSUE = "Rollback issue";
    private static final String INIT_UPDATE_LIFECYCLE = "Initialize update lifeCycle process";
    private static final BasicDBObject ID_PROJECTION = new BasicDBObject("_id", (Object)1);
    private static final ObjectNode DEFAULT_SLICE_WITH_ALL_EVENTS = JsonHandler.createObjectNode().put("events", 1);
    private static final ObjectNode DEFAULT_ALLKEYS = JsonHandler.createObjectNode();
    private static final int LAST_EVENT_SLICE = -1;
    private static final int TWO_LAST_EVENTS_SLICE = -2;
    private final LogbookElasticsearchAccess esClient;
    private final OntologyLoader ontologyLoader;

    public LogbookMongoDbAccessImpl(MongoClient mongoClient, String dbname, boolean recreate, LogbookElasticsearchAccess esClient, OntologyLoader ontologyLoader) {
        super(mongoClient, dbname);
        this.esClient = esClient;
        this.ontologyLoader = ontologyLoader;
        LogbookCollections.OPERATION.initialize(this.getMongoDatabase(), recreate);
        LogbookCollections.LIFECYCLE_UNIT.initialize(this.getMongoDatabase(), recreate);
        LogbookCollections.LIFECYCLE_OBJECTGROUP.initialize(this.getMongoDatabase(), recreate);
        LogbookCollections.LIFECYCLE_UNIT_IN_PROCESS.initialize(this.getMongoDatabase(), recreate);
        LogbookCollections.LIFECYCLE_OBJECTGROUP_IN_PROCESS.initialize(this.getMongoDatabase(), recreate);
        LogbookCollections.OPERATION.initialize(this.esClient);
        esClient.createIndexesAndAliases();
    }

    @Override
    public void close() {
        this.getMongoClient().close();
    }

    static void ensureIndex() {
        for (LogbookCollections col : LogbookCollections.values()) {
            if (col.getCollection() == null) continue;
            col.getCollection().createIndex(Indexes.hashed((String)"_id"));
        }
    }

    static void resetIndexAfterImport() {
        LOGGER.info("Rebuild indexes");
        LogbookMongoDbAccessImpl.ensureIndex();
    }

    @Override
    public String getInfo() {
        StringBuilder builder = new StringBuilder();
        MongoIterable collectionNames = this.getMongoDatabase().listCollectionNames();
        for (String s : collectionNames) {
            builder.append(s).append('\n');
        }
        for (LogbookCollections coll : LogbookCollections.values()) {
            if (coll == null || coll.getCollection() == null) continue;
            MongoCollection mcoll = coll.getCollection();
            builder.append(coll.getName()).append(" [").append(mcoll.countDocuments()).append('\n');
            ListIndexesIterable list = mcoll.listIndexes();
            for (Document dbObject : list) {
                builder.append("\t").append(mcoll.countDocuments()).append(' ').append(dbObject).append('\n');
            }
        }
        return builder.toString();
    }

    public LogbookElasticsearchAccess getEsClient() {
        return this.esClient;
    }

    @Override
    public long getLogbookOperationSize() {
        return LogbookCollections.OPERATION.getCollection().countDocuments();
    }

    @Override
    public long getLogbookLifeCyleUnitSize() {
        return LogbookCollections.LIFECYCLE_UNIT.getCollection().countDocuments();
    }

    @Override
    public long getLogbookLifeCyleObjectGroupSize() {
        return LogbookCollections.LIFECYCLE_OBJECTGROUP.getCollection().countDocuments();
    }

    @Override
    public long getLogbookLifeCyleUnitInProcessSize() {
        return LogbookCollections.LIFECYCLE_UNIT_IN_PROCESS.getCollection().countDocuments();
    }

    @Override
    public long getLogbookLifeCyleObjectGroupInProcessSize() {
        return LogbookCollections.LIFECYCLE_OBJECTGROUP_IN_PROCESS.getCollection().countDocuments();
    }

    void flushOnDisk() {
        this.getMongoAdmin().runCommand((Bson)new BasicDBObject("fsync", (Object)1).append("async", (Object)true).append("lock", (Object)false));
    }

    private ErrorCategory getErrorCategory(MongoException e) {
        return ErrorCategory.fromErrorCode((int)e.getCode());
    }

    @Override
    public VitamMongoCursor<LogbookOperation> getLogbookOperations(JsonNode select, boolean sliced) throws LogbookDatabaseException, VitamDBException {
        return this.getLogbookOperations(select, sliced, false);
    }

    @Override
    public VitamMongoCursor<LogbookOperation> getLogbookOperations(JsonNode select, boolean sliced, boolean crossTenant) throws LogbookDatabaseException, VitamDBException {
        ParametersChecker.checkParameter((String)SELECT_PARAMETER_IS_NULL, (Object[])new Object[]{select});
        if (sliced) {
            ObjectNode operationSlice = JsonHandler.createObjectNode();
            operationSlice.putObject("events").put(SLICE, -2);
            return this.select(LogbookCollections.OPERATION, select, operationSlice, crossTenant);
        }
        return this.select(LogbookCollections.OPERATION, select, DEFAULT_SLICE_WITH_ALL_EVENTS, crossTenant);
    }

    @Override
    public LogbookLifeCycle<?> getOneLogbookLifeCycle(JsonNode select, boolean sliced, LogbookCollections collection) throws LogbookDatabaseException, LogbookNotFoundException, VitamDBException {
        MongoCursor<LogbookLifeCycle<?>> result = this.getLogbookLifeCycles(select, sliced, collection);
        if (result.hasNext()) {
            LogbookLifeCycle logbookLifeCycle = (LogbookLifeCycle)((Object)result.next());
            if (result.hasNext()) {
                throw new LogbookDatabaseException("Result size more than 1.");
            }
            return logbookLifeCycle;
        }
        throw new LogbookNotFoundException("Logbook lifecycle was not found");
    }

    @Override
    public MongoCursor<LogbookLifeCycle<?>> getLogbookLifeCycles(JsonNode select, boolean sliced, LogbookCollections collection) throws LogbookDatabaseException, VitamDBException {
        ParametersChecker.checkParameter((String)SELECT_PARAMETER_IS_NULL, (Object[])new Object[]{select});
        if (sliced) {
            ObjectNode operationSlice = JsonHandler.createObjectNode();
            operationSlice.putObject("events").put(SLICE, -1);
            return this.select(collection, select, operationSlice);
        }
        return this.select(collection, select, DEFAULT_SLICE_WITH_ALL_EVENTS);
    }

    public VitamMongoCursor<LogbookLifeCycleUnit> getLogbookLifeCycleUnitsFull(LogbookCollections collection, Select select) throws LogbookDatabaseException {
        ParametersChecker.checkParameter((String)SELECT_PARAMETER_IS_NULL, (Object[])new Object[]{select});
        try {
            return this.findLifecyleLogbooksFromMongo(collection, select);
        }
        catch (InvalidParseOperationException e) {
            throw new LogbookDatabaseException(e);
        }
    }

    public VitamMongoCursor<LogbookLifeCycleObjectGroup> getLogbookLifeCycleObjectGroupsFull(LogbookCollections collection, Select select) throws LogbookDatabaseException {
        ParametersChecker.checkParameter((String)SELECT_PARAMETER_IS_NULL, (Object[])new Object[]{select});
        try {
            return this.findLifecyleLogbooksFromMongo(collection, select);
        }
        catch (InvalidParseOperationException e) {
            throw new LogbookDatabaseException(e);
        }
    }

    boolean exists(LogbookCollections collection, String id) throws LogbookDatabaseException {
        try {
            return collection.getCollection().find(Filters.eq((String)"_id", (Object)id)).projection((Bson)ID_PROJECTION).first() != null;
        }
        catch (MongoException e) {
            switch (this.getErrorCategory(e)) {
                case EXECUTION_TIMEOUT: {
                    throw new LogbookDatabaseException("Exists issue (timeout operation)", e);
                }
            }
            throw new LogbookDatabaseException("Exists issue (" + ((Object)((Object)e)).getClass().getName() + " " + e.getMessage() + ": " + e.getCode() + ")", e);
        }
    }

    @Override
    public boolean existsLogbookOperation(String operationItem) throws LogbookDatabaseException {
        ParametersChecker.checkParameter((String)OPERATION_ITEM, (String[])new String[]{operationItem});
        return this.exists(LogbookCollections.OPERATION, operationItem);
    }

    @Override
    public boolean existsLogbookLifeCycleUnit(String unitId) throws LogbookDatabaseException {
        ParametersChecker.checkParameter((String)LIFECYCLE_ITEM, (String[])new String[]{unitId});
        return this.exists(LogbookCollections.LIFECYCLE_UNIT, unitId);
    }

    @Override
    public boolean existsLogbookLifeCycleObjectGroup(String objectGroupId) throws LogbookDatabaseException {
        ParametersChecker.checkParameter((String)LIFECYCLE_ITEM, (String[])new String[]{objectGroupId});
        return this.exists(LogbookCollections.LIFECYCLE_OBJECTGROUP, objectGroupId);
    }

    private <T extends LogbookLifeCycle<?>> T getLogbookLFC(MongoCollection<T> collection, String id) throws LogbookDatabaseException, LogbookNotFoundException {
        ParametersChecker.checkParameter((String)"Logbook item", (String[])new String[]{id});
        try {
            LogbookLifeCycle item = (LogbookLifeCycle)((Object)collection.find(Filters.and((Bson[])new Bson[]{Filters.eq((String)"_id", (Object)id), Filters.eq((String)"_tenant", (Object)ParameterHelper.getTenantParameter())})).first());
            if (item == null) {
                throw new LogbookNotFoundException("Logbook item not found");
            }
            return (T)((Object)item);
        }
        catch (MongoException e) {
            switch (this.getErrorCategory(e)) {
                case EXECUTION_TIMEOUT: {
                    throw new LogbookDatabaseException("Select issue (timeout operation)", e);
                }
            }
            throw new LogbookDatabaseException("Select issue (" + ((Object)((Object)e)).getClass().getName() + " " + e.getMessage() + ": " + e.getCode() + ")", e);
        }
    }

    @Override
    public LogbookOperation getLogbookOperationById(String eventIdentifierProcess) throws LogbookDatabaseException, LogbookNotFoundException {
        return this.getLogbookOperationById(eventIdentifierProcess, (JsonNode)new Select().getFinalSelect(), false, false);
    }

    @Override
    public LogbookOperation getLogbookOperationById(@Nonnull String eventIdentifierProcess, @Nonnull JsonNode query, boolean sliced, boolean crossTenant) throws LogbookDatabaseException, LogbookNotFoundException {
        try {
            LogbookOperation result;
            SelectParserSingle parser = new SelectParserSingle((VarNameAdapter)new LogbookVarNameAdapter());
            parser.parse(query);
            parser.addCondition((Query)QueryHelper.eq((String)VitamFieldsHelper.id(), (String)eventIdentifierProcess));
            if (sliced) {
                ObjectNode operationSlice = JsonHandler.createObjectNode();
                operationSlice.putObject("events").put(SLICE, -2);
                parser.addProjection(operationSlice, DEFAULT_ALLKEYS);
            }
            SelectToMongodb selectToMongoDb = new SelectToMongodb((AbstractParser)parser);
            Bson finalQuery = QueryToMongodb.getCommand((Query)selectToMongoDb.getSingleSelect().getQuery());
            Bson condition = Filters.and((Bson[])new Bson[]{finalQuery, Filters.eq((String)"_tenant", (Object)ParameterHelper.getTenantParameter())});
            if (crossTenant) {
                condition = Filters.or((Bson[])new Bson[]{condition, Filters.and((Bson[])new Bson[]{finalQuery, Filters.in((String)"evType", (Object[])LogbookCollections.MULTI_TENANT_EV_TYPES), Filters.eq((String)"_tenant", (Object)VitamConfiguration.getAdminTenant())})});
            }
            Bson projection = selectToMongoDb.getFinalProjection();
            MongoCollection collection = LogbookCollections.OPERATION.getCollection();
            FindIterable find = collection.find(condition).limit(1);
            if (projection != null) {
                find = find.projection(projection);
            }
            if ((result = (LogbookOperation)((Object)find.first())) != null) {
                return result;
            }
            throw new LogbookNotFoundException("Cannot find logbook with id " + eventIdentifierProcess);
        }
        catch (InvalidCreateOperationException | InvalidParseOperationException e) {
            throw new LogbookDatabaseException(e);
        }
    }

    private <T extends VitamDocument<?>> VitamMongoCursor<T> select(LogbookCollections collection, @Nonnull JsonNode select, @Nonnull ObjectNode slice, boolean isCrossTenant) throws LogbookDatabaseException, VitamDBException {
        try {
            SelectParserSingle parser = new SelectParserSingle((VarNameAdapter)new LogbookVarNameAdapter());
            parser.parse(select);
            parser.addProjection(slice, DEFAULT_ALLKEYS);
            if (LogbookCollections.OPERATION.equals((Object)collection)) {
                return this.findOperationsFromElasticsearch(collection, parser, isCrossTenant);
            }
            return this.findLifecyleLogbooksFromMongo(collection.getCollection(), parser);
        }
        catch (InvalidCreateOperationException | InvalidParseOperationException | LogbookException e) {
            throw new LogbookDatabaseException((Throwable)e);
        }
    }

    private <T extends VitamDocument<?>> VitamMongoCursor<T> select(LogbookCollections collection, JsonNode select, ObjectNode slice) throws LogbookDatabaseException, VitamDBException {
        return this.select(collection, select, slice, false);
    }

    private <T extends VitamDocument<?>> VitamMongoCursor<T> findLifecyleLogbooksFromMongo(MongoCollection<T> collection, SelectParserSingle parser) throws InvalidParseOperationException {
        SelectToMongodb selectToMongoDb = new SelectToMongodb((AbstractParser)parser);
        Bson condition = Filters.and((Bson[])new Bson[]{QueryToMongodb.getCommand((Query)selectToMongoDb.getSingleSelect().getQuery()), Filters.eq((String)"_tenant", (Object)ParameterHelper.getTenantParameter())});
        Bson projection = selectToMongoDb.getFinalProjection();
        Bson orderBy = selectToMongoDb.getFinalOrderBy();
        int offset = selectToMongoDb.getFinalOffset();
        int limit = selectToMongoDb.getFinalLimit();
        FindIterable find = collection.find(condition).skip(offset);
        if (projection != null) {
            find = find.projection(projection);
        }
        if (orderBy != null) {
            find = find.sort(orderBy);
        }
        if (limit > 0) {
            find = find.limit(limit);
        }
        return new VitamMongoCursor(find.iterator());
    }

    private <T extends VitamDocument<?>> VitamMongoCursor<T> findLifecyleLogbooksFromMongo(LogbookCollections collection, Select select) throws InvalidParseOperationException {
        SelectParserSingle parser = new SelectParserSingle((VarNameAdapter)new LogbookVarNameAdapter());
        parser.parse((JsonNode)select.getFinalSelect());
        return this.findLifecyleLogbooksFromMongo(collection.getCollection(), parser);
    }

    private VitamDocument<?> getDocument(LogbookParameters item) {
        if (item instanceof LogbookOperationParameters) {
            return new LogbookOperation((LogbookOperationParameters)item);
        }
        if (item instanceof LogbookLifeCycleUnitParameters) {
            return new LogbookLifeCycleUnitInProcess((LogbookLifeCycleUnitParameters)item);
        }
        return new LogbookLifeCycleObjectGroupInProcess((LogbookLifeCycleObjectGroupParameters)item);
    }

    private LogbookCollections fromInProcessToProdCollection(LogbookCollections collection) {
        if (LogbookCollections.LIFECYCLE_UNIT_IN_PROCESS.equals((Object)collection)) {
            return LogbookCollections.LIFECYCLE_UNIT;
        }
        if (LogbookCollections.LIFECYCLE_OBJECTGROUP_IN_PROCESS.equals((Object)collection)) {
            return LogbookCollections.LIFECYCLE_OBJECTGROUP;
        }
        return null;
    }

    private void updateLogbookLifeCycle(LogbookCollections inProcessCollection, String idLfc, LogbookParameters ... parameters) throws LogbookDatabaseException, LogbookNotFoundException, LogbookAlreadyExistsException {
        LogbookLifeCycle<?> lifeCycleInProd;
        String documentId;
        block8: {
            ParametersChecker.checkParameter((String)ITEM_CANNOT_BE_NULL, (Object[])new Object[]{inProcessCollection});
            if (parameters == null || parameters.length == 0) {
                throw new IllegalArgumentException(AT_LEAST_ONE_ITEM_IS_NEEDED);
            }
            LogbookTypeProcess processMode = parameters[0].getTypeProcess();
            documentId = idLfc != null ? idLfc : parameters[0].getParameterValue(LogbookParameterName.objectIdentifier);
            LogbookCollections prodCollection = this.fromInProcessToProdCollection(inProcessCollection);
            lifeCycleInProd = null;
            try {
                if (prodCollection != null && documentId != null) {
                    lifeCycleInProd = (LogbookLifeCycle<?>)((Object)this.getLogbookLFC(prodCollection.getCollection(), documentId));
                }
            }
            catch (LogbookNotFoundException e) {
                if (!LogbookTypeProcess.UPDATE.equals((Object)processMode)) break block8;
                throw e;
            }
        }
        if (lifeCycleInProd != null) {
            Object lifeCycleInProcess = null;
            try {
                lifeCycleInProcess = this.getLogbookLFC(inProcessCollection.getCollection(), documentId);
            }
            catch (LogbookNotFoundException e) {
                LOGGER.info(INIT_UPDATE_LIFECYCLE, (Throwable)((Object)e));
            }
            if (lifeCycleInProcess == null) {
                this.createLogbookLifeCycleForUpdate(inProcessCollection, lifeCycleInProd);
            }
        }
        this.updateLogbook(inProcessCollection, documentId, parameters);
    }

    @Override
    public void updateLogbookLifeCycleBulk(LogbookCollections collection, List<LogbookLifeCycleParametersBulk> logbookLifeCycleParametersBulk) {
        ParametersChecker.checkParameter((String)ITEM_CANNOT_BE_NULL, (Object[])new Object[]{collection});
        if (logbookLifeCycleParametersBulk == null || logbookLifeCycleParametersBulk.isEmpty()) {
            throw new IllegalArgumentException(AT_LEAST_ONE_ITEM_IS_NEEDED);
        }
        String lastPersistedDate = LocalDateUtil.nowFormatted();
        ArrayList<UpdateOneModel> updates = new ArrayList<UpdateOneModel>();
        for (LogbookLifeCycleParametersBulk lifeCycleParametersBulk : logbookLifeCycleParametersBulk) {
            String id = lifeCycleParametersBulk.getId();
            List lifeCycleParameters = lifeCycleParametersBulk.getLifeCycleParameters();
            List events = lifeCycleParameters.stream().map(event -> {
                if (event.getParameterValue(LogbookParameterName.eventDateTime) == null) {
                    event.putParameterValue(LogbookParameterName.eventDateTime, LocalDateUtil.nowFormatted());
                }
                LogbookLifeCycle logbookLifeCycle = new LogbookLifeCycle((LogbookParameters)event);
                this.removeDuplicatedInformation(logbookLifeCycle);
                logbookLifeCycle.append("_lastPersistedDate", lastPersistedDate);
                return logbookLifeCycle;
            }).collect(Collectors.toList());
            ArrayList<Bson> listMaster = new ArrayList<Bson>();
            listMaster.add(Updates.pushEach((String)"events", events));
            listMaster.add(Updates.inc((String)"_v", (Number)1));
            listMaster.add(Updates.set((String)"_lastPersistedDate", (Object)lastPersistedDate));
            updates.add(new UpdateOneModel(Filters.eq((String)"_id", (Object)id), Updates.combine(listMaster)));
        }
        BulkWriteResult bulkWriteResult = collection.getCollection().bulkWrite(updates, new BulkWriteOptions().ordered(false));
        if (bulkWriteResult.getModifiedCount() != logbookLifeCycleParametersBulk.size()) {
            throw new VitamRuntimeException(String.format("Error while bulk update document count : %s != size : %s :", bulkWriteResult.getModifiedCount(), logbookLifeCycleParametersBulk.size()));
        }
    }

    @Override
    public void updateLogbookLifeCycleUnit(String idOperation, String idLfc, LogbookLifeCycleUnitParameters lifecycleItem) throws LogbookDatabaseException, LogbookNotFoundException, LogbookAlreadyExistsException {
        this.updateLogbookLifeCycleUnit(idOperation, idLfc, lifecycleItem, false);
    }

    @Override
    public void updateLogbookLifeCycleUnit(String idOperation, String idLfc, LogbookLifeCycleUnitParameters lifecycleItem, boolean commit) throws LogbookDatabaseException, LogbookNotFoundException, LogbookAlreadyExistsException {
        if (!lifecycleItem.getParameterValue(LogbookParameterName.eventIdentifierProcess).equals(idOperation)) {
            throw new IllegalArgumentException("Wrong IdOperation set to update the LifeCycle");
        }
        if (commit) {
            this.updateLogbookLifeCycle(LogbookCollections.LIFECYCLE_UNIT, idLfc, new LogbookParameters[]{lifecycleItem});
        } else {
            this.updateLogbookLifeCycle(LogbookCollections.LIFECYCLE_UNIT_IN_PROCESS, idLfc, new LogbookParameters[]{lifecycleItem});
        }
    }

    @Override
    public void updateLogbookLifeCycleObjectGroup(String idOperation, String idLfc, LogbookLifeCycleObjectGroupParameters lifecycleItem) throws LogbookDatabaseException, LogbookNotFoundException, LogbookAlreadyExistsException {
        this.updateLogbookLifeCycleObjectGroup(idOperation, idLfc, lifecycleItem, false);
    }

    @Override
    public void updateLogbookLifeCycleObjectGroup(String idOperation, String idLfc, LogbookLifeCycleObjectGroupParameters lifecycleItem, boolean commit) throws LogbookDatabaseException, LogbookNotFoundException, LogbookAlreadyExistsException {
        if (!lifecycleItem.getParameterValue(LogbookParameterName.eventIdentifierProcess).equals(idOperation)) {
            throw new IllegalArgumentException("Wrong IdOperation set to update the LifeCycle");
        }
        if (commit) {
            this.updateLogbookLifeCycle(LogbookCollections.LIFECYCLE_OBJECTGROUP, idLfc, new LogbookParameters[]{lifecycleItem});
        } else {
            this.updateLogbookLifeCycle(LogbookCollections.LIFECYCLE_OBJECTGROUP_IN_PROCESS, idLfc, new LogbookParameters[]{lifecycleItem});
        }
    }

    void rollbackLogbookLifeCycle(LogbookCollections collection, String idOperation, String lifecycleItem) throws LogbookDatabaseException, LogbookNotFoundException {
        ParametersChecker.checkParameter((String)LIFECYCLE_ITEM, (String[])new String[]{lifecycleItem});
        try {
            DeleteResult result = collection.getCollection().deleteOne(Filters.and((Bson[])new Bson[]{Filters.eq((String)"_id", (Object)lifecycleItem), Filters.or((Bson[])new Bson[]{Filters.eq((String)LogbookMongoDbName.eventIdentifierProcess.getDbname(), (Object)idOperation), Filters.eq((String)("events." + LogbookMongoDbName.eventIdentifierProcess.getDbname()), (Object)idOperation)})}));
            if (result.getDeletedCount() != 1L) {
                throw new LogbookNotFoundException("Rollback issue not found: " + lifecycleItem);
            }
        }
        catch (MongoException e) {
            switch (this.getErrorCategory(e)) {
                case EXECUTION_TIMEOUT: {
                    throw new LogbookDatabaseException("Rollback issue (timeout operation)", e);
                }
            }
            throw new LogbookDatabaseException("Rollback issue (" + ((Object)((Object)e)).getClass().getName() + " " + e.getMessage() + ": " + e.getCode() + ")", e);
        }
    }

    @Override
    public void rollbackLogbookLifeCycleUnit(String idOperation, String lifecycleItem) throws LogbookDatabaseException, LogbookNotFoundException {
        this.rollbackLogbookLifeCycle(LogbookCollections.LIFECYCLE_UNIT_IN_PROCESS, idOperation, lifecycleItem);
    }

    @Override
    public void rollbackLogbookLifeCycleObjectGroup(String idOperation, String lifecycleItem) throws LogbookDatabaseException, LogbookNotFoundException {
        this.rollbackLogbookLifeCycle(LogbookCollections.LIFECYCLE_OBJECTGROUP_IN_PROCESS, idOperation, lifecycleItem);
    }

    private void createLogbook(String operationId, LogbookCollections collection, LogbookParameters ... items) throws LogbookDatabaseException, LogbookAlreadyExistsException {
        if (items == null || items.length == 0) {
            throw new IllegalArgumentException(AT_LEAST_ONE_ITEM_IS_NEEDED);
        }
        VitamDocument<?> document = this.initializeVitamDocument(operationId, Lists.newArrayList((Object[])items));
        try {
            collection.getCollection().insertOne(document);
            if (LogbookCollections.OPERATION.equals((Object)collection)) {
                this.insertIntoElasticsearch(collection, document);
            }
        }
        catch (MongoException e) {
            switch (this.getErrorCategory(e)) {
                case DUPLICATE_KEY: {
                    throw new LogbookAlreadyExistsException("Creation issue (element already exists)", e);
                }
                case EXECUTION_TIMEOUT: {
                    throw new LogbookDatabaseException("Creation issue (timeout operation)", e);
                }
            }
            throw new LogbookDatabaseException("Creation issue (" + ((Object)((Object)e)).getClass().getName() + " " + e.getMessage() + ": " + e.getCode() + ")", e);
        }
        catch (LogbookExecutionException e) {
            throw new LogbookDatabaseException((Throwable)((Object)e));
        }
    }

    @Override
    public void createLogbookOperation(String operationId, LogbookOperationParameters ... operationItems) throws LogbookDatabaseException, LogbookAlreadyExistsException {
        this.createLogbook(operationId, LogbookCollections.OPERATION, (LogbookParameters[])operationItems);
    }

    @Override
    public void createLogbookLifeCycleUnit(String operationId, LogbookLifeCycleUnitParameters ... lifecycleItems) throws LogbookDatabaseException, LogbookAlreadyExistsException {
        this.createLogbook(operationId, LogbookCollections.LIFECYCLE_UNIT_IN_PROCESS, (LogbookParameters[])lifecycleItems);
    }

    @Override
    public void createLogbookLifeCycleObjectGroup(String operationId, LogbookLifeCycleObjectGroupParameters ... lifecycleItems) throws LogbookDatabaseException, LogbookAlreadyExistsException {
        this.createLogbook(operationId, LogbookCollections.LIFECYCLE_OBJECTGROUP_IN_PROCESS, (LogbookParameters[])lifecycleItems);
    }

    private void updateLogbook(LogbookCollections collection, String documentId, LogbookParameters ... items) throws LogbookDatabaseException, LogbookNotFoundException {
        if (items == null || items.length == 0) {
            throw new IllegalArgumentException(AT_LEAST_ONE_ITEM_IS_NEEDED);
        }
        ArrayList events = new ArrayList(items.length);
        String lastPersistedDate = LocalDateUtil.nowFormatted();
        ArrayList<Bson> listMaster = new ArrayList<Bson>();
        for (LogbookParameters item : items) {
            VitamDocument<?> currentEvent = this.getDocument(item);
            this.removeDuplicatedInformation(currentEvent);
            listMaster.addAll(this.checkCopyToMaster(collection, item));
            events.add(currentEvent);
        }
        if (!LogbookCollections.OPERATION.equals((Object)collection)) {
            for (Document document : events) {
                document.append("_lastPersistedDate", (Object)lastPersistedDate);
            }
        }
        listMaster.add(Updates.pushEach((String)"events", events));
        listMaster.add(Updates.inc((String)"_v", (Number)1));
        listMaster.add(Updates.set((String)"_lastPersistedDate", (Object)lastPersistedDate));
        try {
            VitamDocument result = (VitamDocument)collection.getCollection().findOneAndUpdate(Filters.eq((String)"_id", (Object)documentId), Updates.combine(listMaster), new FindOneAndUpdateOptions().returnDocument(ReturnDocument.AFTER));
            if (result == null) {
                throw new LogbookNotFoundException(UPDATE_NOT_FOUND_ITEM + documentId);
            }
            if (LogbookCollections.OPERATION.equals((Object)collection)) {
                this.updateIntoElasticsearch(collection, result);
            }
        }
        catch (MongoException e) {
            switch (this.getErrorCategory(e)) {
                case EXECUTION_TIMEOUT: {
                    throw new LogbookDatabaseException("Update issue (timeout operation)", e);
                }
            }
            throw new LogbookDatabaseException("Update issue (" + ((Object)((Object)e)).getClass().getName() + " " + e.getMessage() + ": " + e.getCode() + ")", e);
        }
        catch (LogbookExecutionException e) {
            throw new LogbookDatabaseException((Throwable)((Object)e));
        }
    }

    @Override
    public void updateLogbookOperation(String operationId, LogbookOperationParameters ... operationItems) throws LogbookDatabaseException, LogbookNotFoundException {
        this.updateLogbook(LogbookCollections.OPERATION, operationId, (LogbookParameters[])operationItems);
    }

    @Override
    public void updateLogbookLifeCycleUnit(LogbookLifeCycleUnitParameters ... lifecycleItems) throws LogbookDatabaseException, LogbookNotFoundException, LogbookAlreadyExistsException {
        this.updateLogbookLifeCycle(LogbookCollections.LIFECYCLE_UNIT_IN_PROCESS, null, (LogbookParameters[])lifecycleItems);
    }

    @Override
    public void updateLogbookLifeCycleObjectGroup(LogbookLifeCycleObjectGroupParameters ... lifecycleItems) throws LogbookDatabaseException, LogbookNotFoundException, LogbookAlreadyExistsException {
        this.updateLogbookLifeCycle(LogbookCollections.LIFECYCLE_OBJECTGROUP_IN_PROCESS, null, (LogbookParameters[])lifecycleItems);
    }

    @Override
    @VisibleForTesting
    public void deleteCollectionForTesting(LogbookCollections collection) throws DatabaseException, LogbookExecutionException {
        Integer tenantId = VitamThreadUtils.getVitamSession().getTenantId();
        long count = collection.getCollection().countDocuments(Filters.eq((String)"_tenant", (Object)tenantId));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(collection.getName() + " count before: " + count);
        }
        if (count > 0L) {
            DeleteResult result = collection.getCollection().deleteMany((Bson)new Document().append("_tenant", (Object)tenantId));
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(collection.getName() + " result.result.getDeletedCount(): " + result.getDeletedCount());
            }
            if (LogbookCollections.OPERATION.equals((Object)collection)) {
                this.esClient.purgeIndexForTesting(collection, tenantId);
            }
            if (result.getDeletedCount() != count) {
                throw new DatabaseException(String.format("%s: Delete %s from %s elements", collection.getName(), result.getDeletedCount(), count));
            }
        }
    }

    @Override
    public LogbookLifeCycleUnitInProcess getLogbookLifeCycleUnitInProcess(String unitId) throws LogbookDatabaseException, LogbookNotFoundException {
        return (LogbookLifeCycleUnitInProcess)((Object)this.getLogbookLFC(LogbookCollections.LIFECYCLE_UNIT_IN_PROCESS.getCollection(), unitId));
    }

    @Override
    public LogbookLifeCycleObjectGroupInProcess getLogbookLifeCycleObjectGroupInProcess(String objectGroupId) throws LogbookDatabaseException, LogbookNotFoundException {
        return (LogbookLifeCycleObjectGroupInProcess)((Object)this.getLogbookLFC(LogbookCollections.LIFECYCLE_OBJECTGROUP_IN_PROCESS.getCollection(), objectGroupId));
    }

    @Override
    public void createLogbookLifeCycleUnit(LogbookLifeCycleUnitInProcess logbookLifeCycleUnitInProcess) throws LogbookDatabaseException, LogbookAlreadyExistsException {
        ParametersChecker.checkParameter((String)ITEM_CANNOT_BE_NULL, (Object[])new Object[]{logbookLifeCycleUnitInProcess});
        try {
            LogbookLifeCycleUnit logbookLifeCycleUnit = new LogbookLifeCycleUnit(BsonHelper.stringify((Document)logbookLifeCycleUnitInProcess));
            String lastPersistedDate = LocalDateUtil.nowFormatted();
            logbookLifeCycleUnit.append("_lastPersistedDate", lastPersistedDate);
            List events = (List)logbookLifeCycleUnit.get("events");
            for (Document event : events) {
                event.append("_lastPersistedDate", (Object)lastPersistedDate);
            }
            LogbookCollections.LIFECYCLE_UNIT.getCollection().insertOne((Object)logbookLifeCycleUnit);
        }
        catch (MongoException e) {
            switch (this.getErrorCategory(e)) {
                case DUPLICATE_KEY: {
                    throw new LogbookAlreadyExistsException("Creation issue (element already exists)", e);
                }
                case EXECUTION_TIMEOUT: {
                    throw new LogbookDatabaseException("Creation issue (timeout operation)", e);
                }
            }
            throw new LogbookDatabaseException("Creation issue (" + ((Object)((Object)e)).getClass().getName() + " " + e.getMessage() + ": " + e.getCode() + ")", e);
        }
    }

    @Override
    public void createLogbookLifeCycleObjectGroup(LogbookLifeCycleObjectGroupInProcess logbookLifeCycleObjectGroupInProcess) throws LogbookDatabaseException, LogbookAlreadyExistsException {
        ParametersChecker.checkParameter((String)ITEM_CANNOT_BE_NULL, (Object[])new Object[]{logbookLifeCycleObjectGroupInProcess});
        try {
            LogbookLifeCycleObjectGroup logbookLifeCycleObjectGroup = new LogbookLifeCycleObjectGroup(BsonHelper.stringify((Document)logbookLifeCycleObjectGroupInProcess));
            String lastPersistedDate = LocalDateUtil.nowFormatted();
            logbookLifeCycleObjectGroup.append("_lastPersistedDate", lastPersistedDate);
            List events = (List)logbookLifeCycleObjectGroup.get("events");
            for (Document event : events) {
                event.append("_lastPersistedDate", (Object)lastPersistedDate);
            }
            LogbookCollections.LIFECYCLE_OBJECTGROUP.getCollection().insertOne((Object)logbookLifeCycleObjectGroup);
        }
        catch (MongoException e) {
            switch (this.getErrorCategory(e)) {
                case DUPLICATE_KEY: {
                    throw new LogbookAlreadyExistsException("Creation issue (element already exists)", e);
                }
                case EXECUTION_TIMEOUT: {
                    throw new LogbookDatabaseException("Creation issue (timeout operation)", e);
                }
            }
            throw new LogbookDatabaseException("Creation issue (" + ((Object)((Object)e)).getClass().getName() + " " + e.getMessage() + ": " + e.getCode() + ")", e);
        }
    }

    private void rollBackLifeCyclesByOperation(LogbookCollections isProcessCollection, String operationId) throws LogbookNotFoundException, LogbookDatabaseException {
        ParametersChecker.checkParameter((String)OPERATION_ITEM, (String[])new String[]{operationId});
        try {
            DeleteResult result = isProcessCollection.getCollection().deleteMany(Filters.or((Bson[])new Bson[]{Filters.eq((String)LogbookMongoDbName.eventIdentifierProcess.getDbname(), (Object)operationId), Filters.eq((String)("events." + LogbookMongoDbName.eventIdentifierProcess.getDbname()), (Object)operationId)}));
            if (result.getDeletedCount() == 0L) {
                throw new LogbookNotFoundException("Rollback issue not found: " + operationId);
            }
        }
        catch (MongoException e) {
            switch (this.getErrorCategory(e)) {
                case EXECUTION_TIMEOUT: {
                    throw new LogbookDatabaseException("Rollback issue (timeout operation)", e);
                }
            }
            throw new LogbookDatabaseException("Rollback issue (" + ((Object)((Object)e)).getClass().getName() + " " + e.getMessage() + ": " + e.getCode() + ")", e);
        }
    }

    private void createLogbookLifeCycleForUpdate(LogbookCollections inProccessCollection, LogbookLifeCycle<?> logbookLifeCycleInProd) throws LogbookDatabaseException, LogbookAlreadyExistsException {
        ParametersChecker.checkParameter((String)ITEM_CANNOT_BE_NULL, (Object[])new Object[]{logbookLifeCycleInProd});
        try {
            LogbookLifeCycle logbookLifeCycleInProcess = null;
            if (LogbookCollections.LIFECYCLE_UNIT_IN_PROCESS.equals((Object)inProccessCollection)) {
                logbookLifeCycleInProcess = new LogbookLifeCycleUnitInProcess(BsonHelper.stringify(logbookLifeCycleInProd));
            } else if (LogbookCollections.LIFECYCLE_OBJECTGROUP_IN_PROCESS.equals((Object)inProccessCollection)) {
                logbookLifeCycleInProcess = new LogbookLifeCycleObjectGroup(BsonHelper.stringify(logbookLifeCycleInProd));
            }
            if (logbookLifeCycleInProcess == null) {
                throw new LogbookDatabaseException("Creation issue (timeout operation)");
            }
            logbookLifeCycleInProcess.remove("events");
            logbookLifeCycleInProcess.append(LogbookLifeCycleMongoDbName.eventTypeProcess.getDbname(), LogbookTypeProcess.UPDATE.toString());
            logbookLifeCycleInProcess.append("events", Collections.emptyList());
            logbookLifeCycleInProcess.append("_lastPersistedDate", LocalDateUtil.nowFormatted());
            inProccessCollection.getCollection().insertOne((Object)logbookLifeCycleInProcess);
        }
        catch (MongoException e) {
            switch (this.getErrorCategory(e)) {
                case DUPLICATE_KEY: {
                    throw new LogbookAlreadyExistsException("Creation issue (element already exists)", e);
                }
                case EXECUTION_TIMEOUT: {
                    throw new LogbookDatabaseException("Creation issue (timeout operation)", e);
                }
            }
            throw new LogbookDatabaseException("Creation issue (" + ((Object)((Object)e)).getClass().getName() + " " + e.getMessage() + ": " + e.getCode() + ")", e);
        }
    }

    @Override
    public void updateLogbookLifeCycleUnit(LogbookLifeCycleUnitInProcess logbookLifeCycleUnitInProcess) throws LogbookDatabaseException, LogbookNotFoundException {
        ParametersChecker.checkParameter((String)ITEM_CANNOT_BE_NULL, (Object[])new Object[]{logbookLifeCycleUnitInProcess});
        String logbookLifeCycleId = logbookLifeCycleUnitInProcess.getId();
        String lastPersistedDate = LocalDateUtil.nowFormatted();
        try {
            LogbookTypeProcess typeProcess;
            ArrayList<Bson> listUpdates = new ArrayList<Bson>();
            List events = (List)logbookLifeCycleUnitInProcess.get("events");
            for (Document event : events) {
                event.append("_lastPersistedDate", (Object)lastPersistedDate);
            }
            listUpdates.add(Updates.addEachToSet((String)"events", (List)events));
            listUpdates.add(Updates.inc((String)"_v", (Number)1));
            listUpdates.add(Updates.set((String)"_lastPersistedDate", (Object)lastPersistedDate));
            Bson update = Updates.combine(listUpdates);
            UpdateResult result = LogbookCollections.LIFECYCLE_UNIT.getCollection().updateOne(Filters.eq((String)"_id", (Object)logbookLifeCycleId), update);
            if (result.getMatchedCount() != 1L) {
                throw new LogbookNotFoundException(UPDATE_NOT_FOUND_ITEM + logbookLifeCycleId);
            }
            List newEvents = (List)logbookLifeCycleUnitInProcess.get("events");
            if (newEvents != null && !newEvents.isEmpty() && !LogbookTypeProcess.INGEST.equals((Object)(typeProcess = LogbookTypeProcess.valueOf((String)((Document)newEvents.get(0)).get((Object)LogbookLifeCycleMongoDbName.eventTypeProcess.getDbname()).toString())))) {
                LogbookCollections.LIFECYCLE_UNIT_IN_PROCESS.getCollection().deleteOne((Bson)logbookLifeCycleUnitInProcess);
            }
        }
        catch (MongoException e) {
            switch (this.getErrorCategory(e)) {
                case EXECUTION_TIMEOUT: {
                    throw new LogbookDatabaseException("Update issue (timeout operation)", e);
                }
            }
            throw new LogbookDatabaseException("Update issue (" + ((Object)((Object)e)).getClass().getName() + " " + e.getMessage() + ": " + e.getCode() + ")", e);
        }
    }

    @Override
    public void updateLogbookLifeCycleObjectGroup(LogbookLifeCycleObjectGroupInProcess logbookLifeCycleObjectGrouptInProcess) throws LogbookDatabaseException, LogbookNotFoundException {
        ParametersChecker.checkParameter((String)ITEM_CANNOT_BE_NULL, (Object[])new Object[]{logbookLifeCycleObjectGrouptInProcess});
        String logbookLifeCycleId = logbookLifeCycleObjectGrouptInProcess.getId();
        String lastPersistedDate = LocalDateUtil.nowFormatted();
        try {
            LogbookTypeProcess typeProcess;
            ArrayList<Bson> listUpdates = new ArrayList<Bson>();
            List events = logbookLifeCycleObjectGrouptInProcess.getList("events", Document.class);
            for (Document event : events) {
                event.append("_lastPersistedDate", (Object)lastPersistedDate);
            }
            listUpdates.add(Updates.addEachToSet((String)"events", (List)events));
            listUpdates.add(Updates.inc((String)"_v", (Number)1));
            listUpdates.add(Updates.set((String)"_lastPersistedDate", (Object)lastPersistedDate));
            Bson update = Updates.combine(listUpdates);
            UpdateResult result = LogbookCollections.LIFECYCLE_OBJECTGROUP.getCollection().updateOne(Filters.eq((String)"_id", (Object)logbookLifeCycleId), update);
            if (result.getMatchedCount() != 1L) {
                throw new LogbookNotFoundException(UPDATE_NOT_FOUND_ITEM + logbookLifeCycleId);
            }
            List newEvents = logbookLifeCycleObjectGrouptInProcess.getList("events", Document.class);
            if (newEvents != null && !newEvents.isEmpty() && !LogbookTypeProcess.INGEST.equals((Object)(typeProcess = LogbookTypeProcess.valueOf((String)((Document)newEvents.get(0)).get((Object)LogbookLifeCycleMongoDbName.eventTypeProcess.getDbname()).toString())))) {
                LogbookCollections.LIFECYCLE_OBJECTGROUP_IN_PROCESS.getCollection().deleteOne((Bson)logbookLifeCycleObjectGrouptInProcess);
            }
        }
        catch (MongoException e) {
            switch (this.getErrorCategory(e)) {
                case EXECUTION_TIMEOUT: {
                    throw new LogbookDatabaseException("Update issue (timeout operation)", e);
                }
            }
            throw new LogbookDatabaseException("Update issue (" + ((Object)((Object)e)).getClass().getName() + " " + e.getMessage() + ": " + e.getCode() + ")", e);
        }
    }

    @Override
    public void rollBackUnitLifeCyclesByOperation(String operationId) throws LogbookNotFoundException, LogbookDatabaseException {
        this.rollBackLifeCyclesByOperation(LogbookCollections.LIFECYCLE_UNIT_IN_PROCESS, operationId);
    }

    @Override
    public void rollBackObjectGroupLifeCyclesByOperation(String operationId) throws LogbookNotFoundException, LogbookDatabaseException {
        this.rollBackLifeCyclesByOperation(LogbookCollections.LIFECYCLE_OBJECTGROUP_IN_PROCESS, operationId);
    }

    @Override
    public boolean existsLogbookLifeCycleUnitInProcess(String unitId) throws LogbookDatabaseException {
        ParametersChecker.checkParameter((String)LIFECYCLE_ITEM, (String[])new String[]{unitId});
        return this.exists(LogbookCollections.LIFECYCLE_UNIT_IN_PROCESS, unitId);
    }

    @Override
    public boolean existsLogbookLifeCycleObjectGroupInProcess(String objectGroupId) throws LogbookDatabaseException {
        ParametersChecker.checkParameter((String)LIFECYCLE_ITEM, (String[])new String[]{objectGroupId});
        return this.exists(LogbookCollections.LIFECYCLE_OBJECTGROUP_IN_PROCESS, objectGroupId);
    }

    private <T extends VitamDocument<?>> VitamMongoCursor<T> findOperationsFromElasticsearch(LogbookCollections collection, SelectParserSingle parser, boolean isCrossTenant) throws InvalidParseOperationException, InvalidCreateOperationException, LogbookException, VitamDBException {
        SelectToElasticsearch requestToEs = new SelectToElasticsearch((AbstractParser)parser);
        DynamicParserTokens parserTokens = new DynamicParserTokens(collection.getVitamDescriptionResolver(), this.ontologyLoader.loadOntologies());
        List sorts = requestToEs.getFinalOrderBy(collection.getVitamCollection().isUseScore(), parserTokens);
        ResponseBody<ObjectNode> elasticSearchResponse = isCrossTenant ? collection.getEsClient().searchCrossIndices(collection, ParameterHelper.getTenantParameter(), requestToEs.getNthQueries(0, (VarNameAdapter)new LogbookVarNameAdapter(), parserTokens), sorts, requestToEs.getFinalOffset(), requestToEs.getFinalLimit()) : collection.getEsClient().search(collection, ParameterHelper.getTenantParameter(), requestToEs.getNthQueries(0, (VarNameAdapter)new LogbookVarNameAdapter(), parserTokens), sorts, requestToEs.getFinalOffset(), requestToEs.getFinalLimit());
        HitsMetadata hits = elasticSearchResponse.hits();
        if (hits.total() == null || hits.total().value() == 0L) {
            return new VitamMongoCursor((MongoCursor)new EmptyMongoCursor());
        }
        List idsSorted = hits.hits().stream().map(Hit::id).collect(Collectors.toList());
        parser.getRequest().setQuery((Query)new NopQuery());
        return new VitamMongoCursor(DbRequestHelper.selectMongoDbExecuteThroughFakeMongoCursor(collection.getVitamCollection(), (RequestParserSingle)parser, idsSorted, null), hits.total().value(), elasticSearchResponse.scrollId());
    }

    private <T> void insertIntoElasticsearch(LogbookCollections collection, VitamDocument<T> vitamDocument) throws LogbookExecutionException {
        Integer tenantId = ParameterHelper.getTenantParameter();
        LOGGER.debug("insert to elasticsearch");
        String id = vitamDocument.getId();
        vitamDocument.remove((Object)"_id");
        vitamDocument.remove((Object)"_score");
        LogbookTransformData.transformDataForElastic(vitamDocument);
        collection.getEsClient().indexEntry(collection, tenantId, id, vitamDocument);
    }

    private <T> void updateIntoElasticsearch(LogbookCollections collection, VitamDocument<T> existingDocument) throws LogbookExecutionException {
        Integer tenantId = ParameterHelper.getTenantParameter();
        LOGGER.debug("updateIntoElasticsearch");
        String id = (String)existingDocument.remove((Object)"_id");
        existingDocument.remove((Object)"_score");
        LogbookTransformData.transformDataForElastic(existingDocument);
        collection.getEsClient().updateFullDocument(collection, tenantId, id, existingDocument);
    }

    private List<Bson> checkCopyToMaster(LogbookCollections collection, LogbookParameters item) throws LogbookNotFoundException, LogbookDatabaseException {
        String masterData = item.getParameterValue(LogbookParameterName.masterData);
        if (!ParametersChecker.isNotEmpty((String[])new String[]{masterData})) {
            return Collections.emptyList();
        }
        String mainLogbookDocumentId = this.getDocument(item).getId();
        Document oldValue = (Document)collection.getCollection().find(Filters.eq((String)"_id", (Object)mainLogbookDocumentId)).projection(Projections.include((String[])new String[]{"_id", "evDetData"})).first();
        if (oldValue == null) {
            throw new LogbookNotFoundException("Cannot find logbook with id " + mainLogbookDocumentId);
        }
        ArrayList<Bson> updates = new ArrayList<Bson>();
        try {
            JsonNode evDetData;
            String fieldValue;
            JsonNode master = JsonHandler.getFromString((String)masterData);
            ObjectNode oldEvDetData = JsonHandler.createObjectNode();
            Object evdevObj = oldValue.get((Object)LogbookMongoDbName.eventDetailData.getDbname());
            if (evdevObj != null) {
                String old = evdevObj instanceof String ? (String)evdevObj : JsonHandler.unprettyPrint((Object)evdevObj);
                try {
                    JsonNode node = JsonHandler.getFromString((String)old);
                    if (node instanceof ObjectNode) {
                        oldEvDetData = (ObjectNode)node;
                    } else {
                        LOGGER.warn("Bad evDevData : {}", (Object)old);
                    }
                }
                catch (InvalidParseOperationException e) {
                    LOGGER.warn("Bad evDevData : {}", (Object)old, (Object)e);
                }
            }
            Iterator fieldNames = master.fieldNames();
            while (fieldNames.hasNext()) {
                String fieldName = (String)fieldNames.next();
                fieldValue = master.get(fieldName).asText();
                try {
                    LogbookParameterName name = LogbookParameterName.valueOf((String)fieldName);
                    String mongoDbName = LogbookMongoDbName.getLogbookMongoDbName(name).getDbname();
                    if (mongoDbName.equals(LogbookMongoDbName.eventDetailData.getDbname())) continue;
                    updates.add(Updates.set((String)mongoDbName, (Object)fieldValue));
                }
                catch (IllegalArgumentException e) {
                    LOGGER.warn("Could not find logbook parameter name with value {}", (Object)fieldName);
                }
            }
            if (master.has(LogbookMongoDbName.eventDetailData.name()) && (evDetData = JsonHandler.getFromString((String)master.get(LogbookMongoDbName.eventDetailData.name()).asText())) != null && !evDetData.equals((Object)JsonHandler.createObjectNode())) {
                oldEvDetData.setAll((ObjectNode)evDetData);
                fieldValue = JsonHandler.writeAsString((Object)oldEvDetData);
                updates.add(Updates.set((String)LogbookMongoDbName.eventDetailData.getDbname(), (Object)fieldValue));
            }
        }
        catch (InvalidParseOperationException e) {
            LOGGER.error("masterData is not parsable as a json. Analyse cancelled: " + masterData, (Throwable)e);
            throw new LogbookDatabaseException("Could not parse event masterdata", e);
        }
        return updates;
    }

    private void removeDuplicatedInformation(VitamDocument<?> document) {
        document.remove((Object)"events");
        document.remove((Object)"_id");
        document.remove((Object)"_tenant");
        document.remove((Object)"_lastPersistedDate");
        if (document.get((Object)LogbookMongoDbName.rightsStatementIdentifier.getDbname()) == null || ((String)document.get((Object)LogbookMongoDbName.rightsStatementIdentifier.getDbname())).isEmpty()) {
            document.remove((Object)LogbookMongoDbName.rightsStatementIdentifier.getDbname());
        }
        document.remove((Object)LogbookMongoDbName.agentIdentifierApplication.getDbname());
        document.remove((Object)LogbookMongoDbName.agentIdentifierApplicationSession.getDbname());
        if (document.get((Object)LogbookMongoDbName.agIdExt.getDbname()) == null || ((String)document.get((Object)LogbookMongoDbName.agIdExt.getDbname())).isEmpty()) {
            document.remove((Object)LogbookMongoDbName.agIdExt.getDbname());
        }
        if (document.get((Object)LogbookMongoDbName.objectIdentifier.getDbname()) == null || ((String)document.get((Object)LogbookMongoDbName.objectIdentifier.getDbname())).isEmpty()) {
            document.remove((Object)LogbookMongoDbName.objectIdentifier.getDbname());
        }
        if (document.get((Object)LogbookMongoDbName.eventIdentifierRequest.getDbname()) == null || ((String)document.get((Object)LogbookMongoDbName.eventIdentifierRequest.getDbname())).isEmpty()) {
            document.remove((Object)LogbookMongoDbName.eventIdentifierRequest.getDbname());
        }
        if (document.get((Object)LogbookMongoDbName.objectIdentifierRequest.getDbname()) == null || ((String)document.get((Object)LogbookMongoDbName.objectIdentifierRequest.getDbname())).isEmpty()) {
            document.remove((Object)LogbookMongoDbName.objectIdentifierRequest.getDbname());
        }
        if (document.get((Object)LogbookMongoDbName.objectIdentifierIncome.getDbname()) == null || ((String)document.get((Object)LogbookMongoDbName.objectIdentifierIncome.getDbname())).isEmpty()) {
            document.remove((Object)LogbookMongoDbName.objectIdentifierIncome.getDbname());
        }
    }

    @Override
    public void bulkInsert(String operationId, LogbookCollections lifecycleUnit, List<? extends LogbookLifeCycleModel> logbookLifeCycleModels) throws DatabaseException {
        List vitamDocuments = logbookLifeCycleModels.stream().map(item -> {
            ArrayList items = new ArrayList(item.getLogbookLifeCycleParameters());
            VitamDocument<?> document = this.initializeVitamDocument(operationId, items);
            return new InsertOneModel(document);
        }).collect(Collectors.toList());
        if (!vitamDocuments.isEmpty()) {
            BulkWriteOptions options = new BulkWriteOptions().ordered(false);
            try {
                lifecycleUnit.getCollection().bulkWrite(vitamDocuments, options);
            }
            catch (MongoException e) {
                throw new DatabaseException((Throwable)e);
            }
        }
    }

    private VitamDocument<?> initializeVitamDocument(String operationId, List<? extends LogbookParameters> items) {
        VitamDocument<?> document = this.getDocument(items.get(0));
        ArrayList events = new ArrayList(items.size() - 1);
        for (int i = 1; i < items.size(); ++i) {
            VitamDocument<?> currentEvent = this.getDocument(items.get(i));
            this.removeDuplicatedInformation(currentEvent);
            events.add(currentEvent);
        }
        document.append("evIdProc", (Object)operationId);
        document.append("events", events);
        document.append("_tenant", (Object)ParameterHelper.getTenantParameter());
        document.append("_v", (Object)0);
        document.append("_lastPersistedDate", (Object)LocalDateUtil.nowFormatted());
        return document;
    }

    static {
        for (LogbookMongoDbName name : LogbookMongoDbName.values()) {
            DEFAULT_ALLKEYS.put(name.getDbname(), 1);
        }
        DEFAULT_ALLKEYS.put("_tenant", 1);
        DEFAULT_ALLKEYS.put("_v", 1);
        DEFAULT_ALLKEYS.put("_lastPersistedDate", 1);
        DEFAULT_ALLKEYS.put("_id", 1);
    }
}

