/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.logbook.common.server.database.collections;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Streams;
import com.mongodb.client.MongoDatabase;
import fr.gouv.vitam.common.exception.DatabaseException;
import fr.gouv.vitam.common.model.config.CollectionConfiguration;
import fr.gouv.vitam.logbook.common.server.config.DefaultCollectionConfiguration;
import fr.gouv.vitam.logbook.common.server.config.ElasticsearchLogbookIndexManager;
import fr.gouv.vitam.logbook.common.server.config.GroupedTenantConfiguration;
import fr.gouv.vitam.logbook.common.server.config.LogbookConfiguration;
import fr.gouv.vitam.logbook.common.server.config.LogbookIndexationConfiguration;
import fr.gouv.vitam.logbook.common.server.database.collections.LogbookCollections;
import fr.gouv.vitam.logbook.common.server.database.collections.LogbookElasticsearchAccess;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bson.Document;
import org.bson.conversions.Bson;

@VisibleForTesting
public final class LogbookCollectionsTestUtils {
    private LogbookCollectionsTestUtils() {
    }

    @VisibleForTesting
    public static ElasticsearchLogbookIndexManager createTestIndexManager(List<Integer> dedicatedTenants, Map<String, List<Integer>> tenantGroups, String elasticSearchConfigurationFilePath) {
        List<Integer> allTenants = Streams.concat((Stream[])new Stream[]{dedicatedTenants.stream(), tenantGroups.values().stream().flatMap(Collection::stream)}).collect(Collectors.toList());
        List<GroupedTenantConfiguration> tenantGroupConfiguration = tenantGroups.entrySet().stream().map(entry -> new GroupedTenantConfiguration().setName((String)entry.getKey()).setTenants(((List)entry.getValue()).stream().map(Object::toString).collect(Collectors.joining(",")))).collect(Collectors.toList());
        LogbookConfiguration logbookConfiguration = new LogbookConfiguration().setLogbookTenantIndexation(new LogbookIndexationConfiguration().setDefaultCollectionConfiguration(new DefaultCollectionConfiguration().setLogbookoperation(new CollectionConfiguration(Integer.valueOf(1), Integer.valueOf(0)))).setGroupedTenantConfiguration(tenantGroupConfiguration));
        logbookConfiguration.setElasticsearchConfigurationFile(elasticSearchConfigurationFilePath);
        return new ElasticsearchLogbookIndexManager(logbookConfiguration, allTenants);
    }

    @VisibleForTesting
    public static void beforeTestClass(MongoDatabase db, String prefix, LogbookElasticsearchAccess esClient) {
        for (LogbookCollections collection : LogbookCollections.values()) {
            collection.getVitamCollection().setName(prefix + collection.getClasz().getSimpleName());
            collection.initialize(db, false);
            if (collection != LogbookCollections.OPERATION) continue;
            collection.initialize(esClient);
        }
        if (esClient != null) {
            esClient.createIndexesAndAliases();
        }
    }

    @VisibleForTesting
    public static void afterTestClass(ElasticsearchLogbookIndexManager indexManager, boolean deleteEsIndexes) {
        try {
            for (LogbookCollections collection : LogbookCollections.values()) {
                if (null != collection.getVitamCollection().getCollection()) {
                    collection.getVitamCollection().getCollection().deleteMany((Bson)new Document());
                }
                if (collection != LogbookCollections.OPERATION || null == collection.getEsClient()) continue;
                for (Integer tenant : indexManager.getDedicatedTenants()) {
                    if (deleteEsIndexes) {
                        collection.getEsClient().deleteIndexByAliasForTesting(indexManager.getElasticsearchIndexAliasResolver(collection).resolveIndexName(tenant));
                        continue;
                    }
                    collection.getEsClient().purgeIndexForTesting(indexManager.getElasticsearchIndexAliasResolver(collection).resolveIndexName(tenant));
                }
                for (String tenantGroupName : indexManager.getTenantGroups()) {
                    Integer tenant = indexManager.getTenantGroupTenants(tenantGroupName).iterator().next();
                    if (deleteEsIndexes) {
                        collection.getEsClient().deleteIndexByAliasForTesting(indexManager.getElasticsearchIndexAliasResolver(collection).resolveIndexName(tenant));
                        continue;
                    }
                    collection.getEsClient().purgeIndexForTesting(indexManager.getElasticsearchIndexAliasResolver(collection).resolveIndexName(tenant));
                }
            }
        }
        catch (DatabaseException e) {
            throw new RuntimeException(e);
        }
    }

    @VisibleForTesting
    public static void afterTest(ElasticsearchLogbookIndexManager indexManager) {
        LogbookCollectionsTestUtils.afterTestClass(indexManager, false);
    }
}

